set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '22341230',
      NULL,
      '12322402',
      '11041404',
      NULL,
      '34211312',
      '22320203',
      '20300233',
      NULL,
      NULL,
      NULL,
      NULL,
      '00331311',
      '20134221',
      '14142441',
      NULL,
      NULL,
      '34242333',
      '21143213',
      '33114142',
      NULL,
      '12031313',
      '40241404',
      '01232341',
      '00024333',
      NULL,
      '30202222',
      NULL,
      '21200401',
      '31021123',
      '31433342',
      '03423243',
      NULL,
      '14244041',
      '43201402',
      '12423231',
      '33422213',
      '40224410',
      '42104120',
      '23443220',
      NULL,
      '02343041',
      '40314231',
      '21330003',
      '304',
      '30',
      NULL,
      NULL,
      '1142330',
      NULL,
      44,
      0,
      NULL,
      '223000',
      2.529336,
      ' 8-22-1976',
      ' 1-12-1977',
      22.146484,
      NULL,
      15,
      4.347432,
      NULL,
      14,
      49,
      6,
      15,
      NULL,
      9,
      2.961052,
      11.284584,
      1,
      0.543224,
      NULL,
      14,
      1,
      30,
      0.463989,
      31.986784,
      NULL,
      NULL,
      17,
      NULL,
      32,
      7.239438,
      4,
      99.491404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.605571,
      0.391087,
      6,
      0.756785,
      0,
      NULL,
      1.726525,
      0.274221,
      NULL,
      1.194710,
      0,
      1,
      0.835817,
      1.593199,
      1,
      NULL,
      0,
      NULL,
      0.609968,
      1.760600,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 1-2001',
      NULL,
      6.094442,
      59,
      3,
      63,
      1.129295,
      ' 1-25-1986',
      0,
      1.990091,
      35,
      3,
      1.186951,
      106,
      3.070065,
      0.312400,
      18.284353,
      NULL,
      0,
      133,
      ' 9-18-1982',
      13,
      56.884302,
      74.742269,
      NULL,
      NULL,
      35,
      7.199942,
      NULL,
      32.625774,
      NULL,
      1.743278,
      54.700470,
      ' 6- 1-2001',
      1.476974,
      3,
      1.995692,
      18,
      35,
      8.321361,
      5,
      ' 4-12-2002',
      20.970537,
      16.497347,
      ' 7-26-1993',
      NULL,
      8,
      8,
      18,
      16.649106,
      3,
      3.094667,
      6.857636,
      0.691599,
      NULL,
      3,
      5,
      10,
      4.496806,
      0,
      3,
      NULL,
      NULL,
      ' 3-27-1982',
      0,
      NULL,
      1,
      NULL,
      117.643327,
      NULL,
      ' 4-27-1998',
      NULL,
      NULL,
      NULL,
      18.824653,
      ' 9- 2-2000',
      5,
      '10-11-1979',
      NULL,
      9,
      ' 3- 7-1988',
      NULL,
      10.504856,
      ' 2- 4-1979',
      NULL,
      7.380570,
      ' 8-17-2002',
      1.616076,
      0.862990,
      '11-17-1986',
      0,
      0,
      NULL,
      ' 8-29-1975',
      62.244904,
      39,
      22,
      ' 0-15-1982',
      NULL,
      166.506538,
      ' 5-24-1986',
      NULL,
      88,
      23,
      15,
      ' 2-11-1975',
      30.653982,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


