set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22044340',
      '21331222',
      '23023114',
      '23010124',
      '22401420',
      '31403403',
      '12013134',
      '23112313',
      NULL,
      '34000011',
      NULL,
      NULL,
      '10422222',
      '13204343',
      '23103222',
      '41103433',
      NULL,
      '44040042',
      '04214344',
      '40202131',
      '01443020',
      '23423024',
      '44410332',
      NULL,
      NULL,
      '32441124',
      '11432024',
      '32342144',
      '20142010',
      '24140103',
      '00201034',
      '22123044',
      '41433243',
      '23140334',
      '40041430',
      NULL,
      '21311421',
      '32233203',
      NULL,
      '10302204',
      '12403333',
      '44223234',
      '02233143',
      '42441231',
      NULL,
      '40',
      NULL,
      14.770951,
      '1032001',
      0.165170,
      131,
      3,
      NULL,
      '203333',
      3.643328,
      ' 6- 1-1995',
      ' 9-26-1997',
      90,
      97.004112,
      9,
      13,
      0,
      6,
      7,
      NULL,
      21,
      11,
      9.519060,
      NULL,
      29.207144,
      4,
      34.415211,
      21.940719,
      11,
      5.488621,
      12,
      19,
      44.755044,
      18,
      21.422160,
      16.969348,
      1,
      3.852977,
      144,
      23.547183,
      121,
      15,
      77,
      '11-23-1996',
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      ' 8-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.013525,
      6.049146,
      4.662381,
      3,
      13,
      5,
      '11-18-1984',
      1.288378,
      NULL,
      77,
      1,
      NULL,
      NULL,
      1,
      0.526298,
      29.895694,
      NULL,
      NULL,
      NULL,
      ' 4-18-2000',
      6,
      63,
      10.402955,
      0,
      13,
      3.789864,
      50,
      57.724290,
      21,
      36.509334,
      59,
      23.127637,
      ' 8- 7-1990',
      NULL,
      12.093582,
      0.541494,
      32.377770,
      NULL,
      1.841792,
      NULL,
      ' 0-13-1975',
      16.777101,
      1.165062,
      ' 8-11-1993',
      4.872769,
      12.412972,
      12,
      17.894422,
      23.209525,
      2.573811,
      NULL,
      28,
      0,
      59.393113,
      0.546043,
      NULL,
      11,
      NULL,
      NULL,
      0,
      2.920775,
      0.249789,
      ' 5-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      25.836817,
      2,
      ' 9- 8-1977',
      NULL,
      NULL,
      NULL,
      32,
      ' 1-26-1984',
      19.664784,
      ' 6- 1-1992',
      15.673861,
      14.154537,
      ' 3- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-29-1996',
      NULL,
      38.471178,
      1,
      NULL,
      0,
      NULL,
      ' 9- 4-1984',
      2,
      NULL,
      NULL,
      NULL,
      '10- 3-1992',
      21.407954,
      1,
      134.132092,
      ' 3-23-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


