set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '1',
      '4',
      '3',
      '0',
      '1',
      '4',
      '0',
      '3',
      '4',
      '3',
      '2',
      '0',
      '2',
      NULL,
      '3',
      '1',
      '3',
      '0',
      '0',
      '3',
      '3',
      '3',
      '',
      '2',
      '',
      NULL,
      '4',
      '3',
      '0',
      '2',
      '',
      '',
      '2',
      '3',
      '0',
      '3',
      '3',
      '3',
      '0',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '10011414',
      25.024730,
      30.775724,
      '4102003',
      0.787825,
      NULL,
      2,
      NULL,
      '302420',
      0,
      ' 7- 5-1999',
      ' 0-16-1995',
      152.172858,
      110,
      27,
      17,
      27.789793,
      17,
      72.317441,
      3,
      11.664465,
      8.804445,
      20.888984,
      0.591443,
      NULL,
      14.256481,
      NULL,
      22,
      3.350401,
      0.696730,
      49,
      2,
      10,
      15.159591,
      35.045264,
      15,
      NULL,
      57,
      NULL,
      NULL,
      177,
      NULL,
      179,
      '11-10-1989',
      22.258754,
      9,
      27.937327,
      0.061330,
      82,
      47,
      ' 9-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      16,
      9.116721,
      8,
      2,
      '10- 2-1983',
      1.565223,
      2,
      42.663466,
      0,
      1.836270,
      NULL,
      2,
      1,
      57.113770,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1989',
      NULL,
      61.221135,
      27.481686,
      46,
      2,
      22,
      4.807891,
      58,
      NULL,
      57.967039,
      23,
      9.133632,
      ' 9-13-1988',
      NULL,
      2,
      6.965184,
      NULL,
      19,
      NULL,
      5,
      ' 9-12-2002',
      8.022638,
      24.919175,
      NULL,
      6.108871,
      13,
      13.430192,
      1.846475,
      7,
      2.138923,
      1,
      NULL,
      14.441867,
      58.975753,
      0,
      2.634491,
      20,
      1,
      5,
      1,
      0,
      2.674204,
      ' 5- 4-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.003472,
      ' 5-24-1998',
      NULL,
      NULL,
      NULL,
      45.072418,
      ' 0- 9-1987',
      15,
      NULL,
      17,
      19.568100,
      ' 8-26-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 1- 8-1985',
      51.729286,
      16,
      34.107253,
      ' 7-22-1997',
      NULL,
      1.917603,
      ' 2-26-1983',
      10,
      NULL,
      2.816083,
      34.225568,
      ' 6-15-1988',
      14,
      0,
      82.157885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


