set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2113',
      '22302044',
      NULL,
      '41234020',
      '33213402',
      '42433222',
      '24432200',
      '14022444',
      '31411141',
      '22001014',
      '00221203',
      NULL,
      '22234021',
      '40244222',
      '40030121',
      '10413224',
      '12114244',
      '02223331',
      '41101002',
      NULL,
      '22430032',
      '13434314',
      '40334442',
      '40444322',
      '04130422',
      '10320130',
      '11120042',
      NULL,
      '32300414',
      '04030103',
      '32101124',
      '43134131',
      '11441024',
      '10132011',
      '12201341',
      '13244243',
      '10332422',
      '41223440',
      NULL,
      NULL,
      '11024002',
      '13310303',
      '10243240',
      '02310240',
      '34303444',
      '',
      '',
      NULL,
      NULL,
      '4123320',
      0.395728,
      1.298671,
      NULL,
      NULL,
      '220133',
      3,
      ' 6-15-1993',
      ' 8-22-1985',
      20,
      NULL,
      18.288918,
      10,
      11.551031,
      16,
      NULL,
      NULL,
      2.940246,
      3.803684,
      15,
      13,
      27,
      8.308350,
      29.900683,
      9,
      16.998046,
      12,
      54.871421,
      0,
      22,
      9,
      76.272432,
      7,
      NULL,
      92,
      52,
      29.566935,
      NULL,
      47.418717,
      137,
      '11-13-1990',
      13.322459,
      1.742840,
      18.841462,
      13,
      NULL,
      NULL,
      ' 9-18-1988',
      NULL,
      3.986842,
      0.156410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.085710,
      1.467302,
      0,
      3.817170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1989',
      61,
      62.694308,
      NULL,
      21,
      NULL,
      101.131648,
      64,
      81.011555,
      17.065789,
      0.696230,
      79,
      17.394991,
      ' 8-26-1985',
      12.573624,
      11.528899,
      10,
      53.244910,
      5.402854,
      77.647568,
      0,
      ' 4-24-1976',
      1,
      24,
      ' 3-10-1991',
      9,
      21.095815,
      15,
      13,
      NULL,
      6.906055,
      NULL,
      18,
      NULL,
      21.715851,
      5,
      12,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      ' 3-21-2002',
      2,
      396.410328,
      ' 5- 2-1990',
      15.919722,
      7.953062,
      5.800043,
      23,
      ' 4-21-2001',
      29,
      1.344825,
      58.630076,
      ' 9-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      45,
      3.050311,
      64.337483,
      31.865305,
      3.912923,
      4,
      1.401123,
      11.960598,
      13.555703,
      0,
      1,
      31.234668,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.202852,
      9.465873,
      NULL,
      1.133572,
      48.827652,
      0.091543,
      0,
      1.173279,
      0,
      NULL,
      NULL,
      42,
      63.325283,
      48.619861,
      6,
      51,
      NULL,
      3,
      31.163323,
      NULL,
      NULL,
      0.074458,
      6.283009,
      35.332882,
      1,
      0.909391,
      0.873375,
      39,
      NULL,
      17,
      54.438017,
      13,
      2.880370,
      8.919539,
      10.031647,
      71,
      23.615561,
      31,
      21,
      1.606748,
      NULL,
      1,
      NULL,
      1,
      0.391103,
      0.748715,
      53.021922,
      ' 6- 5-1985',
      ' 1- 0-1998',
      ' 5-23-2001',
      ' 0- 7-1991',
      ' 4-14-1976',
      NULL,
      ' 6-16-1999',
      NULL);
commit;
end;
/


