set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1312',
      '14121334',
      '23311402',
      '32323400',
      '03031402',
      '11230013',
      '34423303',
      NULL,
      '02124420',
      '41441212',
      '34103143',
      '24304301',
      '23314322',
      '23224434',
      '11230003',
      '22001134',
      '11024121',
      '13434214',
      '32042201',
      NULL,
      '03031001',
      '00131234',
      '40430401',
      '44232143',
      NULL,
      '20131010',
      '31300323',
      '24101410',
      '10421013',
      '23334240',
      '24410314',
      NULL,
      '14212343',
      NULL,
      '11042344',
      '31431201',
      '00123303',
      '03112120',
      NULL,
      '03040131',
      '33421014',
      '02012432',
      '00313011',
      '34211240',
      '11140304',
      '',
      '',
      NULL,
      NULL,
      '0133002',
      1,
      NULL,
      1,
      NULL,
      '223113',
      2,
      ' 1- 3-1991',
      ' 8-22-1999',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.575339,
      32.211663,
      5,
      0.627467,
      87.917473,
      75.271124,
      '11- 3-1998',
      NULL,
      1.922567,
      NULL,
      0.552882,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.919683,
      1,
      1.731385,
      0.573379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-13-1982',
      5.639838,
      10.122608,
      95,
      16,
      NULL,
      56,
      2,
      NULL,
      63,
      41,
      35.214905,
      51.304824,
      '11-10-2002',
      11,
      11.880019,
      13,
      49.129659,
      35.788815,
      NULL,
      8,
      ' 9-29-1989',
      10.590082,
      15.020120,
      ' 2-17-2001',
      6.677935,
      1.834436,
      9,
      3.924749,
      3,
      5,
      NULL,
      NULL,
      NULL,
      34,
      1.578337,
      1.796575,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-15-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      1.295648,
      1.593891,
      49.810026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329273,
      3.585790,
      91.749126,
      1,
      1.379858,
      NULL,
      NULL,
      2.792866,
      NULL,
      0,
      NULL,
      114.028226,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.654107,
      NULL,
      NULL,
      NULL,
      54.622823,
      1.328944,
      1,
      3,
      0.113392,
      0.212717,
      0.909642,
      18.850784,
      1.312009,
      NULL,
      8.477193,
      4.774374,
      1,
      0,
      5,
      24.607855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      1.938283,
      6,
      NULL,
      2.682599,
      0,
      0.271508,
      23,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1979',
      '10- 5-1993',
      NULL,
      '10-16-1974',
      NULL);
commit;
end;
/


