set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3242',
      '33131300',
      '43304030',
      NULL,
      '13104330',
      '33211320',
      '30113203',
      '00312030',
      '34004033',
      '23104412',
      '01331140',
      '11131110',
      '03440323',
      '31240321',
      '22121041',
      '31130231',
      '23312422',
      '10230004',
      '10400230',
      '04203221',
      '10304232',
      NULL,
      '23203330',
      '22342100',
      '22411043',
      NULL,
      '41203432',
      '33130244',
      '20320230',
      '41001122',
      '44321320',
      '41214332',
      '40310234',
      '20444401',
      '11112232',
      NULL,
      '30413220',
      '00134320',
      NULL,
      NULL,
      '22133020',
      '42422321',
      '22442404',
      '00110424',
      '33442412',
      '010',
      '33',
      NULL,
      NULL,
      '1103232',
      2.922810,
      38.546028,
      1,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1985',
      NULL,
      6.720574,
      NULL,
      27.240513,
      19,
      10.850872,
      5.746317,
      33,
      13,
      5,
      7,
      NULL,
      7,
      8,
      15.276881,
      13,
      NULL,
      15,
      7,
      22.480161,
      1,
      33.881017,
      11,
      NULL,
      1.344816,
      1.034681,
      4,
      NULL,
      27,
      99,
      80,
      103.477327,
      ' 6-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      0.779741,
      1.505016,
      NULL,
      1,
      NULL,
      0,
      3.095076,
      0,
      0,
      1.175776,
      1,
      1.211934,
      1.241384,
      NULL,
      0,
      1.098097,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-20-2000',
      NULL,
      29,
      NULL,
      3.571166,
      34,
      3.762678,
      ' 4-19-1987',
      3.199320,
      0,
      NULL,
      NULL,
      3,
      73,
      NULL,
      2.581324,
      NULL,
      1.871239,
      NULL,
      NULL,
      '10- 4-2001',
      5,
      66.737403,
      86,
      28,
      NULL,
      73,
      70,
      64,
      NULL,
      NULL,
      NULL,
      48,
      ' 8- 0-1991',
      NULL,
      3.499623,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      ' 2-15-1999',
      11,
      11.981202,
      ' 3-14-1978',
      2,
      14,
      13,
      NULL,
      12,
      8.466040,
      1.377735,
      5.199888,
      2,
      16.323217,
      1.199506,
      0,
      NULL,
      21.397432,
      8,
      NULL,
      1.389148,
      1,
      ' 3-25-1992',
      NULL,
      NULL,
      NULL,
      '11- 7-1983',
      52.926022,
      0,
      ' 0- 7-1999',
      NULL,
      NULL,
      NULL,
      38,
      ' 5-18-1990',
      24,
      ' 2-19-2003',
      NULL,
      7,
      ' 1-17-1977',
      61.220097,
      77,
      NULL,
      NULL,
      0.023068,
      NULL,
      0,
      2,
      ' 4- 3-1981',
      2,
      3,
      NULL,
      ' 0-14-1980',
      3,
      18.467592,
      28.489783,
      NULL,
      NULL,
      540,
      ' 2-10-1997',
      10,
      60,
      9,
      67,
      ' 9-20-1986',
      9.758176,
      0,
      16,
      ' 5-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.443916);
commit;
end;
/


