set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0414',
      '01220431',
      '11103311',
      NULL,
      '42210032',
      '11220232',
      '30141300',
      NULL,
      '21130031',
      '03403241',
      '00042322',
      '30412342',
      '23104242',
      '00420004',
      '02034032',
      '23201103',
      '10022131',
      '32011123',
      '11204144',
      NULL,
      '04200103',
      '13413442',
      '14033000',
      '31121202',
      '20320313',
      '31001311',
      '42032400',
      '13100034',
      '23224024',
      '31004200',
      NULL,
      '10200432',
      '20141103',
      '42131204',
      '41444334',
      '23421010',
      NULL,
      '14431431',
      '14213222',
      NULL,
      '11014321',
      NULL,
      '14342012',
      '02241210',
      '11121334',
      '203',
      '01',
      31,
      11.542273,
      '3200312',
      NULL,
      139,
      1,
      NULL,
      NULL,
      2.184674,
      '11-14-1974',
      ' 9-23-1989',
      109,
      60.788606,
      NULL,
      NULL,
      7.267152,
      12.402936,
      54.644053,
      14,
      1,
      6,
      27.233933,
      NULL,
      17,
      9.601922,
      1.691408,
      1,
      10.701358,
      5,
      47.231656,
      15,
      5.218599,
      5.468480,
      64,
      3,
      NULL,
      49.740786,
      NULL,
      17.703133,
      1,
      44.444975,
      168,
      ' 5- 0-1988',
      NULL,
      35,
      8.739452,
      2.752570,
      107.410819,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.386459,
      30,
      0,
      NULL,
      20.611546,
      3,
      NULL,
      0,
      1.850856,
      2,
      0,
      1.558248,
      NULL,
      0,
      1,
      57,
      NULL,
      NULL,
      NULL,
      ' 0-20-1997',
      1.984764,
      0.166236,
      95.786070,
      1,
      67.860571,
      10,
      22.567785,
      77.023534,
      39,
      NULL,
      81.205269,
      24,
      NULL,
      10.641719,
      NULL,
      5,
      NULL,
      53.632784,
      19.907507,
      NULL,
      '11- 6-1974',
      4,
      17.228020,
      ' 4-19-1977',
      5,
      8.207562,
      11,
      11.081252,
      NULL,
      6.220847,
      NULL,
      NULL,
      1.819603,
      77,
      3.531003,
      4,
      NULL,
      15.967569,
      NULL,
      2,
      5.925291,
      1.580347,
      ' 5-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      9.603597,
      ' 1-17-1974',
      NULL,
      NULL,
      NULL,
      10,
      '10- 8-1983',
      23,
      NULL,
      6.069171,
      3,
      NULL,
      NULL,
      8,
      ' 7-24-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      8.062452,
      ' 0- 0-1976',
      NULL,
      NULL,
      37,
      ' 8-23-1981',
      1.546190,
      NULL,
      '10-24-1974',
      0,
      68,
      NULL,
      56,
      ' 3- 0-1976',
      50.995098,
      0.272486,
      107,
      '11-20-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


