set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '3',
      NULL,
      '2',
      '0',
      '4',
      '4',
      '4',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '4',
      '0',
      '4',
      '3',
      '2',
      '0',
      '2',
      '0',
      '4',
      NULL,
      '2',
      '',
      '1',
      '3',
      '2',
      NULL,
      '3',
      NULL,
      '',
      NULL,
      '4',
      '3',
      '0',
      '3',
      '4',
      NULL,
      '4',
      '3',
      '1',
      '2',
      NULL,
      '00113332',
      39.582843,
      47.159594,
      '3113201',
      2.830375,
      233,
      2,
      1,
      '212341',
      0,
      ' 9-18-1979',
      ' 3-13-1975',
      NULL,
      71.374967,
      0.209213,
      13.693072,
      4,
      NULL,
      38,
      12,
      6.462394,
      4,
      NULL,
      13,
      17,
      17,
      28.863681,
      14.347220,
      10,
      4.452635,
      9.859178,
      0,
      NULL,
      3,
      16.507896,
      6,
      0.424215,
      13,
      150,
      24,
      5.674901,
      32,
      126.664250,
      ' 3-25-1976',
      33.879637,
      33.087308,
      8,
      NULL,
      76,
      40,
      ' 0-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      10.625204,
      11.971729,
      NULL,
      4.980782,
      ' 2-23-1979',
      1.877282,
      0.428880,
      108,
      1,
      1.591009,
      1.368260,
      1.080272,
      NULL,
      19.434004,
      NULL,
      NULL,
      NULL,
      ' 5-12-1991',
      46,
      20,
      34.024715,
      59,
      NULL,
      99.929961,
      73.094517,
      6,
      71.421174,
      69,
      8,
      84.960253,
      ' 2-19-1998',
      14,
      15,
      NULL,
      32.484862,
      49,
      2,
      6,
      '11-28-1987',
      NULL,
      8.448456,
      ' 4-26-1995',
      8,
      NULL,
      11,
      19.801159,
      NULL,
      NULL,
      0.921824,
      5,
      1.071602,
      18,
      9,
      0,
      0,
      NULL,
      0,
      4,
      2,
      0,
      ' 8-29-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      ' 1-23-1977',
      NULL,
      NULL,
      NULL,
      35.810706,
      '11-22-1975',
      20,
      ' 4- 6-1993',
      4,
      8,
      NULL,
      NULL,
      34.406039,
      ' 1-14-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      11,
      ' 9- 8-1976',
      55.830073,
      35.127052,
      NULL,
      ' 2-11-1983',
      0,
      322,
      ' 9-21-1989',
      4.404542,
      32,
      NULL,
      20.128593,
      ' 4- 5-1979',
      36.439797,
      1,
      NULL,
      ' 1-16-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


