set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9783232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '4',
      '3',
      '2',
      '3',
      '0',
      NULL,
      '4',
      '3',
      '4',
      '4',
      NULL,
      NULL,
      '0',
      '2',
      '3',
      NULL,
      '3',
      '3',
      NULL,
      '2',
      '4',
      '3',
      '',
      '2',
      '',
      '4',
      NULL,
      '3',
      '3',
      '4',
      '',
      '',
      '0',
      '3',
      '1',
      '4',
      '3',
      '4',
      '3',
      '1',
      '3',
      NULL,
      '0',
      '211',
      '42132433',
      NULL,
      NULL,
      '1032102',
      1,
      0.814252,
      0,
      NULL,
      '112340',
      1,
      ' 7-13-1990',
      ' 1- 7-2000',
      80,
      207.673951,
      35,
      20.759552,
      NULL,
      12.445642,
      48,
      14,
      20,
      12.387311,
      0,
      15,
      0,
      2.033221,
      1.156609,
      9.805793,
      NULL,
      8.553004,
      22.244222,
      NULL,
      33,
      17.304455,
      121,
      NULL,
      1.511783,
      49.818982,
      65,
      97.815626,
      42.202512,
      NULL,
      188,
      ' 7-20-1985',
      17,
      63,
      21.692781,
      13.790836,
      113,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.635125,
      9,
      5.070677,
      15,
      NULL,
      ' 9- 9-1996',
      NULL,
      0.828584,
      34,
      0,
      1.306954,
      113,
      NULL,
      1.535908,
      2.758813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.891428,
      90,
      77.535030,
      32.588348,
      19.472551,
      64.962376,
      85.564349,
      64.450123,
      NULL,
      4.944394,
      46,
      NULL,
      31.273500,
      NULL,
      17,
      55,
      52.393518,
      NULL,
      5,
      '10- 1-1981',
      NULL,
      3.618756,
      ' 0- 5-1984',
      NULL,
      9,
      21,
      9.772864,
      6,
      0,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      17.714768,
      20,
      2.895301,
      NULL,
      1.553467,
      1.224690,
      ' 5- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      0,
      ' 1- 3-2000',
      NULL,
      NULL,
      NULL,
      29,
      ' 6- 3-1991',
      2.328575,
      ' 3- 8-1988',
      0,
      NULL,
      '10-15-1990',
      138,
      127,
      ' 7- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      ' 9-10-2003',
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      69.463832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


