set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01131323',
      NULL,
      '24301202',
      '30121312',
      NULL,
      NULL,
      '24131141',
      '12014043',
      '02114233',
      '13240311',
      NULL,
      '13121313',
      '20124033',
      '04132334',
      '30303211',
      '32323000',
      '40044011',
      NULL,
      '43310234',
      '02411420',
      '14342310',
      '34401124',
      NULL,
      '32143431',
      NULL,
      NULL,
      '31311031',
      '34410241',
      '30443424',
      '01034421',
      '31401142',
      '33013242',
      '32403022',
      '00144013',
      '01242420',
      '44334111',
      '10032113',
      NULL,
      '41120400',
      '02014143',
      '21200213',
      NULL,
      '14043012',
      '02143242',
      '',
      '',
      NULL,
      NULL,
      '1331432',
      NULL,
      0.971502,
      3,
      NULL,
      '000000',
      NULL,
      ' 9-15-1982',
      ' 0- 2-1991',
      41,
      NULL,
      13.949608,
      NULL,
      26.251672,
      12.181857,
      57,
      0.802316,
      1.091585,
      6.407141,
      NULL,
      15,
      40,
      18.241733,
      13.719454,
      8.853523,
      NULL,
      4,
      NULL,
      14,
      18,
      5.297310,
      25.082265,
      NULL,
      NULL,
      79.825833,
      NULL,
      34.404889,
      41,
      77,
      117.353956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.530117,
      1.609910,
      0.383963,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.832080,
      1.857014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1977',
      73,
      106,
      77,
      NULL,
      NULL,
      48.706195,
      58,
      27,
      64,
      85.868545,
      133,
      47.167495,
      ' 1-20-1974',
      NULL,
      NULL,
      NULL,
      19.788100,
      67.776506,
      139.490394,
      2,
      '10- 0-1984',
      4.911163,
      3,
      ' 9-17-2002',
      10.411543,
      3.921590,
      3.640678,
      6,
      6,
      9.391661,
      NULL,
      1,
      NULL,
      45.419943,
      12.901428,
      1.782421,
      8.363601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.619526,
      2.856459,
      24.187979,
      NULL,
      0.815435,
      58,
      ' 7-19-1997',
      NULL,
      85.338986,
      4,
      0.593803,
      '10-20-1993',
      35,
      0,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      0.283098,
      83,
      87.012818,
      NULL,
      2.035569,
      5.447706,
      5.662337,
      5,
      11,
      76,
      1.402076,
      1.299496,
      58,
      NULL,
      NULL,
      NULL,
      1.426700,
      0,
      25.712441,
      NULL,
      1,
      82,
      2.096151,
      NULL,
      NULL,
      1,
      2.666723,
      1.931161,
      0,
      0.879509,
      1,
      NULL,
      NULL,
      NULL,
      45,
      70,
      7,
      53,
      45,
      1,
      0.960619,
      NULL,
      0.777701,
      1.078520,
      1.665536,
      31,
      0.120996,
      84.517090,
      NULL,
      93.747662,
      0,
      0.556268,
      57,
      2,
      19.212670,
      33,
      6,
      27,
      0,
      56,
      5,
      NULL,
      2,
      NULL,
      0,
      5.222279,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1997',
      NULL,
      ' 2-19-2000',
      ' 8-27-1997',
      ' 5-18-1974',
      NULL,
      ' 2- 8-2003',
      NULL);
commit;
end;
/


