set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      '3',
      '3',
      '0',
      '0',
      NULL,
      '4',
      '4',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '4',
      '3',
      '0',
      '4',
      '2',
      '1',
      '1',
      '3',
      '',
      '4',
      '',
      '4',
      '4',
      '4',
      '4',
      '0',
      NULL,
      '',
      '1',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '3',
      '3',
      '1',
      '3',
      '042',
      '31101344',
      57.155395,
      42,
      '0144004',
      2.338733,
      53,
      2,
      NULL,
      NULL,
      0.273840,
      ' 7- 5-1997',
      ' 3- 2-1996',
      80.435937,
      115,
      24.129948,
      14.603297,
      25.171176,
      13,
      60.618249,
      6.553716,
      4,
      NULL,
      3.577720,
      0.258984,
      NULL,
      4.758843,
      9,
      NULL,
      3.475945,
      4.686376,
      NULL,
      NULL,
      29.344048,
      8.458124,
      16,
      13,
      1,
      NULL,
      85.988169,
      7.970164,
      80.830547,
      134.343798,
      101,
      NULL,
      NULL,
      31,
      23.189437,
      7,
      NULL,
      NULL,
      ' 4- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      44,
      19,
      6,
      34,
      4.961174,
      ' 6-24-1980',
      0.744319,
      NULL,
      83,
      0.802191,
      2,
      91.139199,
      0.741505,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1977',
      NULL,
      57,
      NULL,
      NULL,
      3.087408,
      75.627024,
      67.739986,
      94.407831,
      92.376087,
      15.126469,
      NULL,
      5.672181,
      ' 7- 2-1998',
      10,
      1.549930,
      13,
      50.822503,
      15.112594,
      5.884971,
      9,
      ' 2- 0-1989',
      NULL,
      NULL,
      ' 6-16-1975',
      10,
      NULL,
      4.768807,
      2,
      1.958653,
      NULL,
      2.919871,
      NULL,
      0,
      23,
      2,
      NULL,
      0,
      8.403203,
      2.705399,
      0.932469,
      0.191418,
      NULL,
      '11-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      13.979278,
      NULL,
      ' 6-27-1989',
      NULL,
      NULL,
      NULL,
      34.541165,
      ' 2-21-1978',
      41.624483,
      ' 3-18-1990',
      NULL,
      3.929051,
      ' 0-15-2000',
      70.423538,
      33,
      ' 8-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      16,
      ' 4-10-1978',
      12,
      7.611968,
      6.123732,
      ' 1-19-1999',
      NULL,
      123.419861,
      ' 7-21-2003',
      8.466852,
      38,
      5,
      90,
      NULL,
      43,
      1,
      83.118037,
      ' 5-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


