set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '1',
      '4',
      '0',
      '2',
      NULL,
      '3',
      '1',
      '1',
      NULL,
      NULL,
      '2',
      '3',
      '4',
      NULL,
      '4',
      '1',
      '2',
      '1',
      '4',
      '0',
      '4',
      '',
      '4',
      NULL,
      '3',
      '1',
      '4',
      '0',
      '0',
      '',
      '',
      '2',
      '1',
      '4',
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      '1',
      '0',
      '2',
      NULL,
      '34121110',
      52,
      65.436811,
      '3210022',
      0,
      NULL,
      2,
      NULL,
      '404302',
      0.297614,
      ' 6- 3-1982',
      ' 2- 0-1979',
      34.701517,
      NULL,
      3.149588,
      5,
      23.941508,
      14.016648,
      8.306118,
      9.540994,
      0,
      18,
      15,
      NULL,
      30.828779,
      4,
      17.466114,
      14.366384,
      22,
      3.619577,
      NULL,
      33,
      NULL,
      24.421400,
      NULL,
      12,
      1.282212,
      54,
      113,
      18,
      49,
      79,
      121.610092,
      ' 0-10-1998',
      9,
      NULL,
      7.956817,
      NULL,
      110,
      151.552199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3.924180,
      NULL,
      9.898455,
      ' 7-23-1987',
      0,
      1.383345,
      103,
      NULL,
      0,
      55,
      0.018380,
      0.889963,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1981',
      68.473208,
      NULL,
      12,
      NULL,
      27,
      15,
      NULL,
      3.761258,
      34.169012,
      8,
      21,
      43,
      '11- 7-1975',
      7,
      7,
      0.268374,
      13.214258,
      40.248405,
      86.806666,
      4.110574,
      NULL,
      NULL,
      0.635841,
      ' 5-25-1981',
      0,
      1.545286,
      1,
      4.521391,
      14.793405,
      5,
      NULL,
      16.061052,
      3.463693,
      NULL,
      12,
      1.287461,
      13,
      NULL,
      0,
      5,
      1,
      0,
      ' 3-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      11.842936,
      NULL,
      ' 8-27-1984',
      NULL,
      NULL,
      NULL,
      44.102453,
      ' 7-23-1975',
      NULL,
      '11-26-1988',
      3.861758,
      1.031543,
      ' 7-21-1990',
      NULL,
      54.127016,
      ' 5- 6-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      29,
      ' 7-18-1998',
      NULL,
      38.565680,
      48,
      NULL,
      0,
      48.599825,
      ' 1-15-1982',
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      10,
      0.355813,
      34.405220,
      ' 5-25-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


