set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '4',
      NULL,
      '2',
      '2',
      '3',
      NULL,
      '1',
      '0',
      '0',
      '2',
      '0',
      '2',
      '0',
      '1',
      '4',
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      '',
      '4',
      '',
      '1',
      '4',
      '4',
      '2',
      NULL,
      '',
      '',
      '1',
      '2',
      '2',
      '4',
      '0',
      '3',
      '4',
      '1',
      NULL,
      '3',
      '4',
      '232',
      '04334144',
      NULL,
      58.151701,
      '3340322',
      1.968651,
      35,
      0,
      0,
      '000001',
      2.285212,
      ' 7- 6-1982',
      ' 4-16-1998',
      54,
      2,
      15,
      11.522696,
      1,
      15,
      76,
      NULL,
      6.579318,
      11.499766,
      15.230996,
      0,
      16,
      0.385685,
      2.027998,
      10,
      1.086509,
      3,
      95,
      13.713651,
      33,
      NULL,
      105,
      4.726415,
      1.541023,
      NULL,
      80,
      93.571779,
      63,
      72.463966,
      27,
      ' 5-18-1999',
      NULL,
      37.153188,
      13.686160,
      NULL,
      173,
      111.844209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      15.691091,
      6,
      NULL,
      18,
      2,
      ' 6-22-1990',
      0,
      0.607199,
      21.353683,
      1,
      NULL,
      17.072871,
      0,
      4.057662,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1980',
      69,
      11.871437,
      59.559344,
      81,
      NULL,
      19,
      64,
      55.005721,
      36,
      65.889117,
      45.475536,
      3.157488,
      ' 8- 0-1981',
      NULL,
      NULL,
      20,
      39,
      56.968371,
      83,
      NULL,
      NULL,
      NULL,
      16.474412,
      ' 4- 3-1981',
      NULL,
      1,
      NULL,
      NULL,
      3.768808,
      NULL,
      NULL,
      11.315661,
      1.777348,
      NULL,
      1.171538,
      0.934052,
      10,
      21,
      NULL,
      NULL,
      1,
      NULL,
      '11-18-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      218.103167,
      4,
      ' 2- 9-1974',
      NULL,
      NULL,
      NULL,
      14,
      ' 2-10-1993',
      38,
      NULL,
      12.226247,
      3.178964,
      ' 9- 3-1989',
      12.360578,
      75.405047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      15,
      ' 4- 7-1976',
      44.264242,
      NULL,
      2,
      ' 8-22-2003',
      0,
      1.728992,
      ' 6- 8-2000',
      1,
      83.698178,
      10,
      NULL,
      '10-27-1975',
      NULL,
      1,
      116.281160,
      ' 0- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


