set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0144',
      '34301014',
      '02031121',
      '14422341',
      '01040443',
      '24214102',
      '10320131',
      '23234211',
      '03413103',
      '21212421',
      '02104420',
      '42132323',
      NULL,
      '23104011',
      NULL,
      '32330413',
      '32333424',
      '44400201',
      '20411201',
      '31443334',
      '12023134',
      '31422402',
      '01430330',
      '31000400',
      '32012224',
      '43404341',
      '23302314',
      NULL,
      '41331134',
      '01344342',
      '14423442',
      '20142434',
      '13232220',
      '12230413',
      NULL,
      '42314200',
      '23110341',
      NULL,
      '23222022',
      '20030101',
      '42323012',
      NULL,
      '02104343',
      NULL,
      NULL,
      '401',
      '21',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '421334',
      5.827694,
      ' 6- 7-1997',
      '10-16-1989',
      36.511652,
      NULL,
      13.518084,
      NULL,
      NULL,
      NULL,
      NULL,
      17.667818,
      10,
      NULL,
      8,
      19,
      13,
      1,
      5,
      21.563078,
      NULL,
      NULL,
      4,
      11.897805,
      45,
      10,
      92.843179,
      15.822191,
      0,
      43.784652,
      12,
      26.234226,
      95.221083,
      178,
      220.052088,
      ' 1-29-2001',
      21.421638,
      68.995711,
      20,
      NULL,
      NULL,
      222,
      ' 2- 6-1999',
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      3,
      1.171634,
      1,
      1,
      0.436420,
      0,
      0,
      0,
      0,
      NULL,
      0.420781,
      0.531367,
      2.216077,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-1981',
      NULL,
      NULL,
      4.262030,
      2.537847,
      1,
      5.285085,
      ' 6-25-1990',
      NULL,
      0,
      40,
      1,
      1.343828,
      86.403597,
      0.089178,
      1.143834,
      78.536875,
      1.789410,
      5,
      185,
      ' 8-15-2003',
      NULL,
      64,
      NULL,
      47,
      75.610570,
      71.549105,
      46,
      63,
      5.556577,
      56.862071,
      71.399269,
      NULL,
      ' 8-13-1996',
      6.641640,
      6,
      18.782862,
      22.859682,
      40,
      10,
      3,
      ' 7- 9-1978',
      10,
      14,
      ' 6- 6-1991',
      12,
      5.342874,
      3,
      NULL,
      30.852540,
      NULL,
      1,
      15.723734,
      1.373766,
      34.211736,
      0,
      NULL,
      29,
      27.542434,
      1,
      NULL,
      0.443600,
      1.803089,
      ' 9-13-1993',
      9.343246,
      2.890361,
      3.700602,
      NULL,
      67.045666,
      0.216038,
      ' 5-21-1999',
      30,
      14.155981,
      ' 5-16-1992',
      6.198981,
      ' 3- 5-1993',
      NULL,
      ' 2- 8-1994',
      10.304870,
      NULL,
      NULL,
      2,
      4.884080,
      ' 5-26-1989',
      4,
      8,
      ' 5- 0-1985',
      5.403266,
      11.628429,
      ' 7- 0-1993',
      2,
      NULL,
      2.756225,
      ' 8-16-1979',
      48.551947,
      40,
      41,
      '11-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


