set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332012';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4031',
      '14133330',
      NULL,
      NULL,
      '14404144',
      '42104330',
      '34212442',
      NULL,
      '12024322',
      '12214412',
      '13202210',
      '32130043',
      '14242020',
      '21211002',
      '32322210',
      '12411410',
      '23310311',
      '43014211',
      '30423404',
      '11230102',
      '40112114',
      NULL,
      '42044010',
      '30223313',
      NULL,
      '21142001',
      '04413340',
      NULL,
      '42041020',
      '14220301',
      '04312142',
      '44312010',
      NULL,
      '02243330',
      '32210042',
      '12020101',
      NULL,
      '00013134',
      '23042334',
      NULL,
      '23242012',
      NULL,
      '30220002',
      '13210431',
      '04001101',
      NULL,
      '01',
      NULL,
      NULL,
      '0313211',
      2,
      NULL,
      0,
      NULL,
      '413240',
      NULL,
      ' 3-20-1990',
      ' 7- 0-1999',
      49,
      NULL,
      0,
      1,
      6,
      12,
      58,
      NULL,
      6.558382,
      10,
      14.147628,
      9,
      1,
      8.167156,
      13,
      6,
      16,
      2,
      NULL,
      0.156038,
      53,
      8.880626,
      NULL,
      NULL,
      1,
      27,
      91.709993,
      7.921632,
      143.830720,
      NULL,
      147,
      ' 9-27-1993',
      17,
      NULL,
      12.482520,
      15,
      83,
      42.753205,
      ' 0-21-1999',
      6,
      0.911037,
      4.792519,
      5.801398,
      9.997163,
      0,
      NULL,
      0,
      0,
      1.188774,
      2,
      1.876980,
      0,
      3.993190,
      0.793214,
      1.369457,
      0,
      0,
      0.915059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.244117,
      16.920715,
      NULL,
      3.427051,
      NULL,
      3.612823,
      ' 0- 4-1984',
      0,
      0.486743,
      73.079295,
      1,
      0,
      NULL,
      3.271326,
      1.015939,
      61.955871,
      NULL,
      NULL,
      NULL,
      '11- 8-1982',
      NULL,
      34.791963,
      NULL,
      18,
      76.396825,
      24.431373,
      55.910487,
      0,
      36,
      73,
      68,
      5,
      ' 6-11-1996',
      13,
      10.522778,
      NULL,
      32.895354,
      NULL,
      91.047847,
      6.940642,
      ' 4- 5-1982',
      2,
      5.773628,
      NULL,
      11,
      1,
      3.193846,
      8,
      11,
      4.155654,
      1,
      8.875569,
      0,
      NULL,
      3,
      6.264200,
      6.981150,
      NULL,
      2.542986,
      5.302399,
      0.950129,
      3.819271,
      ' 3-15-1991',
      3.324494,
      NULL,
      2,
      ' 7- 9-2001',
      9.535741,
      15.271682,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      4.502136,
      NULL,
      8,
      NULL,
      ' 2-28-1985',
      NULL,
      42,
      ' 2-17-1997',
      5.620509,
      1,
      ' 0- 0-1987',
      NULL,
      NULL,
      NULL,
      1,
      3,
      9,
      ' 2- 0-1995',
      20.281211,
      2.264733,
      4,
      ' 9- 9-1982',
      NULL,
      201.392607,
      ' 3-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


