
--Add cogbatx
create or replace procedure add_cogbatx_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
DOCNUM varchar2,
BATCHNUM varchar2,
ENT1 float,
ENT2 float,
ID varchar2,
ASS float,
FUPER float,
REL integer,
MED integer,
FRM varchar2,
VER float,
RATER float,
RATER2 float,
TEST varchar2,
DATE varchar,
SCORE float)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('cogbatx');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'BATCHNUM', 'varchar', 2, NULL, batchnum, NULL, batchnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'MED', 'integer', 9, med, to_char(med), med, to_char(med), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DOCNUM', 'varchar', 1, NULL, docnum, NULL, docnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 13, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FUPER', 'float', 7, fuper, to_char(fuper), fuper, to_char(fuper), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FRM', 'varchar', 10, NULL, frm, NULL, frm, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT1', 'float', 3, ent1, to_char(ent1), ent1, to_char(ent1), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DATE', 'timestamp', 15, NULL, date, NULL, date, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SCORE', 'float', 16, score, to_char(score), score, to_char(score), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT2', 'float', 4, ent2, to_char(ent2), ent2, to_char(ent2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 12, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'REL', 'integer', 8, rel, to_char(rel), rel, to_char(rel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TEST', 'varchar', 14, NULL, test, NULL, test, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'VER', 'float', 11, ver, to_char(ver), ver, to_char(ver), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 5, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 6, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_cogbatx_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
