
--Add control
create or replace procedure control(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('control', 'control', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'CA28', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL PREVIOUS OCCUPATION');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 1, 'Maj Profession', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 2, 'Min Profession', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 3, 'Sales', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 4, 'Skilled emp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 5, 'Unskilled emp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 6, 'Student', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 7, 'Home', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA28', 8, 'Unemployed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA29', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL CURRENT OCCUPATION');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'CA247', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL THROWING BALL HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA26', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SUBJECT RETIRED?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA27', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL LENGTH OF UNEMPLOYMENT (MOS)');

add_assessment_score(v_id1, owner_id, owner_id, 'CA24', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MARITAL STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 1, 'Never', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 2, 'Married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 3, 'Seperated', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 4, 'Divorced', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 5, 'Divorced/Remarried', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 6, 'Divorced 2+/ not married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 7, 'Divorced 2+/ married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA24', 8, 'Widowed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA25', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL CURRENT OCCUPATIONAL STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA284', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL CLOSE YOUR EYES');

add_assessment_score(v_id1, owner_id, owner_id, 'CA259', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RIGHT HAND BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA263', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL LEFT HAND SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL DATE THE FORM WAS FILLED OUT');

add_assessment_score(v_id1, owner_id, owner_id, 'CA244', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL FORCED HAND PREFERENCE CHANGE?');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA286', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL COPY DESIGN');

add_assessment_score(v_id1, owner_id, owner_id, 'CA249', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL HOLDING KNIFE HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA248', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"CONTROL SWINGING CLUB, BAT HAND"');

add_assessment_score(v_id1, owner_id, owner_id, 'CA269', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL LEFT HAND DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA268', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RIGHT HAND DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA281', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL NAME A PENCIL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA280', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL RECALL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA243', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SUBJECT THINKS HANDEDNESS?');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA243', 3, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CA264', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MIXED HAND SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA267', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MIXED HAND SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA266', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL LEFT HAND SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA261', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MIXED HAND BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA246', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL WRITING HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA245', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL USE RIGHT HAND MOST?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA262', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RIGHT HAND SISTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA30', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL OCCUPATION OF PARENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA260', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL LEFT HAND BROTHERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA288', 68, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL CONSCIOUSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 1, 'Alert', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 2, 'Drowsy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA288', 3, 'Stupor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA287', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL TOTAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'CA285', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL WRITE SENTENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'CA254', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SCISSORS CUTTING HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA255', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SEWING HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA256', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RATER THINKS SUBJECT HAND?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA257', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL BIOLOGICAL MOM HANDEDNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA250', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL HAMMER NAIL HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA251', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL TURN SCREWDRIVER HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA252', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL TOOTHBRUSH HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA253', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL DEAL CARDS HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA283', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL 3-STAGE COMMAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA258', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL BIOLOGICAL DAD HANDEDNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL 7-DIGIT HOSP. ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA282', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL REPEAT FOLLOWING');

add_assessment_score(v_id1, owner_id, owner_id, 'CA9', 15, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL BIRTH DATE OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CA278', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL SERIAL 7');

add_assessment_score(v_id1, owner_id, owner_id, 'CA279', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL WORD BACKWARDS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA276', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL WHERE');

add_assessment_score(v_id1, owner_id, owner_id, 'CA277', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL 3 OBJECTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA274', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SUBJECT AN INFORMANT?');

add_assessment_score(v_id1, owner_id, owner_id, 'CA275', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MINI-MENTAL YEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CA272', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL OTHER BIOLOGICAL LEFT/MIX HAND');

add_assessment_score(v_id1, owner_id, owner_id, 'CA273', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL FAMILY HANDEDNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA270', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL MIXED HAND DAUGHTERS');

add_assessment_score(v_id1, owner_id, owner_id, 'CA271', 51, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL HUSBAND/WIFE HANDEDNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 0, 'No Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CA271', 3, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL FIRST ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CA265', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RIGHT HAND SONS');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL SECOND ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL INTERVIEW TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CONTROL RATER');

commit;
END;
/
