
--Add dxdsm3
create or replace procedure dxdsm3(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('dxdsm3', 'dxdsm3', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBD', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA-DISORGANIZED');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBC', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA-CATATONIC');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLA', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PERSONALITY DISORDERS-CLUSTER A');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLB', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PERSONALITY DISORDERS-CLUSTER B');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLC', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PERSONALITY DISORDERS-CLUSTER C');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CRC', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CRC INPATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'AGE', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER AGE, 0-99"');

add_assessment_score(v_id1, owner_id, owner_id, 'C_LOBOT', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'LOBOTOMY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_AFF', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SCHIZO-AFFECTIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'ENTRYDAT', 11, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ENTRY DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBU', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA-UNDIFFERENTIATED');

add_assessment_score(v_id1, owner_id, owner_id, 'C_HAL_AD', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HALLUCINOGEN ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RATER ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBP', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA-PARANOID');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1B', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1C', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ORGDIS', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ORGANIC DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'C_NO_DX', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NO KNOWN MENTAL DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 2, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SUBSOC', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF SUBJECT, 1 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'TOBACCO', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER TOBACCO USE, 0=NO 1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_NIC', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AMP_AD', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'AMPHETAMINE ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CASH', 44, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'LONG', 43, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'SEX', 7, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SEX, 1=MALE 2=FEMALE"');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 1, 'Male', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 2, 'Female', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PRIORITY', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LIL', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LILLY PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'FCONTROL', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FETAL ALCOHOL CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMTYPE', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY TYPE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OTH', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER OTHER PROT. CATEGORY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_MJ_AD', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MARIJUANA ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'LCONTROL', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'LOBOTOMY CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2C', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2B', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'WEIGHT', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER WEIGHT IN KG');

add_assessment_score(v_id1, owner_id, owner_id, 'HAND', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER HANDEDNESS, 1=RT 2=LF 3=MIX"');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_TWN', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TWIN CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'TCONTROL', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'TWIN CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_DAD', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF DAD');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ALC_AD', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ALCOHOL ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_LOB', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMNUM', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2A', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DELDIS', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'DELUSIONAL DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_EMO', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'NCONTROL', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NICOTINE CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_RIS', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RISP. VS. HAL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CON', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NORMAL CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAL', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FET. ALC. PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PARSOC', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF PARENTS, 1 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 46, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OTHAFF', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'OTHER AFFECTIVE DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OTHPSY', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'OTHER PSYCHIATRIC DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OTH_AD', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'OTHR/UNSPD/MXD SUB. ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_ANO', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ANOREXIA PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_BIPOL', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BIPOLAR AFFECTIVE DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_MOM', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF MOM');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FAL', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FEL. ALC. CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'NURSE', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NURSE ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ADJDIS', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ADJUSTMENT DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'CONTROL', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NORMAL CONTROL SUBJECTS');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1A', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LON', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LONGITUDINAL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'ECONTROL', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'EMOTION CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LOB', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY PATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CHRONIC', 5, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER CHRONICITY, 0 TO 2"');

add_assessment_score(v_id1, owner_id, owner_id, 'RACE', 13, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER RACE, 1 TO 6"');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 1, 'Caucasian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 2, 'African-American', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 3, 'Hispanic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 4, 'American Indian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 5, 'Asian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'C_MAJDEP', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MAJOR DEPRESSIVE DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BLD', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BLOOD FL0W PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CLO', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CLOZAPINE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_FRM', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SCHIZOPHRENIFORM');

add_assessment_score(v_id1, owner_id, owner_id, 'C_BAR_AD', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'BARBITURATES ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAM', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DEVDIS', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'DEVELOPMENTAL DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_NIC', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBR', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA-RESIDUAL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_TYP', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SCHIZOTYPAL');

add_assessment_score(v_id1, owner_id, owner_id, 'HEIGHT', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HEIGHT IN CM');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OTH_DX', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'OTHER DISORDERS NOS');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OPD_AD', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'OPIOID ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ANYSUB', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ANY ALCOHOL/SUBSTANCE ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ADHD', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'ATTENTIONAL DEFICIT DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CORE SCHIZOPHRENIA');

add_assessment_score(v_id1, owner_id, owner_id, 'C_COC_AD', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COCAINE ABUSE/DEPENDENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER STATUS AT INTAKE, 0 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_HAL', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HALDOL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_URO', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER URODYNAMIC PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CRITERIA', 45, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Diagnostic Method Used');
add_assessment_code(v_id1, owner_id, owner_id, 'CRITERIA', 0, 'DSM-III', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CRITERIA', 1, 'DSM-III-R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CRITERIA', 2, 'DSM-IV', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_EMO', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION PAT. PROT.');

commit;
END;
/
