
--Add dxdsm3
create or replace procedure add_dxdsm3_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
ID varchar2,
ASS float,
NURSE float,
RATER float,
CHRONIC float,
DRUGSTAT float,
SEX integer,
AGE float,
HEIGHT float,
WEIGHT float,
ENTRYDAT varchar,
HAND float,
RACE integer,
TOBACCO float,
EDUC float,
EDUC_DAD float,
EDUC_MOM float,
PARSOC float,
SUBSOC float,
PROT_CON float,
PROT_CRC float,
PROT_LON float,
PROT_LOB float,
CON_LOB float,
PROT_RIS float,
PROT_FAL float,
CON_FAL float,
PROT_NIC float,
CON_NIC float,
PROT_EMO float,
CON_EMO float,
CON_TWN float,
PROT_OTH float,
PROT_HAL float,
PROT_ANO float,
PROT_URO float,
PROT_LIL float,
PROT_CLO float,
PROT_BLD float,
PROT_FAM float,
FAMTYPE float,
FAMNUM float,
LONG varchar2,
CASH varchar2,
CRITERIA integer,
TYPE integer,
C_LOBOT float,
C_ORGDIS float,
C_SZ float,
C_SZSUBD float,
C_SZSUBC float,
C_SZSUBP float,
C_SZSUBR float,
C_SZSUBU float,
C_SZ_AFF float,
C_SZ_FRM float,
C_SZ_TYP float,
C_DELDIS float,
C_OTHPSY float,
C_PD_CLA float,
C_PD_CLB float,
C_PD_CLC float,
C_MAJDEP float,
C_BIPOL float,
C_OTHAFF float,
C_ADJDIS float,
C_ADHD float,
C_DEVDIS float,
C_ALC_AD float,
C_OPD_AD float,
C_BAR_AD float,
C_MJ_AD float,
C_AMP_AD float,
C_OTH_AD float,
C_HAL_AD float,
C_COC_AD float,
C_ANYSUB float,
C_NO_DX float,
C_OTH_DX float,
C_AXIS1A float,
C_AXIS1B float,
C_AXIS1C float,
C_AXIS2A float,
C_AXIS2B float,
C_AXIS2C float,
CONTROL float,
LCONTROL float,
FCONTROL float,
NCONTROL float,
ECONTROL float,
TCONTROL float,
PRIORITY float)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('dxdsm3');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBD', 'float', 50, c_szsubd, to_char(c_szsubd), c_szsubd, to_char(c_szsubd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBC', 'float', 51, c_szsubc, to_char(c_szsubc), c_szsubc, to_char(c_szsubc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLA', 'float', 60, c_pd_cla, to_char(c_pd_cla), c_pd_cla, to_char(c_pd_cla), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLB', 'float', 61, c_pd_clb, to_char(c_pd_clb), c_pd_clb, to_char(c_pd_clb), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLC', 'float', 62, c_pd_clc, to_char(c_pd_clc), c_pd_clc, to_char(c_pd_clc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CRC', 'float', 21, prot_crc, to_char(prot_crc), prot_crc, to_char(prot_crc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'AGE', 'float', 8, age, to_char(age), age, to_char(age), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_LOBOT', 'float', 47, c_lobot, to_char(c_lobot), c_lobot, to_char(c_lobot), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_AFF', 'float', 55, c_sz_aff, to_char(c_sz_aff), c_sz_aff, to_char(c_sz_aff), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENTRYDAT', 'timestamp', 11, NULL, entrydat, NULL, entrydat, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBU', 'float', 54, c_szsubu, to_char(c_szsubu), c_szsubu, to_char(c_szsubu), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_HAL_AD', 'float', 75, c_hal_ad, to_char(c_hal_ad), c_hal_ad, to_char(c_hal_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 4, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBP', 'float', 52, c_szsubp, to_char(c_szsubp), c_szsubp, to_char(c_szsubp), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1B', 'float', 81, c_axis1b, to_char(c_axis1b), c_axis1b, to_char(c_axis1b), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1C', 'float', 82, c_axis1c, to_char(c_axis1c), c_axis1c, to_char(c_axis1c), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC', 'float', 15, educ, to_char(educ), educ, to_char(educ), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ORGDIS', 'float', 48, c_orgdis, to_char(c_orgdis), c_orgdis, to_char(c_orgdis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_NO_DX', 'float', 78, c_no_dx, to_char(c_no_dx), c_no_dx, to_char(c_no_dx), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 2, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SUBSOC', 'float', 19, subsoc, to_char(subsoc), subsoc, to_char(subsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TOBACCO', 'float', 14, tobacco, to_char(tobacco), tobacco, to_char(tobacco), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_NIC', 'float', 28, prot_nic, to_char(prot_nic), prot_nic, to_char(prot_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AMP_AD', 'float', 73, c_amp_ad, to_char(c_amp_ad), c_amp_ad, to_char(c_amp_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CASH', 'varchar', 44, NULL, cash, NULL, cash, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'LONG', 'varchar', 43, NULL, long, NULL, long, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SEX', 'integer', 7, sex, to_char(sex), sex, to_char(sex), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PRIORITY', 'float', 92, priority, to_char(priority), priority, to_char(priority), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LIL', 'float', 37, prot_lil, to_char(prot_lil), prot_lil, to_char(prot_lil), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FCONTROL', 'float', 88, fcontrol, to_char(fcontrol), fcontrol, to_char(fcontrol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMTYPE', 'float', 41, famtype, to_char(famtype), famtype, to_char(famtype), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OTH', 'float', 33, prot_oth, to_char(prot_oth), prot_oth, to_char(prot_oth), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_MJ_AD', 'float', 72, c_mj_ad, to_char(c_mj_ad), c_mj_ad, to_char(c_mj_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'LCONTROL', 'float', 87, lcontrol, to_char(lcontrol), lcontrol, to_char(lcontrol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2C', 'float', 85, c_axis2c, to_char(c_axis2c), c_axis2c, to_char(c_axis2c), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2B', 'float', 84, c_axis2b, to_char(c_axis2b), c_axis2b, to_char(c_axis2b), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEIGHT', 'float', 10, weight, to_char(weight), weight, to_char(weight), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HAND', 'float', 12, hand, to_char(hand), hand, to_char(hand), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_TWN', 'float', 32, con_twn, to_char(con_twn), con_twn, to_char(con_twn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TCONTROL', 'float', 91, tcontrol, to_char(tcontrol), tcontrol, to_char(tcontrol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_DAD', 'float', 16, educ_dad, to_char(educ_dad), educ_dad, to_char(educ_dad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ALC_AD', 'float', 69, c_alc_ad, to_char(c_alc_ad), c_alc_ad, to_char(c_alc_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_LOB', 'float', 24, con_lob, to_char(con_lob), con_lob, to_char(con_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMNUM', 'float', 42, famnum, to_char(famnum), famnum, to_char(famnum), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2A', 'float', 83, c_axis2a, to_char(c_axis2a), c_axis2a, to_char(c_axis2a), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DELDIS', 'float', 58, c_deldis, to_char(c_deldis), c_deldis, to_char(c_deldis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_EMO', 'float', 31, con_emo, to_char(con_emo), con_emo, to_char(con_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'NCONTROL', 'float', 89, ncontrol, to_char(ncontrol), ncontrol, to_char(ncontrol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_RIS', 'float', 25, prot_ris, to_char(prot_ris), prot_ris, to_char(prot_ris), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CON', 'float', 20, prot_con, to_char(prot_con), prot_con, to_char(prot_con), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAL', 'float', 26, prot_fal, to_char(prot_fal), prot_fal, to_char(prot_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PARSOC', 'float', 18, parsoc, to_char(parsoc), parsoc, to_char(parsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TYPE', 'integer', 46, type, to_char(type), type, to_char(type), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OTHAFF', 'float', 65, c_othaff, to_char(c_othaff), c_othaff, to_char(c_othaff), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OTHPSY', 'float', 59, c_othpsy, to_char(c_othpsy), c_othpsy, to_char(c_othpsy), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OTH_AD', 'float', 74, c_oth_ad, to_char(c_oth_ad), c_oth_ad, to_char(c_oth_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_ANO', 'float', 35, prot_ano, to_char(prot_ano), prot_ano, to_char(prot_ano), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_BIPOL', 'float', 64, c_bipol, to_char(c_bipol), c_bipol, to_char(c_bipol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_MOM', 'float', 17, educ_mom, to_char(educ_mom), educ_mom, to_char(educ_mom), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FAL', 'float', 27, con_fal, to_char(con_fal), con_fal, to_char(con_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'NURSE', 'float', 3, nurse, to_char(nurse), nurse, to_char(nurse), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ADJDIS', 'float', 66, c_adjdis, to_char(c_adjdis), c_adjdis, to_char(c_adjdis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CONTROL', 'float', 86, control, to_char(control), control, to_char(control), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1A', 'float', 80, c_axis1a, to_char(c_axis1a), c_axis1a, to_char(c_axis1a), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LON', 'float', 22, prot_lon, to_char(prot_lon), prot_lon, to_char(prot_lon), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ECONTROL', 'float', 90, econtrol, to_char(econtrol), econtrol, to_char(econtrol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LOB', 'float', 23, prot_lob, to_char(prot_lob), prot_lob, to_char(prot_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CHRONIC', 'float', 5, chronic, to_char(chronic), chronic, to_char(chronic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RACE', 'integer', 13, race, to_char(race), race, to_char(race), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_MAJDEP', 'float', 63, c_majdep, to_char(c_majdep), c_majdep, to_char(c_majdep), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BLD', 'float', 39, prot_bld, to_char(prot_bld), prot_bld, to_char(prot_bld), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CLO', 'float', 38, prot_clo, to_char(prot_clo), prot_clo, to_char(prot_clo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_FRM', 'float', 56, c_sz_frm, to_char(c_sz_frm), c_sz_frm, to_char(c_sz_frm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_BAR_AD', 'float', 71, c_bar_ad, to_char(c_bar_ad), c_bar_ad, to_char(c_bar_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAM', 'float', 40, prot_fam, to_char(prot_fam), prot_fam, to_char(prot_fam), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DEVDIS', 'float', 68, c_devdis, to_char(c_devdis), c_devdis, to_char(c_devdis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_NIC', 'float', 29, con_nic, to_char(con_nic), con_nic, to_char(con_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBR', 'float', 53, c_szsubr, to_char(c_szsubr), c_szsubr, to_char(c_szsubr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_TYP', 'float', 57, c_sz_typ, to_char(c_sz_typ), c_sz_typ, to_char(c_sz_typ), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HEIGHT', 'float', 9, height, to_char(height), height, to_char(height), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OTH_DX', 'float', 79, c_oth_dx, to_char(c_oth_dx), c_oth_dx, to_char(c_oth_dx), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OPD_AD', 'float', 70, c_opd_ad, to_char(c_opd_ad), c_opd_ad, to_char(c_opd_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ANYSUB', 'float', 77, c_anysub, to_char(c_anysub), c_anysub, to_char(c_anysub), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ADHD', 'float', 67, c_adhd, to_char(c_adhd), c_adhd, to_char(c_adhd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 1, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ', 'float', 49, c_sz, to_char(c_sz), c_sz, to_char(c_sz), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_COC_AD', 'float', 76, c_coc_ad, to_char(c_coc_ad), c_coc_ad, to_char(c_coc_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'float', 6, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_HAL', 'float', 34, prot_hal, to_char(prot_hal), prot_hal, to_char(prot_hal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_URO', 'float', 36, prot_uro, to_char(prot_uro), prot_uro, to_char(prot_uro), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CRITERIA', 'integer', 45, criteria, to_char(criteria), criteria, to_char(criteria), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_EMO', 'float', 30, prot_emo, to_char(prot_emo), prot_emo, to_char(prot_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_dxdsm3_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
