
--Add dxdsm4
create or replace procedure dxdsm4(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('dxdsm4', 'dxdsm4', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBD', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia-Disorganized');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 5, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLA', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Personality Disorders-Cluster A');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLB', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Personality Disorders-Cluster B');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PD_CLC', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Personality Disorders-Cluster C');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CRC', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CRC INPATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'AGE', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER AGE, 0-99"');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_AUT', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER AUTISM CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FMR', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FUNCTIONAL MRI PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'ENTRYDAT', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ENTRY DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBU', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia-Undifferentiated');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OTH_AD', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Othr/Unspd/Mxd Sub. Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RATER ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBP', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia-Paranoid');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1B', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_MFE', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL CONTROL, FIRST EPISODE"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_TMS', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TRANSCRAN STIMUL PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ANYSUB', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Any Alcohol/Substance Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1C', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SUBHAL', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Sub Induced Psychotic w/ Hallucinations');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 2, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SUBSOC', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF SUBJECT, 1 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_HYD', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HYDRATIONAL PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_NIC', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ALCDEL', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Alc Induced Psychotic w/ Delusions');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_GEN', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GENE ASSOCIATION CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CASH', 81, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'LONG', 79, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'SEX', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SEX, 1=MALE 2=FEMALE"');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 1, 'Male', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 2, 'Female', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FBN', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'fBIRN PROTOCOL PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LIL', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LILLY PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'criteria', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Diagnostic Method Used');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_PET', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER PET PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMTYPE', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY TYPE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OTH', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER OTHER PROT. CATEGORY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_MJ_AD', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Marijuana Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ALCHAL', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Alc Induced Psychotic w/ Hallucinations');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2A', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2B', 129, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'WEIGHT', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER WEIGHT IN KG');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PICKS', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Dementia due to Pick''s disease');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MAR', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MARIJUANA STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DEMDEL', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Dementia with Delusions');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_AUT', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER AUTISM PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_THM', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMIC CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_TWN', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TWIN CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CON', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NORMAL CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AMP_AD', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Amphetamine Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_DAD', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF DAD');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ALC_AD', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Alcohol Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_LOB', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CHS', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MAX''S CHILDHOOD STROKE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMNUM', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OUT', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CRC OUTPATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_PHA', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER PHANTOM');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_EMO', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OLN', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER OLANZAPINE STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_RIS', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RISP. VS. HAL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAM', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAL', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FET. ALC. PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PARSOC', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF PARENTS, 1 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'HAND', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER HANDEDNESS, 1=RT 2=LF 3=MIX"');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 80, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'CASH TYPE OF SUBJECT');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AMNES', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Amnestic Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBR', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia-Residual');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DEMVAS', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Uncomplicated Vascular Dementia');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZSUBC', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia-Catatonic');

add_assessment_score(v_id1, owner_id, owner_id, 'C_HAL_AD', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Hallucinogen Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_GEN', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GENE ASSOCIATION');

add_assessment_score(v_id1, owner_id, owner_id, 'TOBACCO', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER TOBACCO USE, 0=NO 1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_DTI', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER DIFFUSION TENSOR IMAGING PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PSYNOS', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Psychotic Disorder NOS');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PERSON', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Personality Change due to ...');

add_assessment_score(v_id1, owner_id, owner_id, 'C_BAR_AD', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Barbiturates Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PSYHAL', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Psychotic Disorder with Hallucinations');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_MOM', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF MOM');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FAL', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FET. ALC. CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_GER', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GERIATRIC PATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS2C', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'NURSE', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NURSE ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ADJDIS', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Adjustment Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BTM', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN TRAUMA');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SHARED', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Shared Psychotic Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BPL', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BIPOLAR PROTOCOL PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CLP', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CLEFT LIP/PALATE');

add_assessment_score(v_id1, owner_id, owner_id, 'C_AXIS1A', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_TDK', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TARDIVE DYS. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_COC_AD', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Cocaine Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MFE', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL PATIENT, FIRST EPISODE"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LOB', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY PATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CHRONIC', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER CHRONICITY, 0 TO 2"');

add_assessment_score(v_id1, owner_id, owner_id, 'RACE', 14, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER RACE, 1 TO 6"');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 1, 'Caucasian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 2, 'African-American', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 3, 'Hispanic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 4, 'American Indian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 5, 'Asian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'C_MAJDEP', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Major Depressive Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'PILOT_CB', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CEREBELLUM PILOT STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DELDIS', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Delusional Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BLD', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BLOOD FL0W PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FMR', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FUNCTIONAL MRI CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CLO', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CLOZAPINE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DEMHIV', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HIV Dementia');

add_assessment_score(v_id1, owner_id, owner_id, 'C_BIPOL', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Bipolar Affective Disorder Type I');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_JAT', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER JAPANESE TWIN');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BFC', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN FUNCT. &''||'' COGNITION PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'C_PSYDEL', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Psychotic Disorder with Delusions');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_NIC', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_BFC', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN FUNCT. &''||'' COGNITION CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_TYP', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Schizotypal');

add_assessment_score(v_id1, owner_id, owner_id, 'C_DEM', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Dementia');

add_assessment_score(v_id1, owner_id, owner_id, 'HEIGHT', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HEIGHT IN CM');

add_assessment_score(v_id1, owner_id, owner_id, 'PILOT_TM', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMUS PILOT STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'C_ADHD', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Attentional Deficit Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'C_OPD_AD', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Opioid Abuse/Dependence');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MCH', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL PATIENT, CHRONIC"');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_MCH', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL CONTROL, CHRONIC"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_THM', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMIC PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LON', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LONGITUDINAL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MRI', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MRI COMPONENT PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FBN', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'fBIRN PROTOCOL CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Core Schizophrenia');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SUBDEL', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Sub Induced Psychotic w/ Delusions');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_ANO', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ANOREXIA PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER STATUS AT INTAKE, 0 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_HAL', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HALDOL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_URO', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER URODYNAMIC PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'C_BRIEF', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Brief Psychotic Disorder');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_FRM', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Schizophreniform');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LI2', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER DEL''S OLANZAPINE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_EMO', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'C_SZ_AFF', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'Schizo-Affective');

commit;
END;
/
