
--Add dxdsm4
create or replace procedure add_dxdsm4_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
ID varchar2,
ASS float,
NURSE float,
RATER float,
RATER2 float,
CHRONIC float,
DRUGSTAT float,
SEX integer,
AGE float,
HEIGHT float,
WEIGHT float,
ENTRYDAT varchar,
HAND float,
RACE integer,
TOBACCO float,
EDUC float,
EDUC_DAD float,
EDUC_MOM float,
PARSOC float,
SUBSOC float,
PROT_BPL float,
CON_GEN float,
PROT_GEN float,
PROT_CRC float,
PROT_OUT float,
PROT_GER float,
PROT_LI2 float,
PROT_LON float,
PROT_OLN float,
PROT_PET float,
CON_FBN float,
PROT_FBN float,
CON_FMR float,
PROT_FMR float,
PROT_MAR float,
CON_MCH float,
PROT_MCH float,
CON_MFE float,
PROT_MFE float,
PROT_CON float,
PROT_OTH float,
PROT_DTI float,
PROT_MRI float,
PROT_PHA float,
PROT_TMS float,
PROT_ANO float,
PROT_BLD float,
PROT_CLO float,
PROT_FAM float,
FAMTYPE float,
FAMNUM float,
PROT_HAL float,
PROT_LIL float,
PROT_URO float,
PROT_HYD float,
PROT_RIS float,
PROT_TDK float,
PROT_CLP float,
CON_NIC float,
PROT_NIC float,
CON_THM float,
PROT_THM float,
CON_TWN float,
CON_AUT float,
PROT_AUT float,
CON_BFC float,
PROT_BFC float,
PROT_BTM float,
PROT_CHS float,
CON_EMO float,
PROT_EMO float,
CON_FAL float,
PROT_FAL float,
PROT_JAT float,
CON_LOB float,
PROT_LOB float,
PILOT_CB float,
PILOT_TM float,
LONG varchar2,
TYPE integer,
CASH varchar2,
criteria float,
C_ADHD float,
C_ADJDIS float,
C_ALC_AD float,
C_AMP_AD float,
C_ANYSUB float,
C_BAR_AD float,
C_BIPOL float,
C_COC_AD float,
C_DELDIS float,
C_HAL_AD float,
C_MAJDEP float,
C_MJ_AD float,
C_OPD_AD float,
C_OTH_AD float,
C_PD_CLA float,
C_PD_CLB float,
C_PD_CLC float,
C_SZ float,
C_SZSUBC float,
C_SZSUBD float,
C_SZSUBP float,
C_SZSUBR float,
C_SZSUBU float,
C_SZ_AFF float,
C_SZ_FRM float,
C_SZ_TYP float,
C_DEM float,
C_PICKS float,
C_DEMDEL float,
C_DEMHIV float,
C_DEMVAS float,
C_AMNES float,
C_PERSON float,
C_SHARED float,
C_BRIEF float,
C_PSYNOS float,
C_PSYDEL float,
C_PSYHAL float,
C_ALCDEL float,
C_ALCHAL float,
C_SUBDEL float,
C_SUBHAL float,
C_AXIS1A float,
C_AXIS1B float,
C_AXIS1C float,
C_AXIS2A float,
C_AXIS2B float,
C_AXIS2C float)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('dxdsm4');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBD', 'float', 102, c_szsubd, to_char(c_szsubd), c_szsubd, to_char(c_szsubd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 5, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLA', 'float', 97, c_pd_cla, to_char(c_pd_cla), c_pd_cla, to_char(c_pd_cla), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLB', 'float', 98, c_pd_clb, to_char(c_pd_clb), c_pd_clb, to_char(c_pd_clb), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PD_CLC', 'float', 99, c_pd_clc, to_char(c_pd_clc), c_pd_clc, to_char(c_pd_clc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CRC', 'float', 24, prot_crc, to_char(prot_crc), prot_crc, to_char(prot_crc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'AGE', 'float', 9, age, to_char(age), age, to_char(age), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_AUT', 'float', 64, con_aut, to_char(con_aut), con_aut, to_char(con_aut), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FMR', 'float', 34, prot_fmr, to_char(prot_fmr), prot_fmr, to_char(prot_fmr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENTRYDAT', 'timestamp', 12, NULL, entrydat, NULL, entrydat, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBU', 'float', 105, c_szsubu, to_char(c_szsubu), c_szsubu, to_char(c_szsubu), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OTH_AD', 'float', 96, c_oth_ad, to_char(c_oth_ad), c_oth_ad, to_char(c_oth_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 4, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBP', 'float', 103, c_szsubp, to_char(c_szsubp), c_szsubp, to_char(c_szsubp), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1B', 'float', 126, c_axis1b, to_char(c_axis1b), c_axis1b, to_char(c_axis1b), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_MFE', 'float', 38, con_mfe, to_char(con_mfe), con_mfe, to_char(con_mfe), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_TMS', 'float', 45, prot_tms, to_char(prot_tms), prot_tms, to_char(prot_tms), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC', 'float', 16, educ, to_char(educ), educ, to_char(educ), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ANYSUB', 'float', 87, c_anysub, to_char(c_anysub), c_anysub, to_char(c_anysub), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1C', 'float', 127, c_axis1c, to_char(c_axis1c), c_axis1c, to_char(c_axis1c), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SUBHAL', 'float', 124, c_subhal, to_char(c_subhal), c_subhal, to_char(c_subhal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 2, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SUBSOC', 'float', 20, subsoc, to_char(subsoc), subsoc, to_char(subsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_HYD', 'float', 55, prot_hyd, to_char(prot_hyd), prot_hyd, to_char(prot_hyd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_NIC', 'float', 60, prot_nic, to_char(prot_nic), prot_nic, to_char(prot_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ALCDEL', 'float', 121, c_alcdel, to_char(c_alcdel), c_alcdel, to_char(c_alcdel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_GEN', 'float', 22, con_gen, to_char(con_gen), con_gen, to_char(con_gen), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CASH', 'varchar', 81, NULL, cash, NULL, cash, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'LONG', 'varchar', 79, NULL, long, NULL, long, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SEX', 'integer', 8, sex, to_char(sex), sex, to_char(sex), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FBN', 'float', 32, prot_fbn, to_char(prot_fbn), prot_fbn, to_char(prot_fbn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LIL', 'float', 53, prot_lil, to_char(prot_lil), prot_lil, to_char(prot_lil), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'criteria', 'float', 82, criteria, to_char(criteria), criteria, to_char(criteria), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_PET', 'float', 30, prot_pet, to_char(prot_pet), prot_pet, to_char(prot_pet), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMTYPE', 'float', 50, famtype, to_char(famtype), famtype, to_char(famtype), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OTH', 'float', 41, prot_oth, to_char(prot_oth), prot_oth, to_char(prot_oth), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_MJ_AD', 'float', 94, c_mj_ad, to_char(c_mj_ad), c_mj_ad, to_char(c_mj_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ALCHAL', 'float', 122, c_alchal, to_char(c_alchal), c_alchal, to_char(c_alchal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2A', 'float', 128, c_axis2a, to_char(c_axis2a), c_axis2a, to_char(c_axis2a), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2B', 'float', 129, c_axis2b, to_char(c_axis2b), c_axis2b, to_char(c_axis2b), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEIGHT', 'float', 11, weight, to_char(weight), weight, to_char(weight), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PICKS', 'float', 110, c_picks, to_char(c_picks), c_picks, to_char(c_picks), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MAR', 'float', 35, prot_mar, to_char(prot_mar), prot_mar, to_char(prot_mar), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DEMDEL', 'float', 111, c_demdel, to_char(c_demdel), c_demdel, to_char(c_demdel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_AUT', 'float', 65, prot_aut, to_char(prot_aut), prot_aut, to_char(prot_aut), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_THM', 'float', 61, con_thm, to_char(con_thm), con_thm, to_char(con_thm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_TWN', 'float', 63, con_twn, to_char(con_twn), con_twn, to_char(con_twn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CON', 'float', 40, prot_con, to_char(prot_con), prot_con, to_char(prot_con), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AMP_AD', 'float', 86, c_amp_ad, to_char(c_amp_ad), c_amp_ad, to_char(c_amp_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_DAD', 'float', 17, educ_dad, to_char(educ_dad), educ_dad, to_char(educ_dad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ALC_AD', 'float', 85, c_alc_ad, to_char(c_alc_ad), c_alc_ad, to_char(c_alc_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_LOB', 'float', 75, con_lob, to_char(con_lob), con_lob, to_char(con_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CHS', 'float', 69, prot_chs, to_char(prot_chs), prot_chs, to_char(prot_chs), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMNUM', 'float', 51, famnum, to_char(famnum), famnum, to_char(famnum), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OUT', 'float', 25, prot_out, to_char(prot_out), prot_out, to_char(prot_out), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_PHA', 'float', 44, prot_pha, to_char(prot_pha), prot_pha, to_char(prot_pha), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_EMO', 'float', 70, con_emo, to_char(con_emo), con_emo, to_char(con_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OLN', 'float', 29, prot_oln, to_char(prot_oln), prot_oln, to_char(prot_oln), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_RIS', 'float', 56, prot_ris, to_char(prot_ris), prot_ris, to_char(prot_ris), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAM', 'float', 49, prot_fam, to_char(prot_fam), prot_fam, to_char(prot_fam), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAL', 'float', 73, prot_fal, to_char(prot_fal), prot_fal, to_char(prot_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PARSOC', 'float', 19, parsoc, to_char(parsoc), parsoc, to_char(parsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HAND', 'float', 13, hand, to_char(hand), hand, to_char(hand), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TYPE', 'integer', 80, type, to_char(type), type, to_char(type), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AMNES', 'float', 114, c_amnes, to_char(c_amnes), c_amnes, to_char(c_amnes), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBR', 'float', 104, c_szsubr, to_char(c_szsubr), c_szsubr, to_char(c_szsubr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DEMVAS', 'float', 113, c_demvas, to_char(c_demvas), c_demvas, to_char(c_demvas), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZSUBC', 'float', 101, c_szsubc, to_char(c_szsubc), c_szsubc, to_char(c_szsubc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_HAL_AD', 'float', 92, c_hal_ad, to_char(c_hal_ad), c_hal_ad, to_char(c_hal_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_GEN', 'float', 23, prot_gen, to_char(prot_gen), prot_gen, to_char(prot_gen), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TOBACCO', 'float', 15, tobacco, to_char(tobacco), tobacco, to_char(tobacco), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_DTI', 'float', 42, prot_dti, to_char(prot_dti), prot_dti, to_char(prot_dti), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PSYNOS', 'float', 118, c_psynos, to_char(c_psynos), c_psynos, to_char(c_psynos), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PERSON', 'float', 115, c_person, to_char(c_person), c_person, to_char(c_person), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_BAR_AD', 'float', 88, c_bar_ad, to_char(c_bar_ad), c_bar_ad, to_char(c_bar_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PSYHAL', 'float', 120, c_psyhal, to_char(c_psyhal), c_psyhal, to_char(c_psyhal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_MOM', 'float', 18, educ_mom, to_char(educ_mom), educ_mom, to_char(educ_mom), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FAL', 'float', 72, con_fal, to_char(con_fal), con_fal, to_char(con_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_GER', 'float', 26, prot_ger, to_char(prot_ger), prot_ger, to_char(prot_ger), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS2C', 'float', 130, c_axis2c, to_char(c_axis2c), c_axis2c, to_char(c_axis2c), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'NURSE', 'float', 3, nurse, to_char(nurse), nurse, to_char(nurse), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ADJDIS', 'float', 84, c_adjdis, to_char(c_adjdis), c_adjdis, to_char(c_adjdis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BTM', 'float', 68, prot_btm, to_char(prot_btm), prot_btm, to_char(prot_btm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SHARED', 'float', 116, c_shared, to_char(c_shared), c_shared, to_char(c_shared), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BPL', 'float', 21, prot_bpl, to_char(prot_bpl), prot_bpl, to_char(prot_bpl), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CLP', 'float', 58, prot_clp, to_char(prot_clp), prot_clp, to_char(prot_clp), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_AXIS1A', 'float', 125, c_axis1a, to_char(c_axis1a), c_axis1a, to_char(c_axis1a), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_TDK', 'float', 57, prot_tdk, to_char(prot_tdk), prot_tdk, to_char(prot_tdk), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_COC_AD', 'float', 90, c_coc_ad, to_char(c_coc_ad), c_coc_ad, to_char(c_coc_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MFE', 'float', 39, prot_mfe, to_char(prot_mfe), prot_mfe, to_char(prot_mfe), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LOB', 'float', 76, prot_lob, to_char(prot_lob), prot_lob, to_char(prot_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CHRONIC', 'float', 6, chronic, to_char(chronic), chronic, to_char(chronic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RACE', 'integer', 14, race, to_char(race), race, to_char(race), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_MAJDEP', 'float', 93, c_majdep, to_char(c_majdep), c_majdep, to_char(c_majdep), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PILOT_CB', 'float', 77, pilot_cb, to_char(pilot_cb), pilot_cb, to_char(pilot_cb), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DELDIS', 'float', 91, c_deldis, to_char(c_deldis), c_deldis, to_char(c_deldis), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BLD', 'float', 47, prot_bld, to_char(prot_bld), prot_bld, to_char(prot_bld), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FMR', 'float', 33, con_fmr, to_char(con_fmr), con_fmr, to_char(con_fmr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CLO', 'float', 48, prot_clo, to_char(prot_clo), prot_clo, to_char(prot_clo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DEMHIV', 'float', 112, c_demhiv, to_char(c_demhiv), c_demhiv, to_char(c_demhiv), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_BIPOL', 'float', 89, c_bipol, to_char(c_bipol), c_bipol, to_char(c_bipol), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_JAT', 'float', 74, prot_jat, to_char(prot_jat), prot_jat, to_char(prot_jat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BFC', 'float', 67, prot_bfc, to_char(prot_bfc), prot_bfc, to_char(prot_bfc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_PSYDEL', 'float', 119, c_psydel, to_char(c_psydel), c_psydel, to_char(c_psydel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_NIC', 'float', 59, con_nic, to_char(con_nic), con_nic, to_char(con_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_BFC', 'float', 66, con_bfc, to_char(con_bfc), con_bfc, to_char(con_bfc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_TYP', 'float', 108, c_sz_typ, to_char(c_sz_typ), c_sz_typ, to_char(c_sz_typ), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_DEM', 'float', 109, c_dem, to_char(c_dem), c_dem, to_char(c_dem), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HEIGHT', 'float', 10, height, to_char(height), height, to_char(height), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PILOT_TM', 'float', 78, pilot_tm, to_char(pilot_tm), pilot_tm, to_char(pilot_tm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_ADHD', 'float', 83, c_adhd, to_char(c_adhd), c_adhd, to_char(c_adhd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_OPD_AD', 'float', 95, c_opd_ad, to_char(c_opd_ad), c_opd_ad, to_char(c_opd_ad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MCH', 'float', 37, prot_mch, to_char(prot_mch), prot_mch, to_char(prot_mch), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_MCH', 'float', 36, con_mch, to_char(con_mch), con_mch, to_char(con_mch), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_THM', 'float', 62, prot_thm, to_char(prot_thm), prot_thm, to_char(prot_thm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 1, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LON', 'float', 28, prot_lon, to_char(prot_lon), prot_lon, to_char(prot_lon), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MRI', 'float', 43, prot_mri, to_char(prot_mri), prot_mri, to_char(prot_mri), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FBN', 'float', 31, con_fbn, to_char(con_fbn), con_fbn, to_char(con_fbn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ', 'float', 100, c_sz, to_char(c_sz), c_sz, to_char(c_sz), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SUBDEL', 'float', 123, c_subdel, to_char(c_subdel), c_subdel, to_char(c_subdel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_ANO', 'float', 46, prot_ano, to_char(prot_ano), prot_ano, to_char(prot_ano), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'float', 7, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_HAL', 'float', 52, prot_hal, to_char(prot_hal), prot_hal, to_char(prot_hal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_URO', 'float', 54, prot_uro, to_char(prot_uro), prot_uro, to_char(prot_uro), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_BRIEF', 'float', 117, c_brief, to_char(c_brief), c_brief, to_char(c_brief), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_FRM', 'float', 107, c_sz_frm, to_char(c_sz_frm), c_sz_frm, to_char(c_sz_frm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LI2', 'float', 27, prot_li2, to_char(prot_li2), prot_li2, to_char(prot_li2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_EMO', 'float', 71, prot_emo, to_char(prot_emo), prot_emo, to_char(prot_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'C_SZ_AFF', 'float', 106, c_sz_aff, to_char(c_sz_aff), c_sz_aff, to_char(c_sz_aff), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_dxdsm4_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
