
--Add fhrdc
create or replace procedure fhrdc(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('fhrdc', 'fhrdc', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'FH33', 46, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH33', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH32', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NIECE/NEPHEW: SIBLING''S SPOUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH31', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NIECE/NEPHEW: LINKING SIBLING');

add_assessment_score(v_id1, owner_id, owner_id, 'FH30', 43, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NIECE/NEPHEW');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH30', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH36', 49, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD''S SPOUSE');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH36', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH35', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD: COPARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH34', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD: INDEX SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH39', 52, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC GRANDCHILD');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH39', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH38', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD''S SPOUSE: CHILD');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH78', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC ALCOHOLISM: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH77', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC ALCOHOLISM');

add_assessment_score(v_id1, owner_id, owner_id, 'FH37', 50, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHILD''S SPOUSE: GRANDCHILD');
add_assessment_code(v_id1, owner_id, owner_id, 'FH37', 0, 'Produced grandchild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH37', 1, 'Did not produce grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH75', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC UFP: COURSE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH74', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC UFP: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH73', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC UFP');

add_assessment_score(v_id1, owner_id, owner_id, 'FH72', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SENILE OBS: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH71', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SENILE OBS');

add_assessment_score(v_id1, owner_id, owner_id, 'FH70', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RECURRENT UNIPOLAR: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH109', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH61', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. DEP: COURSE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH88', 101, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC COMPLETENESS OF INFO');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 1, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH88', 5, 'Essentially no information', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH55', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHRONIC SCHIZ: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH89', 102, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC COLOR BLIND');
add_assessment_code(v_id1, owner_id, owner_id, 'FH89', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH89', 1, 'Likely', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH89', 2, 'Yes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH106', 119, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIRST AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH59', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. DEP');

add_assessment_score(v_id1, owner_id, owner_id, 'FH116', 129, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIXTH AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 11, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'FH58', 71, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. MANIC: COURSE');
add_assessment_code(v_id1, owner_id, owner_id, 'FH58', 0, 'Remitting', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH58', 1, 'Chronic', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH86', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC OPD: DYSPHORIC MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'FH87', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NO KNOWN MENTAL DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH48', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SUICIDE ATTEMPTS OR GESTURES');

add_assessment_score(v_id1, owner_id, owner_id, 'FH49', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SOCIAL INCAPACITATION');

add_assessment_score(v_id1, owner_id, owner_id, 'FH82', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC ANTISOC PERSONALITY: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH83', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC OPD');

add_assessment_score(v_id1, owner_id, owner_id, 'FH80', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DRUG USE DISORDER: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH81', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC ANTISOC PERSONALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'FH42', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC OTHER RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH43', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC INFO AVAILABLE TO COMPLETE FORM?');

add_assessment_score(v_id1, owner_id, owner_id, 'FH40', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC GRANDCHILD: LINKING CHILD');

add_assessment_score(v_id1, owner_id, owner_id, 'FH41', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC GRANDCHILD: CHILD''S COPARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH46', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AGE AT DEATH');

add_assessment_score(v_id1, owner_id, owner_id, 'FH47', 60, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CAUSE OF DEATH');
add_assessment_code(v_id1, owner_id, owner_id, 'FH47', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH47', 1, 'Natural Death', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH47', 2, 'Accidental Death', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH47', 3, 'Suicide', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH47', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH44', 57, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SUBJECT ALIVE OR DEAD');
add_assessment_code(v_id1, owner_id, owner_id, 'FH44', 0, 'Living', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH44', 1, 'Deceased', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH45', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AGE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH111', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC THIRD AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH110', 123, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC THIRD AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH107', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIRST AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH113', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FOURTH AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH115', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIFTH AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC TYPE OF INTERVIEW');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'CRC Inpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 7, 'Family Study', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 8, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 9, 'Lobotomy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 10, 'CRC Outpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH114', 127, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIFTH AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH19', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AUNT/UNCLE: LINKING GRANDPARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH18', 31, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AUNT/UNCLE: FULL/STEP/HALF');
add_assessment_code(v_id1, owner_id, owner_id, 'FH18', 0, 'Full Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH18', 1, 'Aunt/Uncle of Stepparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH18', 2, 'Half Aunt/Uncle', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH57', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. MANIC: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH56', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. MANIC');

add_assessment_score(v_id1, owner_id, owner_id, 'FH51', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NUMBER OF HOSPITALIZATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'FH50', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC HOSPITALIZED');

add_assessment_score(v_id1, owner_id, owner_id, 'FH53', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC PSYCHOTHERAPEUTIC TREATMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH52', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SOMATIC TREATMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH11', 24, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC BIRTHDATE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH10', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC BIRTH ORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH13', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC GRANDPARENT');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH13', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC MEMBER OF MULTIPLE BIRTH');
add_assessment_code(v_id1, owner_id, owner_id, 'FH12', 0, 'No', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH12', 1, 'Yes/Zygosity uknown', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH12', 2, 'Yes, Dizygotic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH12', 3, 'Yes, Monozygotic', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH15', 28, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC PARENT');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH15', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH14', 27, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC GRANDPARENT: FULL/STEP');
add_assessment_code(v_id1, owner_id, owner_id, 'FH14', 0, 'Full Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH14', 1, 'Grandparent of Stepparent', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH17', 30, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AUNT/UNCLE');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH17', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH16', 29, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC PARENT: FULL/STEP');
add_assessment_code(v_id1, owner_id, owner_id, 'FH16', 0, 'Full Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH16', 1, 'Stepparent', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH91', 104, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DIAGNOSTIC CRITERIA USED');
add_assessment_code(v_id1, owner_id, owner_id, 'FH91', 0, 'DSM-III', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH91', 1, 'DSM-III-R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH91', 2, 'Insufficient Info', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH91', 3, 'DSM-IV', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH90', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC INHERITED NON-MENTAL ILLNESS');

add_assessment_score(v_id1, owner_id, owner_id, 'FH93', 106, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIRST AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH92', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NUMBER OF AXIS I DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'FH95', 108, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH94', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIRST AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH97', 110, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC THIRD AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH76', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC UFP: DYSPHORIC MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 18, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DATE OF INTERVIEW');

add_assessment_score(v_id1, owner_id, owner_id, 'RELNO', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RELATIVE NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH96', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH79', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DRUG USE DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FOLLOW-UP PERIOD (months)');

add_assessment_score(v_id1, owner_id, owner_id, 'FH99', 112, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FOURTH AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH21', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIBLING');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH21', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH22', 35, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIBLING: FULL/HALF');
add_assessment_code(v_id1, owner_id, owner_id, 'FH22', 0, 'Full Sister/Brother', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH22', 1, 'Half Sister/Brother', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH23', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIBLING: LINKING PARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH24', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIBLING: NONLINKING PARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH25', 38, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SPOUSE');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH25', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH26', 39, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SPOUSE: COPARENT STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'FH26', 0, 'Co-parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH26', 1, 'Not co-parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH26', 2, 'Co-parent unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH27', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC COUSIN');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 0, 'Grandparent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 1, 'Parent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 2, 'Aunt/Uncle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 3, 'Sibling', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 4, 'Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 5, 'Cousin', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 6, 'Niece/Nephew', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 7, 'Child', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 8, 'Child''''s Spouse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH27', 9, 'Grandchild', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH28', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC COUSIN: LINKING AUNT/UNCLE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH29', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC COUSIN: NONLINKING AUNT/UNCLE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH20', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC AUNT/UNCLE: NONLINKING GRANDPARENT');

add_assessment_score(v_id1, owner_id, owner_id, 'FH102', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIFTH AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH103', 116, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIXTH AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH100', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FOURTH AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH101', 114, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FIFTH AXIS I DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH68', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC BIPOLAR: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH69', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RECURRENT UNIPOLAR');

add_assessment_score(v_id1, owner_id, owner_id, 'FH104', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIXTH AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH105', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC NUMBER OF AXIS II DIAGNOSES');

add_assessment_score(v_id1, owner_id, owner_id, 'FH64', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DEPRESSION: COURSE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH65', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC MANIA');

add_assessment_score(v_id1, owner_id, owner_id, 'FH66', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC MANIA: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH67', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC BIPOLAR');

add_assessment_score(v_id1, owner_id, owner_id, 'FH60', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SCHIZ-AFF. DEP: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH62', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DEPRESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'FH63', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DEPRESSION: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH98', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC THIRD AXIS I DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH117', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SIXTH AXIS II DX: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH54', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC CHRONIC SCHIZOPHRENIA');

add_assessment_score(v_id1, owner_id, owner_id, 'FH84', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC OPD: AGE OF ONSET');

add_assessment_score(v_id1, owner_id, owner_id, 'FH112', 125, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FOURTH AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH108', 121, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SECOND AXIS II DX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH85', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC OPD: COURSE');

add_assessment_score(v_id1, owner_id, owner_id, 'FH9', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC SEX');

add_assessment_score(v_id1, owner_id, owner_id, 'FH8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC WHICH SIDE OF THE FAMILY?');
add_assessment_code(v_id1, owner_id, owner_id, 'FH8', 0, 'Paternal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH8', 1, 'Maternal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH8', 2, 'Nuclear', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'FH8', 3, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FH5', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC PEDIGREE NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH4', 16, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC RELATIVE ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH1', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FAMILY STUDY PARTICIPANT?');

add_assessment_score(v_id1, owner_id, owner_id, 'FH3', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FH2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FHRDC FAMILY STUDY: TYPE OF SUBJECT');

commit;
END;
/
