
--Add fmri
create or replace procedure fmri(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('fmri', 'fmri', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'DATE14', 117, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'CIGMIN', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI MINUTES SINCE LAST CIG SMOKED');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE11', 99, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI RATER WHO FILLED OUT THE FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE10', 93, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE12', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE13', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE10', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME3', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE13', 111, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE14', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE15', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE11', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE15', 123, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT9', 85, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 9');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT8', 79, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 8');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FMRQID', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI 10-DIGIT UNIQUE FMRI NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT3', 49, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 3');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT2', 43, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 2');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT1', 37, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 1');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'TOTAL', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TOTAL NUMBER SERIES IN SESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT7', 73, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 7');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT6', 67, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 6');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT5', 61, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 5');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT4', 55, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 4');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE11', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 14, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI MEDICATION STATUS AT TIME OF SCAN');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT13', 109, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 13');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CIGDAY', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI AVE.# CIGS SMOKE/DAY FOR PAST WEEK');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT11', 97, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 11');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT10', 91, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 10');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT14', 115, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 14');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE4', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE5', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE6', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE7', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'END_TIME', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME SESSION ENDED (24 HOUR CLOCK)');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE2', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE3', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE5', 63, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE8', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE9', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'CAFF1', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI LAST 3.5 HOURS CAFFEINE TOTAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE1', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE2', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CAFF2', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DAILY AVE. FOR PAST WEEK');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE4', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE5', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE6', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE7', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'CIGCONT', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI CIG NICOTINE CONTENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE9', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE3', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE8', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG CODE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CIGBRAND', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI CIG BRAND CODE NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'LINES', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI # OF CURRENT MED LINES ANSWERED');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE14', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE15', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 11, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF SCAN');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE12', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE13', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE13', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE12', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE11', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE10', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME8', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME9', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE15', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE14', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME4', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME5', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME6', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME7', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME1', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME2', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CIGS8', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI CIGS SMOKED IN LAST 8 HOURS');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE10', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT12', 103, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 12');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_1', 18, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #1');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_2', 19, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #2');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_3', 20, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #3');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_4', 21, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #4');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_5', 22, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #5');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_6', 23, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #6');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_7', 24, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #7');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_8', 25, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #8');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_9', 26, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI PROTOCOL NUMBER AND VERSION #9');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME14', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME15', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME12', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME13', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME10', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'TIME11', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME OF MOST RECENT DOSE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'BEG_TIME', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI TIME SESSION BEGAN (24 HOUR CLOCK)');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE8', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT15', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG UNIT 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE3', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE2', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE1', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE12', 105, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE7', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE6', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE5', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE4', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE1', 39, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE3', 51, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE2', 45, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE4', 57, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE7', 75, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE6', 69, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE9', 87, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE8', 81, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DATE OF MOST RECENT DOSE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUTE9', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI ROUTE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE1', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'FMRI DRUG DOSE 1');

commit;
END;
/
