
--Add hamilton
create or replace procedure hamilton(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('hamilton', 'hamilton', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'HA29', 42, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON WORTHLESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA29', 0, 'Not present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA29', 1, 'Indicates feelings of worthlessness only on questioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA29', 2, 'Spontaniously indicates feelings of worthlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA29', 3, 'Different from 2 by degree.', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA29', 4, 'Delusional notions of worthlessness', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON INSOMNIA EARLY');
add_assessment_code(v_id1, owner_id, owner_id, 'HA8', 0, 'No difficulty falling asleep', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA8', 1, 'Complaints of occasional difficulty falling asleep', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA8', 2, 'Complaints of nightly difficulty falling asleep', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA28', 41, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON HOPELESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA28', 0, 'Not present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA28', 1, 'Intermittnetly doubts that things will improve', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA28', 2, 'Consistently feels hopeless but accepts reassurances', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA28', 3, 'Expressed feelings of discouragement, despair, pessimism about future...', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA28', 4, 'Spontaneously and inappropriately perseverates I will never get well', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA22', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON DIURNAL VARIATION - AM');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'HA12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON RETARDATION');
add_assessment_code(v_id1, owner_id, owner_id, 'HA12', 0, 'Normal speech and thought', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA12', 1, 'Slight retardation at interview', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA12', 2, 'Obvious retardation at interview', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA12', 3, 'Interview difficult', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA12', 4, 'Complete stupor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA18', 31, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON GENITAL SYMPTOMS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA18', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA18', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA18', 2, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA19', 32, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON HYPOCHONDRIASIS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA19', 0, 'Not present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA19', 1, 'Self-absorption (bodily)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA19', 2, 'Preocupation with health', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA19', 3, 'Frequent complaints, requests for help, etc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA19', 4, 'Hypochondriacal delusions', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA13', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON AGITATION');
add_assessment_code(v_id1, owner_id, owner_id, 'HA13', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA13', 1, 'Playing with hands, hair, etc.', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA13', 2, 'Hand-wringing, nail biting, hair pulling, biting of lips', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'HA10', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON INSOMNIA LATE');
add_assessment_code(v_id1, owner_id, owner_id, 'HA10', 0, 'No diffuculty', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA10', 1, 'Waking in early hours of the morning but going back to sleep', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA10', 2, 'Unable to fall asleep again if gets out of bed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA11', 24, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON WORK AND ACTIVITIES');
add_assessment_code(v_id1, owner_id, owner_id, 'HA11', 0, 'No diffuculty', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA11', 1, 'Thoughts and feeling of incapacity, fatigue or weakness related to work', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA11', 2, 'Loss of interest in activities, hobbies, or work', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA11', 3, 'Decrease in acctual time spent in activities', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA11', 4, 'Stopped working because of present illness', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA16', 29, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON SOMATIC SYM GASTRO');
add_assessment_code(v_id1, owner_id, owner_id, 'HA16', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA16', 1, 'Loss of appetite but eating without staff encouragement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA16', 2, 'Difficulty eating without staff urging', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'HA14', 27, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON ANXIETY PSYCHIC');
add_assessment_code(v_id1, owner_id, owner_id, 'HA14', 0, 'No difficulty', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA14', 1, 'Subjective tension and irritability', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA14', 2, 'Worrying about minor matters', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA14', 3, 'Apprehensive attitude apparent in face or speech', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA14', 4, 'Fears expressed without questioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA15', 28, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON ANXIETY SOMATIC');
add_assessment_code(v_id1, owner_id, owner_id, 'HA15', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA15', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA15', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA15', 3, 'Severe', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA15', 4, 'Incapacitating', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON MEDICATION STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA24', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON DEPERSONALIZTN/DEREALIZTN');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'HA23', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON DIURNAL VARIATION - PM');

add_assessment_score(v_id1, owner_id, owner_id, 'HA17', 30, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON SOMATIC SYM GENERAL');
add_assessment_code(v_id1, owner_id, owner_id, 'HA17', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA17', 1, 'Heaviness in limbs, back or head, loss of energy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA17', 2, 'Any clear cut symptom', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'HA9', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON INSOMNIA MIDDLE');
add_assessment_code(v_id1, owner_id, owner_id, 'HA9', 0, 'No diffuculty', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA9', 1, 'Restless and disturbed durring the night', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA9', 2, 'Waking durring the night', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON PATIENT STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'HA21', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON INSIGHT');
add_assessment_code(v_id1, owner_id, owner_id, 'HA21', 0, 'Acknowledges beeing depressed and ill', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA21', 1, 'Acknowledges issness but attributes to external factors', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA21', 2, 'Denies being ill at all', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA27', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON HELPLESSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA27', 0, 'Not present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA27', 1, 'Subjective feelings which are elicited only by inquiry', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA27', 2, 'Patient volunteers his helpless feelings', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA27', 3, 'Requires urging, guidance, and reassurance to accomplish ward choirs', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA27', 4, 'Requires physical assistance for dress, eating, or personal hygiene', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA25', 38, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON PARANOID SYMPTOMS');
add_assessment_code(v_id1, owner_id, owner_id, 'HA25', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA25', 1, 'Moderate Suspiciousness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA25', 2, 'Severe Suspiciousness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA25', 3, 'Ideas of reference', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA25', 4, 'Delusions of reference &'||'''''||'''' persecution', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA26', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON OBSESSNL/COMPULSV SYMPTOMS');

add_assessment_score(v_id1, owner_id, owner_id, 'HA20', 33, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON LOSS OF WEIGHT');
add_assessment_code(v_id1, owner_id, owner_id, 'HA20', 0, 'Less than 1lb. weight loss in a week', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA20', 1, 'Greater than 1lb. weight loss in a week', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA20', 2, 'Greater than 2lb. weight loss in a week', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON PROCEDURE CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'HA5', 18, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON DEPRESSED MOOD');
add_assessment_code(v_id1, owner_id, owner_id, 'HA5', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA5', 1, 'These feeling states indicated only on questioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA5', 2, 'These feeling states spontaneously reported verbaly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA5', 3, 'Communicates feeling states nonverbaly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA5', 4, 'Patient reports VIRTUALLY ONLY these feeling states', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA6', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON FEELINGS OF GUILT');
add_assessment_code(v_id1, owner_id, owner_id, 'HA6', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA6', 1, 'Self-reproach, feels he has let people down', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA6', 2, 'Ideas of guilt or rumination over past errors or sinful deeds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA6', 3, 'Present illness is a punishment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA6', 4, 'Hears accusatory voices, threatening visual hallucinations', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'HA7', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'HAMILTON SUICIDE');
add_assessment_code(v_id1, owner_id, owner_id, 'HA7', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA7', 1, 'Feels life is not worth living', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA7', 2, 'Wishes he were dead or any thoughts of possible death to self', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA7', 3, 'Suicide ideas or gesture', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HA7', 4, 'Attempts at suicide', 'integer');

commit;
END;
/
