
--Add hamilton
create or replace procedure add_hamilton_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
BATCHNUM varchar2,
DOCNUM varchar2,
ENT1 float,
ENT2 float,
ID varchar2,
ASS float,
WEEK float,
PROC float,
REL integer,
FRM varchar2,
VER float,
DATE varchar,
RATER float,
RATER2 float,
DRUGSTAT float,
MED integer,
USG float,
HA5 integer,
HA6 integer,
HA7 integer,
HA8 integer,
HA9 integer,
HA10 integer,
HA11 integer,
HA12 integer,
HA13 integer,
HA14 integer,
HA15 integer,
HA16 integer,
HA17 integer,
HA18 integer,
HA19 integer,
HA20 integer,
HA21 integer,
HA22 float,
HA23 float,
HA24 float,
HA25 integer,
HA26 float,
HA27 integer,
HA28 integer,
HA29 integer)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('hamilton');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'BATCHNUM', 'varchar', 1, NULL, batchnum, NULL, batchnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEEK', 'float', 7, week, to_char(week), week, to_char(week), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'USG', 'float', 17, usg, to_char(usg), usg, to_char(usg), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 14, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA29', 'integer', 42, ha29, to_char(ha29), ha29, to_char(ha29), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA8', 'integer', 21, ha8, to_char(ha8), ha8, to_char(ha8), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA28', 'integer', 41, ha28, to_char(ha28), ha28, to_char(ha28), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA22', 'float', 35, ha22, to_char(ha22), ha22, to_char(ha22), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FRM', 'varchar', 10, NULL, frm, NULL, frm, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA12', 'integer', 25, ha12, to_char(ha12), ha12, to_char(ha12), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA18', 'integer', 31, ha18, to_char(ha18), ha18, to_char(ha18), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA19', 'integer', 32, ha19, to_char(ha19), ha19, to_char(ha19), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 13, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'REL', 'integer', 9, rel, to_char(rel), rel, to_char(rel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA13', 'integer', 26, ha13, to_char(ha13), ha13, to_char(ha13), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DATE', 'timestamp', 12, NULL, date, NULL, date, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'VER', 'float', 11, ver, to_char(ver), ver, to_char(ver), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA10', 'integer', 23, ha10, to_char(ha10), ha10, to_char(ha10), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA11', 'integer', 24, ha11, to_char(ha11), ha11, to_char(ha11), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA16', 'integer', 29, ha16, to_char(ha16), ha16, to_char(ha16), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 5, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA14', 'integer', 27, ha14, to_char(ha14), ha14, to_char(ha14), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA15', 'integer', 28, ha15, to_char(ha15), ha15, to_char(ha15), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 6, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'MED', 'integer', 16, med, to_char(med), med, to_char(med), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA24', 'float', 37, ha24, to_char(ha24), ha24, to_char(ha24), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DOCNUM', 'varchar', 2, NULL, docnum, NULL, docnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA23', 'float', 36, ha23, to_char(ha23), ha23, to_char(ha23), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA17', 'integer', 30, ha17, to_char(ha17), ha17, to_char(ha17), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT1', 'float', 3, ent1, to_char(ent1), ent1, to_char(ent1), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA9', 'integer', 22, ha9, to_char(ha9), ha9, to_char(ha9), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT2', 'float', 4, ent2, to_char(ent2), ent2, to_char(ent2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'float', 15, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA21', 'integer', 34, ha21, to_char(ha21), ha21, to_char(ha21), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA27', 'integer', 40, ha27, to_char(ha27), ha27, to_char(ha27), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA25', 'integer', 38, ha25, to_char(ha25), ha25, to_char(ha25), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA26', 'float', 39, ha26, to_char(ha26), ha26, to_char(ha26), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA20', 'integer', 33, ha20, to_char(ha20), ha20, to_char(ha20), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROC', 'float', 8, proc, to_char(proc), proc, to_char(proc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA5', 'integer', 18, ha5, to_char(ha5), ha5, to_char(ha5), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA6', 'integer', 19, ha6, to_char(ha6), ha6, to_char(ha6), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HA7', 'integer', 20, ha7, to_char(ha7), ha7, to_char(ha7), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_hamilton_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
