
--Add master
create or replace procedure master(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('master', 'master', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'TOBACCO', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER TOBACCO USE, 0=NO 1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_DTI', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER DIFFUSION TENSOR IMAGING PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_GEN', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GENE ASSOCIATION CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'AGE', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER AGE, 0-99"');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FAL', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FET. ALC. CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_AUT', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER AUTISM CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FMR', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FUNCTIONAL MRI PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'ENTRYDAT', 19, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ENTRY DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_TDK', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TARDIVE DYS. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_THM', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMIC CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RATER ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_URO', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER URODYNAMIC PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_GER', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GERIATRIC PATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_GEN', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER GENE ASSOCIATION');

add_assessment_score(v_id1, owner_id, owner_id, 'NURSE', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NURSE ASSIGNED TO SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'RACE', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER RACE, 1 TO 6"');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 1, 'Caucasian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 2, 'African-American', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 3, 'Hispanic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 4, 'American Indian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 5, 'Asian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'RACE', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BFC', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN FUNCT. &''||'' COGNITION PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BPL', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BIPOLAR PROTOCOL PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'SUBSOC', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF SUBJECT, 1 TO 5"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LON', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LONGITUDINAL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'HEIGHT', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HEIGHT IN CM');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LIL', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LILLY PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MFE', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL PATIENT, FIRST EPISODE"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LOB', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY PATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CRC', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CRC INPATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'SEX', 15, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SEX, 1=MALE 2=FEMALE"');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 1, 'Male', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SEX', 2, 'Female', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FBN', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'fBIRN PROTOCOL PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CHRONIC', 13, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER CHRONICITY, 0 TO 2"');
add_assessment_code(v_id1, owner_id, owner_id, 'CHRONIC', 0, 'Non-longitudnal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CHRONIC', 1, 'First Episode', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CHRONIC', 2, 'Recent Onset', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_BFC', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN FUNCT. &''||'' COGNITION CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_PET', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER PET PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BTM', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BRAIN TRAUMA');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMTYPE', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY TYPE');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_BLD', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BLOOD FL0W PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FMR', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FUNCTIONAL MRI CONTROL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CLO', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CLOZAPINE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_NIC', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_JAT', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER JAPANESE TWIN');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAM', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'WEIGHT', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER WEIGHT IN KG');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CLP', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CLEFT LIP/PALATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_NIC', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NICOTINE CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_AUT', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER AUTISM PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MAR', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MARIJUANA STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_THM', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMIC PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'HAND', 20, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER HANDEDNESS, 1=RT 2=LF 3=MIX"');
add_assessment_code(v_id1, owner_id, owner_id, 'HAND', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HAND', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HAND', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'HAND', 3, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PILOT_CB', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CEREBELLUM PILOT STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_TWN', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TWIN CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MCH', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL PATIENT, CHRONIC"');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_DAD', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF DAD');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_MCH', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL CONTROL, CHRONIC"');

add_assessment_score(v_id1, owner_id, owner_id, 'EDUC_MOM', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EDUC. ACHIEVEMENT OF MOM');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 8, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CHS', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MAX''S CHILDHOOD STROKE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_HYD', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HYDRATIONAL PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_LOB', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LOBOTOMY CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'FAMNUM', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OUT', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER CRC OUTPATIENT PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_PHA', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER PHANTOM');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_MRI', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER MRI COMPONENT PATIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_TMS', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER TRANSCRAN STIMUL PATIENT PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_EMO', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION CTRL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_FBN', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'fBIRN PROTOCOL CONTROL');

add_assessment_score(v_id1, owner_id, owner_id, 'CON_MFE', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MIND PROTOCOL CONTROL, FIRST EPISODE"');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OTH', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER OTHER PROT. CATEGORY');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_ANO', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER ANOREXIA PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_OLN', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER OLANZAPINE STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 14, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER STATUS AT INTAKE, 0 TO 5"');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 1, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 2, 'Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 3, 'Neuroleptic Non-Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 4, 'Almost Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 5, 'Totally Psychoactive Drug Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'DRUGSTAT', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_HAL', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER HALDOL PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_CON', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER NORMAL CONTROL PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_FAL', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER FET. ALC. PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PARSOC', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MASTER SOCIAL CLASS OF PARENTS, 1 TO 5"');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 1, 'Top rank', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 2, 'High rank', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 3, 'White collar', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 4, 'Labor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PARSOC', 5, 'Unskilled', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_RIS', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER RISP. VS. HAL. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_LI2', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER DEL''S OLANZAPINE PROTOCOL');

add_assessment_score(v_id1, owner_id, owner_id, 'PROT_EMO', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER EMOTION PAT. PROT.');

add_assessment_score(v_id1, owner_id, owner_id, 'PILOT_TM', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER THALAMUS PILOT STUDY');

add_assessment_score(v_id1, owner_id, owner_id, 'INITIALS', 7, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MASTER LIST SUBJECT''S INITIALS');

commit;
END;
/
