
--Add master
create or replace procedure add_master_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
BATCHNUM varchar2,
DOCNUM varchar2,
ENT1 float,
ENT2 float,
FRM varchar2,
VER float,
INITIALS varchar2,
ID varchar2,
ASS float,
NURSE float,
RATER float,
RATER2 float,
CHRONIC integer,
DRUGSTAT integer,
SEX integer,
AGE float,
HEIGHT float,
WEIGHT float,
ENTRYDAT varchar,
HAND integer,
RACE integer,
TOBACCO float,
EDUC float,
EDUC_DAD float,
EDUC_MOM float,
PARSOC integer,
SUBSOC float,
PROT_BPL float,
CON_GEN float,
PROT_GEN float,
PROT_CRC float,
PROT_OUT float,
PROT_GER float,
PROT_LI2 float,
PROT_LON float,
PROT_OLN float,
PROT_PET float,
CON_FBN float,
PROT_FBN float,
CON_FMR float,
PROT_FMR float,
PROT_MAR float,
CON_MCH float,
PROT_MCH float,
CON_MFE float,
PROT_MFE float,
PROT_CON float,
PROT_OTH float,
PROT_DTI float,
PROT_MRI float,
PROT_PHA float,
PROT_TMS float,
PROT_ANO float,
PROT_BLD float,
PROT_CLO float,
PROT_FAM float,
FAMTYPE float,
FAMNUM float,
PROT_HAL float,
PROT_LIL float,
PROT_URO float,
PROT_HYD float,
PROT_RIS float,
PROT_TDK float,
PROT_CLP float,
CON_NIC float,
PROT_NIC float,
CON_THM float,
PROT_THM float,
CON_TWN float,
CON_AUT float,
PROT_AUT float,
CON_BFC float,
PROT_BFC float,
PROT_BTM float,
PROT_CHS float,
CON_EMO float,
PROT_EMO float,
CON_FAL float,
PROT_FAL float,
PROT_JAT float,
CON_LOB float,
PROT_LOB float,
PILOT_CB float,
PILOT_TM float)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('master');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 12, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'TOBACCO', 'float', 22, tobacco, to_char(tobacco), tobacco, to_char(tobacco), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_DTI', 'float', 49, prot_dti, to_char(prot_dti), prot_dti, to_char(prot_dti), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_GEN', 'float', 29, con_gen, to_char(con_gen), con_gen, to_char(con_gen), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'AGE', 'float', 16, age, to_char(age), age, to_char(age), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FAL', 'float', 79, con_fal, to_char(con_fal), con_fal, to_char(con_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_AUT', 'float', 71, con_aut, to_char(con_aut), con_aut, to_char(con_aut), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FMR', 'float', 41, prot_fmr, to_char(prot_fmr), prot_fmr, to_char(prot_fmr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENTRYDAT', 'timestamp', 19, NULL, entrydat, NULL, entrydat, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_TDK', 'float', 64, prot_tdk, to_char(prot_tdk), prot_tdk, to_char(prot_tdk), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_THM', 'float', 68, con_thm, to_char(con_thm), con_thm, to_char(con_thm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 11, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_URO', 'float', 61, prot_uro, to_char(prot_uro), prot_uro, to_char(prot_uro), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_GER', 'float', 33, prot_ger, to_char(prot_ger), prot_ger, to_char(prot_ger), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_GEN', 'float', 30, prot_gen, to_char(prot_gen), prot_gen, to_char(prot_gen), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'NURSE', 'float', 10, nurse, to_char(nurse), nurse, to_char(nurse), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC', 'float', 23, educ, to_char(educ), educ, to_char(educ), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RACE', 'integer', 21, race, to_char(race), race, to_char(race), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BFC', 'float', 74, prot_bfc, to_char(prot_bfc), prot_bfc, to_char(prot_bfc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BPL', 'float', 28, prot_bpl, to_char(prot_bpl), prot_bpl, to_char(prot_bpl), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SUBSOC', 'float', 27, subsoc, to_char(subsoc), subsoc, to_char(subsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LON', 'float', 35, prot_lon, to_char(prot_lon), prot_lon, to_char(prot_lon), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HEIGHT', 'float', 17, height, to_char(height), height, to_char(height), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LIL', 'float', 60, prot_lil, to_char(prot_lil), prot_lil, to_char(prot_lil), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MFE', 'float', 46, prot_mfe, to_char(prot_mfe), prot_mfe, to_char(prot_mfe), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LOB', 'float', 83, prot_lob, to_char(prot_lob), prot_lob, to_char(prot_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CRC', 'float', 31, prot_crc, to_char(prot_crc), prot_crc, to_char(prot_crc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SEX', 'integer', 15, sex, to_char(sex), sex, to_char(sex), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FBN', 'float', 39, prot_fbn, to_char(prot_fbn), prot_fbn, to_char(prot_fbn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CHRONIC', 'integer', 13, chronic, to_char(chronic), chronic, to_char(chronic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT2', 'float', 4, ent2, to_char(ent2), ent2, to_char(ent2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_BFC', 'float', 73, con_bfc, to_char(con_bfc), con_bfc, to_char(con_bfc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_PET', 'float', 37, prot_pet, to_char(prot_pet), prot_pet, to_char(prot_pet), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BTM', 'float', 75, prot_btm, to_char(prot_btm), prot_btm, to_char(prot_btm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMTYPE', 'float', 57, famtype, to_char(famtype), famtype, to_char(famtype), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_BLD', 'float', 54, prot_bld, to_char(prot_bld), prot_bld, to_char(prot_bld), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FMR', 'float', 40, con_fmr, to_char(con_fmr), con_fmr, to_char(con_fmr), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CLO', 'float', 55, prot_clo, to_char(prot_clo), prot_clo, to_char(prot_clo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'BATCHNUM', 'varchar', 1, NULL, batchnum, NULL, batchnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 9, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_NIC', 'float', 67, prot_nic, to_char(prot_nic), prot_nic, to_char(prot_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_JAT', 'float', 81, prot_jat, to_char(prot_jat), prot_jat, to_char(prot_jat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'VER', 'float', 6, ver, to_char(ver), ver, to_char(ver), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAM', 'float', 56, prot_fam, to_char(prot_fam), prot_fam, to_char(prot_fam), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEIGHT', 'float', 18, weight, to_char(weight), weight, to_char(weight), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CLP', 'float', 65, prot_clp, to_char(prot_clp), prot_clp, to_char(prot_clp), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_NIC', 'float', 66, con_nic, to_char(con_nic), con_nic, to_char(con_nic), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_AUT', 'float', 72, prot_aut, to_char(prot_aut), prot_aut, to_char(prot_aut), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MAR', 'float', 42, prot_mar, to_char(prot_mar), prot_mar, to_char(prot_mar), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_THM', 'float', 69, prot_thm, to_char(prot_thm), prot_thm, to_char(prot_thm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FRM', 'varchar', 5, NULL, frm, NULL, frm, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'HAND', 'integer', 20, hand, to_char(hand), hand, to_char(hand), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PILOT_CB', 'float', 84, pilot_cb, to_char(pilot_cb), pilot_cb, to_char(pilot_cb), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_TWN', 'float', 70, con_twn, to_char(con_twn), con_twn, to_char(con_twn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MCH', 'float', 44, prot_mch, to_char(prot_mch), prot_mch, to_char(prot_mch), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_DAD', 'float', 24, educ_dad, to_char(educ_dad), educ_dad, to_char(educ_dad), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_MCH', 'float', 43, con_mch, to_char(con_mch), con_mch, to_char(con_mch), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'EDUC_MOM', 'float', 25, educ_mom, to_char(educ_mom), educ_mom, to_char(educ_mom), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 8, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CHS', 'float', 76, prot_chs, to_char(prot_chs), prot_chs, to_char(prot_chs), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_HYD', 'float', 62, prot_hyd, to_char(prot_hyd), prot_hyd, to_char(prot_hyd), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_LOB', 'float', 82, con_lob, to_char(con_lob), con_lob, to_char(con_lob), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FAMNUM', 'float', 58, famnum, to_char(famnum), famnum, to_char(famnum), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DOCNUM', 'varchar', 2, NULL, docnum, NULL, docnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OUT', 'float', 32, prot_out, to_char(prot_out), prot_out, to_char(prot_out), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_PHA', 'float', 51, prot_pha, to_char(prot_pha), prot_pha, to_char(prot_pha), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_MRI', 'float', 50, prot_mri, to_char(prot_mri), prot_mri, to_char(prot_mri), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_TMS', 'float', 52, prot_tms, to_char(prot_tms), prot_tms, to_char(prot_tms), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_EMO', 'float', 77, con_emo, to_char(con_emo), con_emo, to_char(con_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_FBN', 'float', 38, con_fbn, to_char(con_fbn), con_fbn, to_char(con_fbn), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'CON_MFE', 'float', 45, con_mfe, to_char(con_mfe), con_mfe, to_char(con_mfe), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OTH', 'float', 48, prot_oth, to_char(prot_oth), prot_oth, to_char(prot_oth), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT1', 'float', 3, ent1, to_char(ent1), ent1, to_char(ent1), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_ANO', 'float', 53, prot_ano, to_char(prot_ano), prot_ano, to_char(prot_ano), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_OLN', 'float', 36, prot_oln, to_char(prot_oln), prot_oln, to_char(prot_oln), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'integer', 14, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_HAL', 'float', 59, prot_hal, to_char(prot_hal), prot_hal, to_char(prot_hal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_CON', 'float', 47, prot_con, to_char(prot_con), prot_con, to_char(prot_con), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_FAL', 'float', 80, prot_fal, to_char(prot_fal), prot_fal, to_char(prot_fal), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PARSOC', 'integer', 26, parsoc, to_char(parsoc), parsoc, to_char(parsoc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_RIS', 'float', 63, prot_ris, to_char(prot_ris), prot_ris, to_char(prot_ris), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_LI2', 'float', 34, prot_li2, to_char(prot_li2), prot_li2, to_char(prot_li2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROT_EMO', 'float', 78, prot_emo, to_char(prot_emo), prot_emo, to_char(prot_emo), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PILOT_TM', 'float', 85, pilot_tm, to_char(pilot_tm), pilot_tm, to_char(pilot_tm), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'INITIALS', 'varchar', 7, NULL, initials, NULL, initials, NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_master_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
