
--Add medhist
create or replace procedure medhist(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('medhist', 'medhist', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ME20', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST CORON. ART. DIS.? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME12', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST SEIZURES? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME22', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST DIABETES MELLITUS? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME23', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST HYPERTHYROIDISM? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME24', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST HYPOTHYROIDISM? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME25', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST OTHER ENDO. DIS.? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'ME27', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST OTHER MEDICATION? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME5', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST SCHIZ. SPECTRUM? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME4', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST MAJ. DEPR. DIS.? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME7', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST ALCOHOLISM? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME6', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST OTHER PSYCH. DIS? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST RATER');

add_assessment_score(v_id1, owner_id, owner_id, 'ME3', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST BIPOLAR DISORDER? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 11, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST DATE THE FORM WAS FILLED OUT');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ME9', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST DEMENTIA? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME8', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST DRUG DEPENDENCE? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST FIRST ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST 7-DIGIT HOSP. ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ME11', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST HEADACHES? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME10', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST HEAD TRAUMA? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME13', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST CVA? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST SECOND ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ME15', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST GAIT DIFFICULTY? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME14', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST MENINGITIS? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME17', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST BRAIN TUMOR? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME16', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST BRAIN SURGERY? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME19', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST HYPERTENSION? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME18', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST OTHER NEURO DIS? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'ME26', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST OTHER ILLNESS? 0=NO,1=YES"');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 7, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MED HIST INFORMANT TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ME21', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"MED HIST CARDIOVAS. DIS.? 0=NO,1=YES"');

commit;
END;
/
