
--Add medwash
create or replace procedure medwash(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('medwash', 'medwash', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT17', 231, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'ADDOSE1', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MSUNIT2', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. UNIT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE4', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'APADATE', 74, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON WASHOUT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE20', 210, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'APAUNIT1', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON UNIT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'UDSDONE', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH DRUG SCREEN OBTAINED?');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT12', 226, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 12');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT12', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT12', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT12', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT12', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT12', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE22', 212, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'WASHOUT', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH WASHOUT INITIATED IN-HOUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE23', 213, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'MSDATE', 60, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. WASHOUT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'COCAINE', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-COCAINE');

add_assessment_score(v_id1, owner_id, owner_id, 'APADOSE1', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ADUNIT1', 39, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. UNIT 1');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT1', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ADUNIT2', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. UNIT 2');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADUNIT2', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ADUNIT3', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXUNIT3', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXUNIT2', 54, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS UNIT 2');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT2', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXCODE2', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXCODE3', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ANTIPSYC', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTICS MONTH PRIOR ADMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE2', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'WASHREAS', 99, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH WASHOUT DISCONTINUED REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 1, 'Patient/family Wd consent, no change Sx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 2, 'Patient/family Wd consent, bad Sx change', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 3, 'Patient became dangerous to self / others', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 4, 'Patient suffering exacerbation of Sx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 5, 'Medical Wash prior to Hosp. by patient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 6, 'Minimal drug exposure, Full wash d/c', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'WASHREAS', 7, 'Other reason', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ANTIPARK', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON MONTH PRIOR ADMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE3', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE4', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT24', 238, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT18', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT22', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT23', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT20', 234, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE5', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT6', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT4', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT5', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT2', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT3', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYUNIT1', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION UNIT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MSDOSE2', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MSDOSE3', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'MSDOSE1', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXDOSE2', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT22', 188, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 22');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE16', 158, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT20', 186, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 20');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT21', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 21');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT24', 190, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 24');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE22', 140, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE13', 203, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'PREMWASH', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH WASHOUT DISCONTINUED PREMATURELY');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE24', 166, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE23', 165, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE22', 164, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE21', 163, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE20', 162, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT7', 221, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 7');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT7', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT7', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT7', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT7', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT7', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE15', 157, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT13', 227, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 13');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT13', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT13', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT13', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT13', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT13', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE5', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE4', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE6', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE1', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE3', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYCODE2', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE12', 202, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE24', 142, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'APAUNIT2', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON UNIT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APAUNIT3', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT8', 222, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 8');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT8', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT8', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT8', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT8', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT8', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'APSROUT1', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC ROUTE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ADCODE3', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ADCODE2', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'ADCODE1', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'APSDOSE3', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'APSDOSE2', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APSDOSE1', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'APSDATE', 18, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC WASHOUT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'ANTIDEPR', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. MONTH PRIOR ADMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE19', 209, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE18', 208, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT11', 225, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 11');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT11', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT11', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT11', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT11', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT11', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'APACODE1', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'APACODE3', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'APACODE2', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MSROUT1', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. ROUTE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE10', 200, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'MSROUT3', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'MSROUT2', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. ROUTE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE15', 205, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE14', 204, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE17', 207, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE16', 206, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT15', 181, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT2', 216, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 2');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT2', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT2', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT2', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT2', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT10', 224, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 10');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT10', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT10', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT10', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT10', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT10', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PHENCYC', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-PHENCYCLIDINE');

add_assessment_score(v_id1, owner_id, owner_id, 'APSUNIT1', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC UNIT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE24', 214, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT16', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT15', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT14', 228, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 14');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT14', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT14', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT14', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT14', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT14', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE21', 211, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'WASHDATE', 97, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH LAST WASHOUT DATE/FIRST TX');

add_assessment_score(v_id1, owner_id, owner_id, 'ADMTPSYC', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDS AT ADMISSION');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT3', 217, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 3');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT3', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT3', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT3', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT3', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT3', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT21', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'MSCODE2', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MSCODE3', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT19', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'MSCODE1', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE11', 201, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE18', 136, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE19', 137, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 7, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE12', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE13', 131, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE10', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE11', 129, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE16', 134, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE17', 135, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE14', 132, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE15', 133, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'APAROUT1', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON ROUTE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT9', 175, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 9');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT9', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT8', 174, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 8');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT8', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT3', 169, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 3');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT3', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT2', 168, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 2');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT2', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT1', 167, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 1');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT1', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT7', 173, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 7');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT7', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT6', 172, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 6');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT6', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT5', 171, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 5');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT5', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT4', 170, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 4');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT4', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT19', 185, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 19');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT18', 184, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 18');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ADDATE', 32, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. WASHOUT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT13', 179, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 13');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT13', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT12', 178, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 12');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT12', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT11', 177, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 11');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT11', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT10', 176, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 10');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT10', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT17', 183, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 17');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT16', 182, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 16');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 8, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT14', 180, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 14');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'UNIT14', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE4', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXDOSE1', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'APSUNIT2', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC UNIT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APSUNIT3', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'MSUNIT1', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. UNIT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE1', 143, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MSUNIT3', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. UNIT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE3', 145, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE5', 195, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE8', 150, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE9', 151, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE1', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'APSROUT2', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC ROUTE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APSROUT3', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ADDOSE3', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ADDOSE2', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE6', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE7', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE8', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE9', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'OPIATES', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-OPIATES');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE6', 196, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT9', 223, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 9');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT9', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT9', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT9', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT9', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT9', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'AMPHET', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-AMPHETAMINES');

add_assessment_score(v_id1, owner_id, owner_id, 'UNIT23', 189, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG UNIT 23');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT6', 220, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 6');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT6', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT6', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT6', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT6', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT5', 219, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 5');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT5', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT5', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT5', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT5', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT5', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT4', 218, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 4');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT4', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT4', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT4', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT4', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXDATE', 46, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS WASHOUT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE21', 139, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'ROUT1', 215, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG ROUTE 1');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT1', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT1', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT1', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ROUT1', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BENZODIA', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-BENZODIAZEPINE');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE7', 149, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'LINES', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS LINES COMPLETED');

add_assessment_score(v_id1, owner_id, owner_id, 'APADOSE3', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'APADOSE2', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 10, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH DATE FORM WAS DONE');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXCODE1', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXUNIT1', 53, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS UNIT 1');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 1, 'Microgram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 2, 'Milligram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 3, 'Gram', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 4, 'Unit', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 5, 'cc', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 6, 'ml', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXUNIT1', 7, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE1', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE3', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE2', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE5', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'MOODSTAB', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH MOOD STABIL. MONTH PRIOR ADMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'PSYDOSE6', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH PSYCHOACTIVE MEDICATION DOSE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'EVERPSYC', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH EVER PRESCRIBED PSYCHOACTIVE MED');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'BARBIT', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-BARBITURATES');

add_assessment_score(v_id1, owner_id, owner_id, 'APSCODE3', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DRUG CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'APSCODE2', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DRUG CODE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APSCODE1', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIPSYCHOTIC DRUG CODE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE23', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE17', 159, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE14', 156, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'CODE20', 138, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DRUG CODE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE12', 154, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE13', 155, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE10', 152, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE11', 153, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE18', 160, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE19', 161, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'OTHER', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-OTHER');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXIOLYT', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS MONTH PRIOR ADMIT');

add_assessment_score(v_id1, owner_id, owner_id, 'DECSIX', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH DECANOATE PAST SIX MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'APAROUT2', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON ROUTE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'APAROUT3', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTI-PARKINSON ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'TETRAHYD', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH URINE DRUG SCREEN-TETRAHYDROCAN.');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE1', 191, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'UDSDATE', 88, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH DRUG SCREEN DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE3', 193, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE2', 192, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE2', 144, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE4', 194, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE7', 197, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE5', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE9', 199, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE8', 198, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS RECENT DOSE DATE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'DOSE6', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH RESCUE MEDS DAILY DOSE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXDOSE3', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS DOSE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ADROUT1', 42, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. ROUTE 1');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT1', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT1', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT1', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT1', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ADROUT2', 43, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. ROUTE 2');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT2', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT2', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT2', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ADROUT2', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ADROUT3', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANTIDEPR. ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXROUT3', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS ROUTE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXROUT2', 57, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS ROUTE 2');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT2', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT2', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT2', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT2', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ANXROUT1', 56, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MEDWASH ANXIOLYTICS ROUTE 1');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT1', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT1', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT1', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ANXROUT1', 4, 'Other', 'integer');

commit;
END;
/
