
--Add mriinfo
create or replace procedure mriinfo(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('mriinfo', 'mriinfo', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT8', 173, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT8', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT8', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT8', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT8', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT8', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT9', 174, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT9', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT9', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT9', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT9', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT9', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT6', 171, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT6', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT6', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT6', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT6', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT7', 172, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT7', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT7', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT7', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT7', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT7', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT4', 169, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT4', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT4', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT4', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT4', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT5', 170, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT5', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT5', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT5', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT5', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT5', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT2', 167, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT2', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT2', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT2', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT2', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT2', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT3', 168, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT3', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT3', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT3', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT3', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT3', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT1', 166, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT1', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT1', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT1', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT1', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT1', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT10', 175, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT10', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT10', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT10', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT10', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT10', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE19', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT12', 177, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT12', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT12', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT12', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT12', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT12', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT13', 178, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT13', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT13', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT13', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT13', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT13', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT14', 179, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT14', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT14', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT14', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT14', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT14', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'QPO', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Overall PDT2 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT16', 181, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT16', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT16', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT16', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT16', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT16', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'QPM', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Middle PDT2 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT18', 183, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT18', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT18', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT18', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT18', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT18', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MR5', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Medication Status');

add_assessment_score(v_id1, owner_id, owner_id, 'QPA', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Anterior PDT2 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'MR2', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE18', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MR18', 46, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Menstrual Status');
add_assessment_code(v_id1, owner_id, owner_id, 'MR18', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MR18', 1, 'Mensturating', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MR18', 2, 'Postmenopausal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MR18', 3, 'Amenorrhea', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MR19', 47, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Date of Last Menstrual Cycle');

add_assessment_score(v_id1, owner_id, owner_id, 'MR16', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Minutes Since Last Cigarette');

add_assessment_score(v_id1, owner_id, owner_id, 'MR17', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sex of Subject');

add_assessment_score(v_id1, owner_id, owner_id, 'QPP', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Posterior PDT2 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'MR15', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Nicotine Content');

add_assessment_score(v_id1, owner_id, owner_id, 'MR12', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Route 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MR13', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Cigarettes in last 8 hours');

add_assessment_score(v_id1, owner_id, owner_id, 'MR10', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Code 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MR11', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Dose 1');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT11', 176, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT11', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT11', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT11', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT11', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT11', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Follow up Period');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE11', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE13', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG10', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG11', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG12', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG13', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG14', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG15', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG16', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG17', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG18', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG19', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME11', 132, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE14', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO First Entry Person');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Second Entry Person');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE17', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE16', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME15', 136, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT8', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT9', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT2', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT3', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME10', 131, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT1', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT6', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT7', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT4', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT5', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG21', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT18', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT19', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG20', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT14', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT15', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT16', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT17', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT10', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT11', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT12', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT13', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MR100', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Code 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME9', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME8', 129, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME1', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE10', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME3', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME2', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME5', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME4', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME7', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME6', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT15', 180, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT15', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT15', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT15', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT15', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT15', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG8', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG9', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG6', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG7', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG4', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG5', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG2', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG3', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME18', 139, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT21', 186, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT21', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT21', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT21', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT21', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT21', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT20', 185, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT20', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT20', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT20', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT20', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT20', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG1', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MR9', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Document Number');

add_assessment_score(v_id1, owner_id, owner_id, 'HEAD2', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Head Size Nose-Posterior');

add_assessment_score(v_id1, owner_id, owner_id, 'HEAD1', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Head Size Anterior-Posterior');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT17', 182, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT17', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT17', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT17', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT17', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT17', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT19', 184, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 route');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT19', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT19', 1, 'Oral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT19', 2, 'IV', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT19', 3, 'IM', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MRROUT19', 4, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 10, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Procedure Code');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'MRI', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'TC -99m -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'TC -99m -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'FMRI -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'FMRI -off meds', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Urine Specific Gravity');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Second Checker of Form');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME20', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME21', 142, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME22', 143, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MR109', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Gold Fillings');

add_assessment_score(v_id1, owner_id, owner_id, 'MR108', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Side of Dental Work');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Rater');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 13, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Reliability Number');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ACT', 11, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Activation Task');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 1, 'CPT', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 2, 'Tower of London', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 3, 'Wis. Card Sort', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 4, 'ECT', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 5, 'Room Rest', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 6, 'Visual Stim I', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 7, 'Visual Dep I', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'ACT', 8, 'Porteus Maze', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'MR103', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Cigarettes Weekly Average');

add_assessment_score(v_id1, owner_id, owner_id, 'MR102', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Route 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MR101', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Sedated Drug Dose 2');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDRUG22', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 code');

add_assessment_score(v_id1, owner_id, owner_id, 'MR107', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Dental Work');

add_assessment_score(v_id1, owner_id, owner_id, 'MR106', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Ferromagnetic Material in Head');

add_assessment_score(v_id1, owner_id, owner_id, 'MR105', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Regularity of Cycle');

add_assessment_score(v_id1, owner_id, owner_id, 'MR104', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Length of Cycle');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Assessment');

add_assessment_score(v_id1, owner_id, owner_id, 'MRROUT22', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 route');

add_assessment_score(v_id1, owner_id, owner_id, 'QTP', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Posterior T1 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE9', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'QTA', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Anterior T1 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'QTO', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Overall T1 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'QTM', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO QA Middle T1 Rating');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Version Number');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 14, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE15', 158, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT21', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT20', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'MRUNIT22', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'HEAD3', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Head Size Intra Oral');

add_assessment_score(v_id1, owner_id, owner_id, 'MR14', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Nicotine Brand Code');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE8', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'CAFF1', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Caffeine in last 3.5 hours');

add_assessment_score(v_id1, owner_id, owner_id, 'CAFF2', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Caffeine Daily Average');

add_assessment_score(v_id1, owner_id, owner_id, 'MRQID', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO MRQID');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE20', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE21', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE22', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE3', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 6, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Date');

add_assessment_score(v_id1, owner_id, owner_id, 'MR110', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Side of Gold Fillings');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE2', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE22', 165, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug22 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE21', 164, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug21 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE20', 163, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug20 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE12', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Batch Number');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME14', 135, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME17', 138, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME16', 137, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE8', 151, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug8 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE9', 152, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug9 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME13', 134, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME12', 133, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE4', 147, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE5', 148, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE6', 149, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE7', 150, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRTIME19', 140, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 time');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE1', 144, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE2', 145, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug2 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE3', 146, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug3 date');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO 7-Digit Hospital ID Number');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE16', 159, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug16 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE17', 160, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug17 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE14', 157, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug14 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE15', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug15 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE12', 155, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug12 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE13', 156, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug13 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE10', 153, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug10 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE11', 154, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug11 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE5', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug5 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE4', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug4 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE7', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug7 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE6', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug6 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDOSE1', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug1 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE18', 161, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug18 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MRDATE19', 162, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO drug19 date');

add_assessment_score(v_id1, owner_id, owner_id, 'MR20', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'MRIINFO Number of Drug Lines');

commit;
END;
/
