
--Add neuro
create or replace procedure neuro(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('neuro', 'neuro', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'NE29', 42, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM APRAXIC GAIT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE29', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE29', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE28', 41, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FESTINATION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE28', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE28', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE67', 80, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER NOSE TEST ACC MOT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE67', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE67', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE66', 79, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER TAP TEST MIRROR MOVES');
add_assessment_code(v_id1, owner_id, owner_id, 'NE66', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE66', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE60', 73, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OCULAR PURSUIT MOVEMENTS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE60', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE60', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE63', 76, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RIGHT LEFT DISCRIMINATION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE63', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE63', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE62', 75, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FACE HAND TEST');
add_assessment_code(v_id1, owner_id, owner_id, 'NE62', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE62', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE21', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM VAGUS ELEV SOFT PALATE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE21', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE21', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE20', 33, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM GLOSSOPHARYNGEAL ARTIC');
add_assessment_code(v_id1, owner_id, owner_id, 'NE20', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE20', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE23', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM HYPOGLOSSAL TONGUE PROTR');

add_assessment_score(v_id1, owner_id, owner_id, 'NE22', 35, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SPINAL ACCESS STERN STREN');
add_assessment_code(v_id1, owner_id, owner_id, 'NE22', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE22', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE25', 38, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM STEPPAGE GAIT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE25', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE25', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE24', 37, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM HYPOGLOSSAL ATRO FASCICUL');
add_assessment_code(v_id1, owner_id, owner_id, 'NE24', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE24', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE27', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SPASTIC GAIT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE27', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE27', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE26', 39, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM CEREBELLAR ATAXIC GAIT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE26', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE26', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE61', 74, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM LATERAL GAZE IMPERSISTENC');
add_assessment_code(v_id1, owner_id, owner_id, 'NE61', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE61', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM CHRONO ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE77', 90, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TANDEM GAIT GROSS ATAXIA');
add_assessment_code(v_id1, owner_id, owner_id, 'NE77', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE77', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE74', 87, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST INV MOV CHO');
add_assessment_code(v_id1, owner_id, owner_id, 'NE74', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE74', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FOLLOW-UP PERIOD (months)');

add_assessment_score(v_id1, owner_id, owner_id, 'NE10', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OPTIC FUNDOSCOPIC EXAM');
add_assessment_code(v_id1, owner_id, owner_id, 'NE10', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE10', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE11', 24, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OPTIC VISUAL FIELDS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE11', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE11', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE12', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OCULOMOTOR ABDUCENS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE12', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE12', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE13', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OCULOMOTOR EMM');
add_assessment_code(v_id1, owner_id, owner_id, 'NE13', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE13', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE14', 27, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OCULOMOTOR PUP REACTION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE14', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE14', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE15', 28, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TRIGEMINAL FACIAL SENSE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE15', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE15', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE16', 29, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TRIGEMINAL CORNEAL REFLEX');
add_assessment_code(v_id1, owner_id, owner_id, 'NE16', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE16', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE17', 30, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TRIGEMINAL MUSCLES MAST');
add_assessment_code(v_id1, owner_id, owner_id, 'NE17', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE17', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE18', 31, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FACIAL SYMMETRY STRENGTH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE18', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE18', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE69', 82, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER NOSE TEST REST TRE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE69', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE69', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'NE68', 81, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER NOSE TEST INT TRE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE68', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE68', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE58', 71, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SENSORY SYSTEM GRAPHESTH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE58', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE58', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE59', 72, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SENSORY SYSTEM STEREOGNO');
add_assessment_code(v_id1, owner_id, owner_id, 'NE59', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE59', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE54', 67, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM COORDINATION HEEL KNEE SH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE54', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE54', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE55', 68, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SENSORY SYSTEM TOUCH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE55', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE55', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE56', 69, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SENSORY SYSTEM PAIN');
add_assessment_code(v_id1, owner_id, owner_id, 'NE56', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE56', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE57', 70, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SENSORY SYSTEM POSITION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE57', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE57', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE50', 63, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM ABNORMAL REFLEX BABINSKI');
add_assessment_code(v_id1, owner_id, owner_id, 'NE50', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE50', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE51', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM ABNORMAL REFLEX HOFFMAN');

add_assessment_score(v_id1, owner_id, owner_id, 'NE52', 65, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM COORDINATION FINGER NOSE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE52', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE52', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE53', 66, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM COORDINATION RAP ALTER PR');
add_assessment_code(v_id1, owner_id, owner_id, 'NE53', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE53', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE98', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM CURRENT PROBLEMS TEETH');

add_assessment_score(v_id1, owner_id, owner_id, 'NE99', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM DOES PATIENT WEAR DENTURE');

add_assessment_score(v_id1, owner_id, owner_id, 'NE90', 101, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM JAW');
add_assessment_code(v_id1, owner_id, owner_id, 'NE90', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE90', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE90', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE90', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE90', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE91', 102, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TONGUE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE91', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE91', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE91', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE91', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE91', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE92', 103, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM UPPER BODY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE92', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE92', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE92', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE92', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE92', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE93', 104, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM LOWER BODY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE93', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE93', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE93', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE93', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE93', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE94', 105, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM NECK SHOULDERS HIPS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE94', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE94', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE94', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE94', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE94', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE95', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SEVERITY ABNORMAL MOVEMEN');

add_assessment_score(v_id1, owner_id, owner_id, 'NE96', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INCAPACITATION ABNOR MOVE');

add_assessment_score(v_id1, owner_id, owner_id, 'NE97', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM PATIENT AWARENESS AB MOVE');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE8', 21, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OLFACTORY OLFACTION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE8', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE8', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE9', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM OPTIC VISUAL ACUITY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE9', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE9', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE6', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM PATIENT STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 1, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 2, 'Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 3, 'Neuroleptic Non-Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 4, 'Almost Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 5, 'Totally Psychoactive Drug Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE6', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE7', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MEDICATION STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'NE2', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TYPE OF FAMILY STUDY SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'NE3', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FAMILY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE1', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FAMILY STUDY SUBJECT?');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 10, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 20, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM DATE NEURO EXAM');

add_assessment_score(v_id1, owner_id, owner_id, 'NE49', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX ACHILLES LE');

add_assessment_score(v_id1, owner_id, owner_id, 'NE48', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX ACHILLES RI');

add_assessment_score(v_id1, owner_id, owner_id, 'NE47', 60, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX PATELLAR LE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE47', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE47', 1, 'Hypoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE47', 2, 'Normoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE47', 3, 'Hyperactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE47', 4, 'Clonus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE46', 59, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX PATELLAR RI');
add_assessment_code(v_id1, owner_id, owner_id, 'NE46', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE46', 1, 'Hypoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE46', 2, 'Normoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE46', 3, 'Hyperactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE46', 4, 'Clonus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE45', 58, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON RELFEX BICEPS LEFT');
add_assessment_code(v_id1, owner_id, owner_id, 'NE45', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE45', 1, 'Hypoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE45', 2, 'Normoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE45', 3, 'Hyperactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE45', 4, 'Clonus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE44', 57, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX BICEPS RIGH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE44', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE44', 1, 'Hypoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE44', 2, 'Normoactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE44', 3, 'Hyperactive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE44', 4, 'Clonus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE43', 56, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TENDON REFLEX OVERALL');
add_assessment_code(v_id1, owner_id, owner_id, 'NE43', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE43', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE42', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INVOLUNTARY MOVEMENT DYST');

add_assessment_score(v_id1, owner_id, owner_id, 'NE41', 54, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INV MOVE ATHETOSIS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE41', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE41', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE40', 53, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INV MOVE CHOREA');
add_assessment_code(v_id1, owner_id, owner_id, 'NE40', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE40', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE89', 100, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM LIPS AND PERIORAL AREA');
add_assessment_code(v_id1, owner_id, owner_id, 'NE89', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE89', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE89', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE89', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE89', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE88', 99, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLES OF FACIAL EXPRESS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE88', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE88', 1, 'Minimal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE88', 2, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE88', 3, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE88', 4, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE83', 95, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM PALMOMENTAL REFLEX');
add_assessment_code(v_id1, owner_id, owner_id, 'NE83', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE83', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE82', 94, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM GALBELLAR REFLEX');
add_assessment_code(v_id1, owner_id, owner_id, 'NE82', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE82', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE81', 93, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM ORAL RESPONSE SUCK REFLEX');
add_assessment_code(v_id1, owner_id, owner_id, 'NE81', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE81', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE80', 92, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM ORAL RESPONSE SNOUT REFLE');
add_assessment_code(v_id1, owner_id, owner_id, 'NE80', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE80', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE87', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM DEV REFLEX: TOTAL NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE86', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM NUCHOCEPHALIC REFLEX');

add_assessment_score(v_id1, owner_id, owner_id, 'NE85', 97, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM HYPERTONIA');
add_assessment_code(v_id1, owner_id, owner_id, 'NE85', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE85', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE84', 96, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM GRASP REFELX');
add_assessment_code(v_id1, owner_id, owner_id, 'NE84', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE84', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE19', 32, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM GLOSSOPHARYNGEAL GAG');
add_assessment_code(v_id1, owner_id, owner_id, 'NE19', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE19', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE38', 51, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INV MOVE RESTING TREMOR');
add_assessment_code(v_id1, owner_id, owner_id, 'NE38', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE38', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE39', 52, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM INV MOVE INTENTION TREMOR');
add_assessment_code(v_id1, owner_id, owner_id, 'NE39', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE39', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE36', 49, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLE TONE FLACCIDITY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE36', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE36', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE37', 50, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM WEAKNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE37', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE37', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE34', 47, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLE TONE SPASTICITY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE34', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE34', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE35', 48, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLE TONE RIGIDITY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE35', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE35', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE32', 45, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLE BULK ATROPHY');
add_assessment_code(v_id1, owner_id, owner_id, 'NE32', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE32', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE33', 46, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM MUSCLE BULK FASCICULATION');
add_assessment_code(v_id1, owner_id, owner_id, 'NE33', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE33', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE30', 43, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG SIGN EYES OPEN');
add_assessment_code(v_id1, owner_id, owner_id, 'NE30', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE30', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE31', 44, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG SIGN EYES CLOSED');
add_assessment_code(v_id1, owner_id, owner_id, 'NE31', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE31', 1, 'Present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE78', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM TANDEM GAIT LOSS BAL BROA');

add_assessment_score(v_id1, owner_id, owner_id, 'NE79', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SOFT SIGNS: TOTAL NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE72', 85, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST IMP EYE CLO');
add_assessment_code(v_id1, owner_id, owner_id, 'NE72', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE72', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE73', 86, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST INV MOV FAC');
add_assessment_code(v_id1, owner_id, owner_id, 'NE73', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE73', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE70', 83, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST GROSS ATAXI');
add_assessment_code(v_id1, owner_id, owner_id, 'NE70', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE70', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE71', 84, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST SWAY LORDOS');
add_assessment_code(v_id1, owner_id, owner_id, 'NE71', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE71', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE76', 89, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST INV MOV LOW');
add_assessment_code(v_id1, owner_id, owner_id, 'NE76', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE76', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM SUBJECT ID');

add_assessment_score(v_id1, owner_id, owner_id, 'NE65', 78, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER TAP TEST ASS MOVES');
add_assessment_code(v_id1, owner_id, owner_id, 'NE65', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE65', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE75', 88, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM RHOMBERG TEST INV MOV ATH');
add_assessment_code(v_id1, owner_id, owner_id, 'NE75', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE75', 1, 'Abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'NE100', 111, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM LATERALITY OF ABNORMAL MOVES');
add_assessment_code(v_id1, owner_id, owner_id, 'NE100', 0, 'N/A', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE100', 1, 'L>R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE100', 2, 'R>L', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE100', 3, 'L=R', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'NE64', 77, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NEURO EXAM FINGER TAP TEST INCOORDIN');
add_assessment_code(v_id1, owner_id, owner_id, 'NE64', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'NE64', 1, 'Abnormal', 'integer');

commit;
END;
/
