
--Add petinfo
create or replace procedure petinfo(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('petinfo', 'petinfo', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'PESLEEP', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Number Hours Slept');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME10', 215, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 10 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD17', 256, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 17 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PETQID', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Unique Pet Scan Identifier');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS01', 223, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 01 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND16', 204, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 16 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND17', 205, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 17 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND14', 202, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 14 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND15', 203, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 15 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT21', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug21 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT20', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug20 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND10', 198, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 10 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT22', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug22 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS14', 270, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 14 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS15', 271, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 15 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS16', 272, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 16 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS17', 273, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 17 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS10', 266, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 10 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS11', 267, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 11 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS12', 268, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 12 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS13', 269, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 13 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT03', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug03 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT02', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug02 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT01', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug01 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS07', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 07 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT07', 152, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug07 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT06', 151, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug06 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT05', 150, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug05 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT04', 149, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug04 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT09', 154, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug09 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT08', 153, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug08 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS08', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 08 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS09', 231, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 09 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD09', 248, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 09 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD08', 247, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 08 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD03', 242, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 03 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD02', 241, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 02 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD01', 240, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 01 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD07', 246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 07 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD06', 245, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 06 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD05', 244, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 05 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD04', 243, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 04 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE20', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug20 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE21', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug21 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE22', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug22 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS16', 238, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 16 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND01', 189, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 01 code');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Follow-up Period');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND03', 191, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 03 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND02', 190, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 02 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND05', 193, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 05 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND04', 192, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 04 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND07', 195, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 07 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND06', 194, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 06 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS14', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 14 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS09', 265, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 09 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS06', 262, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 06 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS07', 263, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 07 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PE8', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Hearing Score');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS05', 261, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 05 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS04', 260, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 04 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS03', 259, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 03 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS02', 258, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 02 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS01', 257, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 01 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG06', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug06 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS17', 239, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 17 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE22', 145, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug22 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE21', 144, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug21 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE20', 143, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug20 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS13', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 13 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS12', 234, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 12 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS11', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 11 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS10', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 10 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET INFO FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET INFO SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND12', 200, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 12 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PE6', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Helmet Used');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND13', 201, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 13 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG08', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug08 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME13', 218, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 13 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE07', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug07 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND11', 199, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 11 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS06', 228, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 06 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT21', 166, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug21 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT20', 165, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug20 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT22', 167, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug22 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE16', 139, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug16 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE17', 140, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug17 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE14', 137, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug14 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE15', 138, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug15 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE12', 135, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug12 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE13', 136, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug13 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE10', 133, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug10 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE11', 134, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug11 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME06', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug06 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE18', 141, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug18 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE19', 142, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug19 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS15', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 15 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE06', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug06 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG10', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug10 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE04', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug04 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE05', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug05 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE02', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug02 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE03', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug03 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS04', 226, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 04 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE01', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug01 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME20', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug20 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME21', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug21 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE08', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug08 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE09', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug09 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE09', 132, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug09 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULSB', 168, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Baseline Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME01', 206, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 01 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME06', 211, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 06 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME22', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug22 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME04', 209, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 04 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME05', 210, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 05 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE01', 124, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug01 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE03', 126, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug03 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE02', 125, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug02 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE05', 128, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug05 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE04', 127, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug04 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE07', 130, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug07 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE06', 129, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug06 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME02', 207, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 02 time');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Document Number');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS02', 224, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 02 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDATE08', 131, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug08 date');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS03', 225, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 03 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD05', 176, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 05 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD04', 175, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 04 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD07', 178, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 07 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD06', 177, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 06 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD01', 172, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 01 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD03', 174, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 03 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD02', 173, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 02 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND09', 197, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 09 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Procedure Code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD08', 179, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 08 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME07', 212, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 07 time');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET INFO SECOND CHECKER');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDS05', 227, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 05 Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME15', 220, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 15 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME14', 219, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 14 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME17', 222, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 17 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME16', 221, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 16 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME11', 216, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 11 time');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info Rater Number');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 10, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Reliability');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME12', 217, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 12 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME08', 213, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 08 time');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Assessment');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG11', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug11 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG12', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug12 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG13', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug13 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG14', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug14 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG15', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug15 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG16', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug16 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG17', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug17 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG18', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug18 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG19', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug19 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD12', 183, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 12 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD13', 184, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 13 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD10', 181, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 10 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD11', 182, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 11 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDDB', 170, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Baseline Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD17', 188, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 17 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD14', 185, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 14 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD15', 186, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 15 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD16', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 16 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME02', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug02 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME03', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug03 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME01', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug01 time');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Version Number');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME07', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug07 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME04', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug04 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME05', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug05 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME08', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug08 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME09', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug09 time');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 11, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT18', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug18 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT19', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug19 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT14', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug14 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT15', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug15 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT16', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug16 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT17', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug17 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT10', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug10 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT11', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug11 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT12', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug12 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT13', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug13 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG03', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug03 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG02', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug02 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG01', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug01 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG07', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug07 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PE9', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Subject Sedated');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG05', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug05 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG04', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug04 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PE4', 19, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Drug Status Code');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 1, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 2, 'Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 3, 'Neuroleptic Non-Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 4, 'Almost Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 5, 'Totally Psychoactive Drug Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE4', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PE5', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Medication Status');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG09', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug09 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PE7', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Handedness Score');

add_assessment_score(v_id1, owner_id, owner_id, 'PE2', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Time of Pet Procedure');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE19', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug19 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE18', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug18 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEORD09', 180, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond. 09 order');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME09', 214, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 09 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE11', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug11 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE10', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug10 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE13', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug13 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE12', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug12 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE15', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug15 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE14', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug14 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE17', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug17 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDOSE16', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug16 dose');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME15', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug15 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME14', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug14 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME17', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug17 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME16', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug16 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME11', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug11 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME10', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug10 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME13', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug13 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME12', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug12 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD12', 251, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 12 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME19', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug19 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PETIME18', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info drug18 time');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD13', 252, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 13 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT07', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug07 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT09', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug09 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT08', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug08 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 15, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Date of Pet Procedure');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT06', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug06 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT05', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug05 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT04', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug04 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT03', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug03 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT02', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug02 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEUNIT01', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug01 unit');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD14', 253, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 14 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PE21', 171, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Number of Conditions');

add_assessment_score(v_id1, owner_id, owner_id, 'PE20', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Number of Lines Completed');

add_assessment_score(v_id1, owner_id, owner_id, 'PECOND08', 196, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 08 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PETYME03', 208, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info cond 03 time');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Batch Number');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDSB', 169, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Baseline Systolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'STUDY', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET INFO STUDY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD10', 249, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 10 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD11', 250, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 11 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG21', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug21 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG20', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug20 code');

add_assessment_score(v_id1, owner_id, owner_id, 'PEPULS08', 264, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 08 Pulse');

add_assessment_score(v_id1, owner_id, owner_id, 'PEDRUG22', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug22 code');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Subject ID');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT10', 155, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug10 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT11', 156, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug11 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT12', 157, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug12 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT13', 158, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug13 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT14', 159, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug14 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT15', 160, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug15 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT16', 161, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug16 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT17', 162, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug17 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT18', 163, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug18 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEROUT19', 164, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info drug19 route');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD15', 254, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 15 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PEBLDD16', 255, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info cond 16 Diastolic BP');

add_assessment_score(v_id1, owner_id, owner_id, 'PE18', 33, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET info Menstrual Status Code');
add_assessment_code(v_id1, owner_id, owner_id, 'PE18', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE18', 1, 'Mensturating', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE18', 2, 'Postmenopausal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PE18', 3, 'Amenorrhea', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PE19', 34, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info First Day of Menstrual Cycle');

add_assessment_score(v_id1, owner_id, owner_id, 'PE16', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Minutes Since Cig Smoked');

add_assessment_score(v_id1, owner_id, owner_id, 'PE17', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Sex of Subject');

add_assessment_score(v_id1, owner_id, owner_id, 'PE14', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Brand Code Number');

add_assessment_score(v_id1, owner_id, owner_id, 'PE15', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Nicotine of Cig');

add_assessment_score(v_id1, owner_id, owner_id, 'PE12', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Last 3.5 Caffeine Total');

add_assessment_score(v_id1, owner_id, owner_id, 'PE13', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Cig Smoked in last 8 hrs');

add_assessment_score(v_id1, owner_id, owner_id, 'PE10', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Sedation Code');

add_assessment_score(v_id1, owner_id, owner_id, 'PE11', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PET Info Dose of Sedation Drug');

commit;
END;
/
