
--Add psych
create or replace procedure psych(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('psych', 'psych', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'P146', 1761, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P119', 116, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1532', 1369, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1830', 1667, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK34');
add_assessment_code(v_id1, owner_id, owner_id, 'P1830', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1830', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1830', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1830', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P590', 427, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DEPRESSED SYND. # CURRENT EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P1569', 1406, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P415', 1850, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P1533', 1370, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1837', 1674, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK41');
add_assessment_code(v_id1, owner_id, owner_id, 'P1837', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1837', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1837', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1837', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P591', 428, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ALCOHOL ABUSE # COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P1844', 1681, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK48');
add_assessment_code(v_id1, owner_id, owner_id, 'P1844', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1844', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1844', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1844', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P470', 1869, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P1853', 1690, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 5');
add_assessment_code(v_id1, owner_id, owner_id, 'P1853', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1853', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1853', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1853', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1530', 1367, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P898', 735, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1668', 1505, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 29');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1668', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1669', 1506, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 30');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1669', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1666', 1503, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 27');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1666', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1667', 1504, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 28');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1667', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1664', 1501, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 25');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1664', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1665', 1502, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 26');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1665', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1662', 1499, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 23');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1662', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1663', 1500, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 24');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1663', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1660', 1497, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 21');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1660', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1661', 1498, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 22');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1661', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P391', 1842, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P1835', 1672, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK39');
add_assessment_code(v_id1, owner_id, owner_id, 'P1835', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1835', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1835', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1835', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1834', 1671, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK38');
add_assessment_code(v_id1, owner_id, owner_id, 'P1834', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1834', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1834', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1834', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1408', 1245, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1409', 1246, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1019', 856, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1018', 855, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P518', 1885, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P519', 382, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P516', 381, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P1403', 1240, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1400', 1237, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1401', 1238, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1406', 1243, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P513', 378, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P510', 377, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P1012', 849, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1798', 1635, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK2');
add_assessment_code(v_id1, owner_id, owner_id, 'P1798', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1798', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1798', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1798', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1799', 1636, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK3');
add_assessment_code(v_id1, owner_id, owner_id, 'P1799', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1799', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1799', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1799', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1792', 1629, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 49');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1792', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1793', 1630, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 50');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1793', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1790', 1627, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 47');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1790', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1791', 1628, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 48');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1791', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1796', 1633, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEHAVIORS RECORDED?');

add_assessment_score(v_id1, owner_id, owner_id, 'P1797', 1634, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK1');
add_assessment_code(v_id1, owner_id, owner_id, 'P1797', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1797', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1797', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1797', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1794', 1631, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 51');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1794', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1795', 1632, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1491', 1328, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P963', 800, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1493', 1330, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1492', 1329, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1495', 1332, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1494', 1331, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1497', 1334, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1496', 1333, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1499', 1336, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1498', 1335, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1884', 1721, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 36');
add_assessment_code(v_id1, owner_id, owner_id, 'P1884', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1884', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1884', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1884', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1885', 1722, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 37');
add_assessment_code(v_id1, owner_id, owner_id, 'P1885', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1885', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1885', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1885', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1882', 1719, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 34');
add_assessment_code(v_id1, owner_id, owner_id, 'P1882', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1882', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1882', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1882', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P961', 798, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1880', 1717, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 32');
add_assessment_code(v_id1, owner_id, owner_id, 'P1880', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1880', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1880', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1880', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1881', 1718, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 33');
add_assessment_code(v_id1, owner_id, owner_id, 'P1881', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1881', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1881', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1881', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1068', 905, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1006', 843, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1703', 1540, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 12');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1703', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P960', 797, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1705', 1542, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 14');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1705', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1704', 1541, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 13');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1704', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1707', 1544, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 16');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1707', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1706', 1543, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 15');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1706', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1060', 897, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1061', 898, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1062', 899, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1063', 900, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1064', 901, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P503', 372, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P1066', 903, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1067', 904, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1240', 1077, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P342', 265, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P341', 264, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P340', 263, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P347', 268, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P346', 267, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P345', 266, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1247', 1084, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1248', 1085, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1249', 1086, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P349', 1828, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P348', 269, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1538', 1375, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P504', 373, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P581', 418, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PSYCHOTIC SYND. IN EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'P580', 417, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PSYCHOTIC SYN. DUR. COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P468', 349, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P582', 419, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PSYCHOTIC SYND. # CURRENT EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P585', 422, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH MANIC SYND. IN EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'P584', 421, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH MANIC SYND. DUR. COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P587', 424, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DEPRESSED SYND. # COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P586', 423, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH MANIC SYND. # CURRENT EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P462', 345, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P588', 425, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DEPRESSED SYN. DUR. COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P460', 343, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P461', 344, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P466', 347, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P467', 348, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P1088', 925, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1089', 926, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1580', 1417, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1855', 1692, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 7');
add_assessment_code(v_id1, owner_id, owner_id, 'P1855', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1855', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1855', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1855', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P44', 55, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS OTHER BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P1854', 1691, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 6');
add_assessment_code(v_id1, owner_id, owner_id, 'P1854', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1854', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1854', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1854', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P905', 742, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P904', 741, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P907', 744, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P906', 743, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P901', 738, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P900', 737, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P868', 705, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P869', 706, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P866', 703, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P867', 704, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P864', 701, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P865', 702, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P862', 699, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P863', 700, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P860', 697, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P861', 698, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P646', 483, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P647', 484, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P644', 481, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P645', 482, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P642', 479, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P643', 480, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P640', 477, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P641', 478, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P648', 485, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P649', 486, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P884', 721, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P885', 722, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P886', 723, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P887', 724, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P769', 606, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1339', 1176, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RELIABILITY MEASUREMENT NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P883', 720, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P765', 602, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P764', 601, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P767', 604, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P766', 603, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P761', 598, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1238', 1075, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P763', 600, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1333', 1170, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P199', 1778, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1168', 1005, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK49');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 10, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P230', 1789, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1330', 1167, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P242', 1793, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P243', 198, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P240', 197, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P168', 149, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P246', 201, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P247', 1794, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P244', 199, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P245', 200, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P163', 1766, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P162', 145, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P161', 144, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P249', 202, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P167', 148, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P166', 147, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P165', 146, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P164', 1767, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1359', 1196, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P318', 249, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P319', 1818, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P881', 718, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P236', 1791, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P547', 1894, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P703', 540, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P618', 455, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1353', 1190, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 11, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DATE (MMDDYY) THAT FORM WAS DONE');

add_assessment_score(v_id1, owner_id, owner_id, 'P1350', 1187, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P882', 719, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P700', 537, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1356', 1193, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1357', 1194, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1711', 1548, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 20');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1711', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P58', 69, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RECREATION BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P59', 70, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SATISFACTION WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P59', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P54', 65, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SEXUAL ACTIVITIES BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P55', 66, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SEX FREQUENCY WK PRIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'P56', 67, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SEX FREQUENCY BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P57', 68, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RECREATION WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P57', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P50', 61, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH CHANGES IN MAR. STATUS-DIVORCED');

add_assessment_score(v_id1, owner_id, owner_id, 'P51', 62, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH CHANGES IN MAR. STATUS-WIDOWED');

add_assessment_score(v_id1, owner_id, owner_id, 'P52', 63, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SEXUAL ORIENTATION');
add_assessment_code(v_id1, owner_id, owner_id, 'P52', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P52', 1, 'Heterosexual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P52', 2, 'Homosexual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P52', 3, 'Bisexual', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P53', 64, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SEXUAL ACTIVITIES WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 1, 'Not having sexual activities/Satisfied', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 2, 'Not having sexual activities/Unsatisfied', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 3, 'Having sexual activities/Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 4, 'Having sexual activities/Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 5, 'Having sexual activities/Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P53', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P368', 1835, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P155', 140, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P541', 1892, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P1566', 1403, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P343', 1826, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1331', 1168, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P448', 335, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P475', 1870, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P217', 1784, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P474', 353, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P355', 1830, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P477', 354, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P476', 1871, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P1637', 1474, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P808', 645, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1806', 1643, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK10');
add_assessment_code(v_id1, owner_id, owner_id, 'P1806', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1806', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1806', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1806', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P809', 646, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P378', 289, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P542', 1893, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P472', 351, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P1549', 1386, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P376', 287, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1023', 860, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P805', 642, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1807', 1644, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK11');
add_assessment_code(v_id1, owner_id, owner_id, 'P1807', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1807', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1807', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1807', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P806', 643, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P127', 1754, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P807', 644, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P479', 356, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P125', 120, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P801', 638, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P124', 119, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P802', 639, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P888', 725, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1804', 1641, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK8');
add_assessment_code(v_id1, owner_id, owner_id, 'P1804', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1804', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1804', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1804', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P803', 640, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P152', 1763, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P121', 1752, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P194', 1777, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1579', 1416, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P889', 726, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1805', 1642, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK9');
add_assessment_code(v_id1, owner_id, owner_id, 'P1805', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1805', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1805', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1805', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1398', 1235, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1659', 1496, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 20');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1659', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1658', 1495, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 19');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1658', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1268', 1105, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1653', 1490, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 14');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1653', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1652', 1489, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 13');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1652', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1651', 1488, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 12');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1651', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1650', 1487, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 11');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1650', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P195', 166, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1656', 1493, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 17');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1656', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1655', 1492, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 16');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1655', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1654', 1491, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 15');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1654', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P574', 411, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II NUMBER OF DX AND CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'P1821', 1658, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK25');
add_assessment_code(v_id1, owner_id, owner_id, 'P1821', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1821', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1821', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1821', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1802', 1639, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK6');
add_assessment_code(v_id1, owner_id, owner_id, 'P1802', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1802', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1802', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1802', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P85', 1740, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P575', 412, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS III CODE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P679', 516, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1700', 1537, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 9');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1700', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P128', 1755, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P576', 413, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS III CODE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1131', 968, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK12');

add_assessment_score(v_id1, owner_id, owner_id, 'P570', 1909, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE ENDED LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P571', 410, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II CODE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1803', 1640, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK7');
add_assessment_code(v_id1, owner_id, owner_id, 'P1803', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1803', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1803', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1803', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P572', 1910, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE BEGAN LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1354', 1191, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P573', 1911, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE ENDED LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P509', 376, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P508', 375, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P1008', 845, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1009', 846, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P501', 370, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P1007', 844, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1004', 841, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1005', 842, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1002', 839, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1003', 840, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P507', 374, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P1001', 838, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P548', 1895, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1482', 1319, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1483', 1320, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1480', 1317, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1481', 1318, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1486', 1323, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1487', 1324, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1484', 1321, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1485', 1322, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1488', 1325, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1489', 1326, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P143', 132, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1712', 1549, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 21');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1712', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1713', 1550, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 22');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1713', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1710', 1547, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 19');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1710', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P634', 471, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1716', 1553, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 25');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1716', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1717', 1554, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 26');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1717', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1714', 1551, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 23');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1714', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1715', 1552, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 24');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1715', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P145', 1760, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1718', 1555, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 27');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1718', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1719', 1556, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 28');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1719', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P144', 133, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1503', 1340, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1502', 1339, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1501', 1338, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1500', 1337, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P471', 350, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P1506', 1343, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P473', 352, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 67');

add_assessment_score(v_id1, owner_id, owner_id, 'P1504', 1341, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P804', 641, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P377', 288, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1509', 1346, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1508', 1345, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P372', 285, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P478', 355, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P370', 283, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P371', 284, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1138', 975, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1139', 976, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK20');

add_assessment_score(v_id1, owner_id, owner_id, 'P578', 415, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RELIABILITY &''||'' COMPLETENESS OF INFO');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 1, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P578', 5, 'Very Poor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P579', 416, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PSYCHOTIC SYND. # COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P1132', 969, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1133', 970, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1130', 967, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK11');

add_assessment_score(v_id1, owner_id, owner_id, 'P577', 414, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS III CODE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1136', 973, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1137', 974, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1134', 971, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1135', 972, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK16');

add_assessment_score(v_id1, owner_id, owner_id, 'P879', 716, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P971', 808, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P972', 809, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P970', 807, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1436', 1273, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1435', 1272, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P973', 810, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P974', 811, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P975', 812, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1431', 1268, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1014', 851, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P978', 815, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P979', 816, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P873', 710, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P872', 709, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P875', 712, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P514', 379, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P877', 714, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P876', 713, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P651', 488, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P650', 487, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P653', 490, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P515', 380, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P655', 492, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P976', 813, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P657', 494, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P656', 493, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P659', 496, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1011', 848, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P598', 435, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ABUSE # CURRENT EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P977', 814, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P385', 1840, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1454', 1291, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1407', 1244, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P718', 555, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P871', 708, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P895', 732, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P894', 731, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P893', 730, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1404', 1241, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P891', 728, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P870', 707, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P710', 547, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P711', 548, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P712', 549, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P713', 550, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P714', 551, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P715', 552, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P716', 553, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1346', 1183, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P488', 1875, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P489', 362, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P1827', 1664, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK31');
add_assessment_code(v_id1, owner_id, owner_id, 'P1827', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1827', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1827', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1827', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P480', 357, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P1820', 1657, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK24');
add_assessment_code(v_id1, owner_id, owner_id, 'P1820', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1820', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1820', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1820', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P482', 1873, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P483', 358, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P484', 359, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P485', 360, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P486', 361, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P874', 711, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1439', 1276, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P221', 184, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1438', 1275, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1528', 1365, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P624', 461, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P625', 462, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P626', 463, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P652', 489, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P620', 457, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P621', 458, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P622', 459, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P623', 460, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P388', 295, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P628', 465, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P629', 466, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1348', 1185, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P654', 491, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P394', 299, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P395', 300, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P396', 301, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P397', 1844, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P390', 297, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P258', 209, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P392', 1843, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P393', 298, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P255', 206, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P254', 1797, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P257', 208, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P256', 207, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P251', 204, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P250', 203, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P253', 1796, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P252', 205, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P658', 495, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1450', 1287, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1490', 1327, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P709', 546, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P61', 72, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SOCIAL ADJUSTMENT WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 1, 'No impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 2, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 3, 'Moderate impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 4, 'Marked impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 5, 'Severe impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P61', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1349', 1186, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P63', 74, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT HAD ECT?');

add_assessment_score(v_id1, owner_id, owner_id, 'P62', 73, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SOCIAL ADJUSTMENT BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P65', 76, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH HIGHEST NUMBER ECT''S RECEIVED');

add_assessment_score(v_id1, owner_id, owner_id, 'P64', 75, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ECT NUMBER OF COURSES');

add_assessment_score(v_id1, owner_id, owner_id, 'P67', 78, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TOTAL NUMBER OF ECT''S');

add_assessment_score(v_id1, owner_id, owner_id, 'P719', 556, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P69', 80, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NON-SOMATIC TREATMENT REASON');

add_assessment_score(v_id1, owner_id, owner_id, 'P68', 79, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NON-SOMATIC TREATMENT?');

add_assessment_score(v_id1, owner_id, owner_id, 'P1889', 1726, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 41');
add_assessment_code(v_id1, owner_id, owner_id, 'P1889', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1889', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1889', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1889', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P708', 545, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1224', 1061, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1886', 1723, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 38');
add_assessment_code(v_id1, owner_id, owner_id, 'P1886', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1886', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1886', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1886', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1225', 1062, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P529', 1888, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P1887', 1724, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 39');
add_assessment_code(v_id1, owner_id, owner_id, 'P1887', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1887', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1887', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1887', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1222', 1059, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P892', 729, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1220', 1057, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P890', 727, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1883', 1720, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 35');
add_assessment_code(v_id1, owner_id, owner_id, 'P1883', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1883', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1883', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1883', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1341', 1178, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1340', 1177, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P298', 235, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P226', 187, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1343', 1180, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1678', 1515, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 39');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1678', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1701', 1538, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 10');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1701', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1342', 1179, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P332', 1823, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1069', 906, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1345', 1182, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1344', 1181, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P908', 745, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P899', 736, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P717', 554, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1677', 1514, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 38');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1677', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1676', 1513, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 37');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1676', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1800', 1637, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK4');
add_assessment_code(v_id1, owner_id, owner_id, 'P1800', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1800', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1800', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1800', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P810', 647, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1709', 1546, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 18');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1709', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P599', 436, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH INDEX DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'P1708', 1545, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 17');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1708', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P951', 788, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1065', 902, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P1702', 1539, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 11');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1702', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P481', 1872, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 68');

add_assessment_score(v_id1, owner_id, owner_id, 'P952', 789, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1536', 1373, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1241', 1078, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1815', 1652, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK19');
add_assessment_code(v_id1, owner_id, owner_id, 'P1815', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1815', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1815', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1815', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1242', 1079, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P688', 525, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1243', 1080, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1244', 1081, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P487', 1874, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 69');

add_assessment_score(v_id1, owner_id, owner_id, 'P1245', 1082, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P702', 539, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1246', 1083, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1814', 1651, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK18');
add_assessment_code(v_id1, owner_id, owner_id, 'P1814', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1814', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1814', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1814', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1531', 1368, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P689', 526, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P337', 1824, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P701', 538, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P134', 1757, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1817', 1654, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK21');
add_assessment_code(v_id1, owner_id, owner_id, 'P1817', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1817', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1817', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1817', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P469', 1868, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 66');

add_assessment_score(v_id1, owner_id, owner_id, 'P77', 88, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P668', 505, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1437', 1274, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P136', 127, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P987', 824, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P137', 128, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P130', 123, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1539', 1376, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P131', 124, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1129', 966, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1816', 1653, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK20');
add_assessment_code(v_id1, owner_id, owner_id, 'P1816', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1816', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1816', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1816', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P70', 81, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT JUDGMENT OF TX-SOMATIC');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 1, 'Very Much', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 2, 'Somewhat', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 3, 'Not helpful', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 4, 'Worse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 5, 'Differed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P70', 6, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1087', 924, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P669', 506, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P133', 1756, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P583', 420, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH MANIC SYND. # COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P445', 1860, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P400', 303, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P1085', 922, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1082', 919, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P707', 544, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1083', 920, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1811', 1648, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK15');
add_assessment_code(v_id1, owner_id, owner_id, 'P1811', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1811', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1811', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1811', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1039', 876, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1038', 875, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1080', 917, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1033', 870, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1032', 869, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1031', 868, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1030', 867, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1037', 874, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1036', 873, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1035', 872, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1034', 871, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1121', 958, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1120', 957, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK1');

add_assessment_score(v_id1, owner_id, owner_id, 'P79', 1738, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1123', 960, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1810', 1647, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK14');
add_assessment_code(v_id1, owner_id, owner_id, 'P1810', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1810', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1810', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1810', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1122', 959, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1347', 1184, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P822', 659, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1125', 962, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1813', 1650, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK17');
add_assessment_code(v_id1, owner_id, owner_id, 'P1813', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1813', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1813', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1813', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1124', 961, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1644', 1481, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 5');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1644', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1645', 1482, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 6');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1645', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1646', 1483, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 7');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1646', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1647', 1484, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 8');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1647', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1640', 1477, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 1');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1640', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1127', 964, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK8');

add_assessment_score(v_id1, owner_id, owner_id, 'P705', 542, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1643', 1480, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 4');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1643', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1727', 1564, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 36');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1727', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1726', 1563, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 35');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1726', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1725', 1562, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 34');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1725', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P465', 346, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P1648', 1485, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 9');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1648', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1649', 1486, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 10');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1649', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1721', 1558, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 30');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1721', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1720', 1557, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 29');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1720', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1455', 1292, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P401', 304, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P1457', 1294, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1456', 1293, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1518', 1355, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1519', 1356, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1453', 1290, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1100', 937, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1514', 1351, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1515', 1352, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1516', 1353, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1517', 1354, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1510', 1347, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1458', 1295, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P811', 648, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1513', 1350, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P704', 541, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P569', 1908, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE BEGAN LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P568', 409, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II CODE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P567', 1907, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE ENDED LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P566', 1906, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II DATE BEGAN LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P565', 408, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II CODE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P564', 407, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS II NUMBER OF DX AND CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'P563', 1905, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P562', 1904, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P561', 406, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P560', 1903, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P156', 141, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P295', 1810, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1603', 1440, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P157', 1764, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1547', 1384, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P154', 139, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P896', 733, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1420', 1257, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1421', 1258, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1422', 1259, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P627', 464, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P967', 804, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P966', 803, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1426', 1263, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1427', 1264, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1428', 1265, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1429', 1266, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P969', 806, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P968', 805, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1587', 1424, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1586', 1423, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1585', 1422, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P153', 138, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P523', 1886, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P446', 1861, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P150', 137, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P522', 385, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P151', 1762, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P521', 384, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P1213', 1050, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1212', 1049, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1358', 1195, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1210', 1047, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1217', 1054, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1216', 1053, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1215', 1052, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1214', 1051, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1352', 1189, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P315', 246, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P316', 247, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1351', 1188, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P310', 243, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P706', 543, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P312', 245, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1355', 1192, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1833', 1670, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK37');
add_assessment_code(v_id1, owner_id, owner_id, 'P1833', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1833', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1833', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1833', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P499', 1878, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P498', 369, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P525', 386, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P1832', 1669, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK36');
add_assessment_code(v_id1, owner_id, owner_id, 'P1832', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1832', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1832', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1832', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P493', 1876, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P492', 365, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P491', 364, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P490', 363, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P497', 368, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P496', 367, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P495', 366, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P494', 1877, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 70');

add_assessment_score(v_id1, owner_id, owner_id, 'P790', 627, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P791', 628, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P792', 629, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P793', 630, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P794', 631, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P795', 632, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P796', 633, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P797', 634, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P798', 635, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P799', 636, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P660', 497, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P159', 142, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P296', 1811, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P910', 747, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1111', 948, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1836', 1673, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK40');
add_assessment_code(v_id1, owner_id, owner_id, 'P1836', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1836', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1836', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1836', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P911', 748, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1270', 1107, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P903', 740, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P916', 753, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P902', 739, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P917', 754, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P637', 474, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P636', 473, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P635', 472, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P142', 131, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P633', 470, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P632', 469, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P631', 468, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P630', 467, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P149', 136, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P148', 135, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P915', 752, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1839', 1676, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK43');
add_assessment_code(v_id1, owner_id, owner_id, 'P1839', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1839', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1839', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1839', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P639', 476, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P638', 475, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P228', 189, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P229', 1788, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1273', 1110, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P384', 293, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P383', 292, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P382', 291, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P381', 290, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1788', 1625, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 45');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1788', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P220', 183, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P909', 746, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P222', 185, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P223', 1786, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P224', 1787, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P225', 186, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P389', 296, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 53');

add_assessment_score(v_id1, owner_id, owner_id, 'P227', 188, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P981', 818, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P358', 275, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P398', 1845, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P1128', 965, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK9');

add_assessment_score(v_id1, owner_id, owner_id, 'P399', 302, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 54');

add_assessment_score(v_id1, owner_id, owner_id, 'P464', 1867, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P512', 1883, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P447', 334, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P76', 87, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P135', 126, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P74', 85, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RATER ESTIMATION OF MED COMPLIANCE');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 0, 'N/A', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 1, 'Excel', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 5, 'Non Comp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P74', 6, 'Mixed', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P75', 86, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NUMBER OF DRUG RECORD CHANGES');

add_assessment_score(v_id1, owner_id, owner_id, 'P72', 83, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT JUDGMENT OF TX-NON-SOMATIC');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 1, 'Very Much', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 2, 'Somewhat', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 3, 'Not helpful', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 4, 'Worse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 5, 'Differed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P72', 6, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P73', 84, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT JUDGMENT OF TX-OVERALL');

add_assessment_score(v_id1, owner_id, owner_id, 'P132', 125, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P71', 82, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT JUDGMENT OF TX-ECT');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 1, 'Very Much', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 2, 'Somewhat', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 3, 'Not helpful', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 4, 'Worse', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 5, 'Differed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P71', 6, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1564', 1401, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P138', 129, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P139', 1758, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P78', 89, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1784', 1621, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 41');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1784', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1838', 1675, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK42');
add_assessment_code(v_id1, owner_id, owner_id, 'P1838', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1838', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1838', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1838', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1108', 945, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1399', 1236, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1899', 1736, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 51');
add_assessment_code(v_id1, owner_id, owner_id, 'P1899', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1899', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1899', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1899', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1277', 1114, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P283', 1806, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1235', 1072, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1234', 1071, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1237', 1074, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P666', 503, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1236', 1073, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1894', 1731, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 46');
add_assessment_code(v_id1, owner_id, owner_id, 'P1894', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1894', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1894', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1894', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1338', 1175, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P362', 1833, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P768', 605, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1896', 1733, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 48');
add_assessment_code(v_id1, owner_id, owner_id, 'P1896', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1896', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1896', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1896', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1233', 1070, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1891', 1728, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 43');
add_assessment_code(v_id1, owner_id, owner_id, 'P1891', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1891', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1891', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1891', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1232', 1069, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1769', 1606, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 26');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1769', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1434', 1271, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1334', 1171, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1768', 1605, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 25');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1768', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1335', 1172, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P365', 280, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1892', 1729, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 44');
add_assessment_code(v_id1, owner_id, owner_id, 'P1892', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1892', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1892', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1892', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1336', 1173, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1337', 1174, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1239', 1076, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1776', 1613, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 33');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1776', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P760', 597, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1763', 1600, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 20');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1763', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P403', 1846, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P1332', 1169, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1762', 1599, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 19');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1762', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1770', 1607, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 27');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1770', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P762', 599, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1771', 1608, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 28');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1771', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P433', 1856, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P1572', 1409, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1772', 1609, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 29');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1772', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1773', 1610, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 30');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1773', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1250', 1087, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1573', 1410, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P528', 389, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P1778', 1615, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 35');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1778', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1779', 1616, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 36');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1779', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P897', 734, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P828', 665, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1570', 1407, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P299', 236, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1256', 1093, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P303', 238, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P352', 271, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1254', 1091, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 12, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P354', 273, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P829', 666, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1571', 1408, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1252', 1089, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1433', 1270, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1251', 1088, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P302', 1813, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P357', 274, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P413', 312, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P291', 230, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1397', 1234, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1576', 1413, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1394', 1231, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1395', 1232, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1749', 1586, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 6');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1749', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1748', 1585, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 5');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1748', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P60', 71, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SATISFACTION BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P1745', 1582, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 2');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1745', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1529', 1366, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1747', 1584, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 4');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1747', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1746', 1583, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 3');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1746', 7, 'Inpatient', 'integer');

commit;
END;
/


