--Add psych2
create or replace procedure psych2(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := get_assessment_id('psych');

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'P1741', 1578, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 50');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1741', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1740', 1577, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 49');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1740', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1743', 1580, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 52');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1743', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1393', 1230, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1390', 1227, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P431', 324, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P1577', 1414, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1391', 1228, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1095', 932, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1190', 1027, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1094', 931, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P66', 77, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ECT MOST RECENT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'P1097', 934, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P965', 802, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1631', 1468, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1630', 1467, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1633', 1470, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1096', 933, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P430', 323, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P1634', 1471, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1451', 1288, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1636', 1473, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1574', 1411, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1091', 928, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1732', 1569, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 41');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1732', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1733', 1570, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 42');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1733', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1734', 1571, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 43');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1734', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1735', 1572, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 44');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1735', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1736', 1573, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 45');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1736', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P988', 825, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1446', 1283, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1447', 1284, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1299', 1136, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1298', 1135, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1442', 1279, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1443', 1280, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1440', 1277, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1441', 1278, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1118', 955, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1119', 956, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1291', 1128, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P418', 315, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P1297', 1134, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1296', 1133, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1448', 1285, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1294', 1131, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1154', 991, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK35');

add_assessment_score(v_id1, owner_id, owner_id, 'P558', 405, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P559', 1902, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P456', 341, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P552', 403, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P553', 1898, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P550', 1896, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P551', 1897, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P778', 615, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P455', 340, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P554', 1899, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P555', 404, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1594', 1431, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1595', 1432, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1596', 1433, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P454', 339, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P1590', 1427, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1591', 1428, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1592', 1429, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1593', 1430, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1099', 936, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1598', 1435, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1599', 1436, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1126', 963, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1098', 935, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P619', 456, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1025', 862, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P285', 226, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1027', 864, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1020', 857, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1021', 858, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1189', 1026, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1188', 1025, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1187', 1024, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1186', 1023, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1432', 1269, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1184', 1021, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1183', 1020, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1182', 1019, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1181', 1018, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1180', 1017, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1367', 1204, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1366', 1203, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1365', 1202, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1364', 1201, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1363', 1200, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1362', 1199, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1361', 1198, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1360', 1197, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P457', 1864, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P428', 1855, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P738', 575, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1368', 1205, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P282', 225, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1164', 1001, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1167', 1004, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1166', 1003, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1161', 998, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1209', 1046, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1163', 1000, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1162', 999, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1204', 1041, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1205', 1042, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1206', 1043, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1207', 1044, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1169', 1006, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1201', 1038, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1202', 1039, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1203', 1040, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1614', 1451, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P434', 1857, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P820', 657, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P783', 620, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P782', 619, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P781', 618, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P780', 617, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P787', 624, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P786', 623, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P785', 622, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P784', 621, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1402', 1239, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P788', 625, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1581', 1418, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P439', 1858, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P427', 1854, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P438', 329, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P821', 658, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P602', 439, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P603', 440, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P600', 437, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P601', 438, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P606', 443, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P607', 444, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P604', 441, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P605', 442, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P534', 393, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P608', 445, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P609', 446, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P535', 1890, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P1550', 1387, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P239', 196, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P238', 195, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P536', 1891, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P1551', 1388, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P233', 192, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P232', 191, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P231', 190, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P537', 394, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P237', 194, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1552', 1389, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P235', 1790, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P234', 193, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P927', 764, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P140', 1759, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1553', 1390, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P926', 763, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1554', 1391, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P158', 1765, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P925', 762, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1555', 1392, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P453', 338, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P432', 325, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG R0UTE LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P1556', 1393, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P435', 326, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 60');

add_assessment_score(v_id1, owner_id, owner_id, 'P1557', 1394, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P169', 1768, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1461', 1298, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P241', 1792, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P437', 328, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P436', 327, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P1568', 1405, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P126', 121, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P89', 96, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P88', 95, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P123', 118, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P122', 1753, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P824', 661, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P120', 117, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P83', 92, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P82', 91, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P81', 90, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P80', 1739, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P87', 94, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P86', 1741, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P129', 122, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P84', 93, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P379', 1838, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1808', 1645, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK12');
add_assessment_code(v_id1, owner_id, owner_id, 'P1808', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1808', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1808', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1808', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P248', 1795, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P451', 1862, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P160', 143, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P825', 662, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1857', 1694, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 9');
add_assessment_code(v_id1, owner_id, owner_id, 'P1857', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1857', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1857', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1857', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1584', 1421, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P450', 337, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P387', 294, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P500', 1879, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 71');

add_assessment_score(v_id1, owner_id, owner_id, 'P10', 21, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH HOSPITAL RECORDS');

add_assessment_score(v_id1, owner_id, owner_id, 'P11', 22, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RESEARCH NOTES');

add_assessment_score(v_id1, owner_id, owner_id, 'P12', 23, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RECORDS FROM OTHER INSTITUTIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'P13', 24, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER SOURCE OF INFORMATION');

add_assessment_score(v_id1, owner_id, owner_id, 'P14', 25, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT WORK CODE 1');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 1, 'No impairment/High level', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 2, 'No impairment/Satisfactory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 4, 'Moderate impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 5, 'Severe impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 6, 'Did not work/Psychopathology', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P14', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P15', 26, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT WORK CODE 2');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 1, 'No impairment/High level', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 2, 'No impairment/Satisfactory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 4, 'Moderate impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 5, 'Severe impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 6, 'Did not work/Psychopathology', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P15', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P16', 27, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT WORK CODE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P17', 28, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT EMPLOYED >= 1 WEEK');

add_assessment_score(v_id1, owner_id, owner_id, 'P18', 29, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBJECT NOT EMPLOYED 1 WK REASON');

add_assessment_score(v_id1, owner_id, owner_id, 'P19', 30, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT HOURS WEEK PRIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'P147', 134, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P374', 1837, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1405', 1242, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1158', 995, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1864', 1701, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 16');
add_assessment_code(v_id1, owner_id, owner_id, 'P1864', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1864', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1864', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1864', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1865', 1702, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 17');
add_assessment_code(v_id1, owner_id, owner_id, 'P1865', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1865', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1865', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1865', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P772', 609, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1866', 1703, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 18');
add_assessment_code(v_id1, owner_id, owner_id, 'P1866', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1866', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1866', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1866', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P502', 371, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P773', 610, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P375', 286, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P770', 607, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1159', 996, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1320', 1157, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1511', 1348, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P776', 613, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1326', 1163, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P314', 1817, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 13, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P774', 611, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P913', 750, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P775', 612, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P407', 308, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'P511', 1882, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 73');

add_assessment_score(v_id1, owner_id, owner_id, 'P878', 715, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P671', 508, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P520', 383, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P1328', 1165, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P373', 1836, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1758', 1595, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 15');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1758', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1848', 1685, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK52');
add_assessment_code(v_id1, owner_id, owner_id, 'P1848', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1848', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1848', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1848', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1759', 1596, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 16');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1759', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P823', 660, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1561', 1398, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1752', 1589, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 9');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1752', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P211', 1782, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1560', 1397, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1842', 1679, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK46');
add_assessment_code(v_id1, owner_id, owner_id, 'P1842', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1842', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1842', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1842', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1750', 1587, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 7');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1750', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1751', 1588, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 8');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1751', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P317', 248, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P506', 1881, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P1430', 1267, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P367', 1834, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P210', 177, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1380', 1217, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1900', 1737, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1843', 1680, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK47');
add_assessment_code(v_id1, owner_id, owner_id, 'P1843', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1843', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1843', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1843', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1697', 1534, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 6');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1697', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1696', 1533, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 5');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1696', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1695', 1532, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 4');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1695', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1694', 1531, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 3');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1694', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1693', 1530, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 2');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1693', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1692', 1529, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 1');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1692', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1691', 1528, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 52');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1691', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1690', 1527, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 51');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1690', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1756', 1593, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 13');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1756', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1757', 1594, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 14');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1757', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1754', 1591, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 11');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1754', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1755', 1592, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 12');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1755', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1562', 1399, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1753', 1590, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 10');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1753', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1699', 1536, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 8');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1699', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1698', 1535, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 7');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1698', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1582', 1419, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P311', 244, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P321', 250, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P914', 751, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P320', 1819, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P212', 1783, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P323', 252, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1565', 1402, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P289', 1808, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1841', 1678, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK45');
add_assessment_code(v_id1, owner_id, owner_id, 'P1841', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1841', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1841', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1841', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1622', 1459, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P286', 227, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1620', 1457, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1621', 1458, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1626', 1463, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1627', 1464, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1624', 1461, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P287', 228, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1628', 1465, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1629', 1466, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P284', 1807, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P545', 400, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I NUMBER OF DX AND CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'P544', 399, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH LIFETIME DIAGNOSES CRITERIA');
add_assessment_code(v_id1, owner_id, owner_id, 'P544', 0, 'DSM-III', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P544', 1, 'DSM-III-R', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P544', 2, 'DSM-IV', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1471', 1308, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P546', 401, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P938', 775, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1476', 1313, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P543', 398, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P429', 322, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P426', 321, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P329', 256, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1479', 1316, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P425', 320, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P549', 402, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I CODE LINE 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P423', 318, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P420', 317, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P933', 770, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1730', 1567, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 39');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1730', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P313', 1816, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P280', 223, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P281', 224, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P449', 336, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P1589', 1426, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P214', 179, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P992', 829, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1875', 1712, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 27');
add_assessment_code(v_id1, owner_id, owner_id, 'P1875', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1875', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1875', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1875', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1874', 1711, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 26');
add_assessment_code(v_id1, owner_id, owner_id, 'P1874', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1874', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1874', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1874', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1873', 1710, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 25');
add_assessment_code(v_id1, owner_id, owner_id, 'P1873', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1873', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1873', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1873', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1872', 1709, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 24');
add_assessment_code(v_id1, owner_id, owner_id, 'P1872', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1872', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1872', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1872', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1567', 1404, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P993', 830, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1847', 1684, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK51');
add_assessment_code(v_id1, owner_id, owner_id, 'P1847', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1847', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1847', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1847', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P990', 827, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1879', 1716, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 31');
add_assessment_code(v_id1, owner_id, owner_id, 'P1879', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1879', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1879', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1879', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1731', 1568, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 40');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1731', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P949', 786, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P948', 785, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1053', 890, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1052', 889, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1055', 892, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1054', 891, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1057', 894, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1056', 893, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P941', 778, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1191', 1028, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P943', 780, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P942', 779, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P945', 782, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P944', 781, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P947', 784, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P946', 783, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P721', 558, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P720', 557, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P723', 560, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P722', 559, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P725', 562, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P724', 561, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P727', 564, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P726', 563, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P682', 519, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P683', 520, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P680', 517, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P681', 518, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P686', 523, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P687', 524, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P684', 521, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P685', 522, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1176', 1013, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1177', 1014, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1174', 1011, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P339', 262, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1172', 1009, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1173', 1010, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1170', 1007, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1171', 1008, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1271', 1108, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P333', 258, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P330', 257, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1272', 1109, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P336', 261, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1260', 1097, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1178', 1015, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1276', 1113, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P817', 654, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1261', 1098, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1845', 1682, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK49');
add_assessment_code(v_id1, owner_id, owner_id, 'P1845', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1845', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1845', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1845', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1623', 1460, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P440', 1859, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P350', 1829, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P441', 330, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 61');

add_assessment_score(v_id1, owner_id, owner_id, 'P835', 672, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P834', 671, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P837', 674, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P836', 673, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P831', 668, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1281', 1118, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P833', 670, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1283', 1120, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P444', 333, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P443', 332, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P839', 676, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1289', 1126, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P816', 653, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1625', 1462, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P754', 591, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P755', 592, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P204', 173, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P757', 594, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P750', 587, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P751', 588, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P752', 589, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P201', 170, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P615', 452, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P614', 451, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P617', 454, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P616', 453, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P758', 595, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P759', 596, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P613', 450, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P612', 449, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1851', 1688, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 3');
add_assessment_code(v_id1, owner_id, owner_id, 'P1851', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1851', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1851', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1851', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P271', 1802, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1371', 1208, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1588', 1425, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1473', 1310, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1472', 1309, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1578', 1415, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1372', 1209, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1470', 1307, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P421', 1852, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P813', 650, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1477', 1314, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P540', 397, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P112', 111, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P113', 112, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P110', 1749, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P111', 110, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P116', 1751, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P117', 114, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P114', 113, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1546', 1383, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P90', 97, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P91', 1742, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P118', 115, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P93', 98, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P94', 99, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P95', 100, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P96', 101, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P97', 1744, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P934', 771, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1544', 1381, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P812', 649, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P935', 772, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1543', 1380, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P424', 319, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 59');

add_assessment_score(v_id1, owner_id, owner_id, 'P1219', 1056, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1542', 1379, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1000', 837, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P277', 1804, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P937', 774, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P351', 270, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1541', 1378, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P179', 156, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P930', 767, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1540', 1377, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P218', 1785, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P931', 768, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1859', 1696, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 11');
add_assessment_code(v_id1, owner_id, owner_id, 'P1859', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1859', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1859', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1859', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P274', 219, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P932', 769, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P459', 342, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P1575', 1412, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1218', 1055, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P344', 1827, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1478', 1315, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P442', 331, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 62');

add_assessment_score(v_id1, owner_id, owner_id, 'P1858', 1695, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 10');
add_assessment_code(v_id1, owner_id, owner_id, 'P1858', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1858', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1858', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1858', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P25', 36, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH HOUSEHOLD IMPAIRMENT WK PRIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'P24', 35, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NO HOUSEHOLD DUTIES REASON');

add_assessment_score(v_id1, owner_id, owner_id, 'P27', 38, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH STUDENT WORK IN PAST 5 YEARS');

add_assessment_score(v_id1, owner_id, owner_id, 'P26', 37, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH HOUSEHOLD IMPAIRMENT BEST 6 MOS.');

add_assessment_score(v_id1, owner_id, owner_id, 'P21', 32, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT IMPAIRMENT WK PRIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'P20', 31, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT HOURS BEST 6 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'P23', 34, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH HOUSEHOLD DUTIES PERFORMED >= 1 WK');

add_assessment_score(v_id1, owner_id, owner_id, 'P22', 33, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH EMPLOYMENT IMPAIRMENT BEST 6 MOS.');

add_assessment_score(v_id1, owner_id, owner_id, 'P1856', 1693, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 8');
add_assessment_code(v_id1, owner_id, owner_id, 'P1856', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1856', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1856', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1856', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P29', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SCHOOL WORK IMPAIRMENT WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 1, 'No impairment/High level', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 2, 'No impairment/Satisfactory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 4, 'Moderate impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 5, 'Severe impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 6, 'Droped out/Psychopathology', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P29', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P28', 39, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH REASON STUDENT DID NOT WORK');

add_assessment_score(v_id1, owner_id, owner_id, 'P1109', 946, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P386', 1841, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P176', 1771, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P517', 1884, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 74');

add_assessment_score(v_id1, owner_id, owner_id, 'P278', 1805, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P409', 1848, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 7, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P1140', 977, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1601', 1438, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1545', 1382, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1147', 984, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1877', 1714, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 29');
add_assessment_code(v_id1, owner_id, owner_id, 'P1877', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1877', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1877', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1877', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1312', 1149, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1378', 1215, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1876', 1713, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 28');
add_assessment_code(v_id1, owner_id, owner_id, 'P1876', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1876', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1876', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1876', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'P422', 1853, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P1146', 983, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK27');

add_assessment_score(v_id1, owner_id, owner_id, 'P747', 584, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1379', 1216, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1871', 1708, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 23');
add_assessment_code(v_id1, owner_id, owner_id, 'P1871', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1871', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1871', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1871', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P746', 583, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1870', 1707, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 22');
add_assessment_code(v_id1, owner_id, owner_id, 'P1870', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1870', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1870', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1870', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P458', 1865, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 64');

add_assessment_score(v_id1, owner_id, owner_id, 'P1314', 1151, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P777', 614, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P744', 581, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P215', 180, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P411', 310, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'P742', 579, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P741', 578, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P216', 181, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P192', 165, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1829', 1666, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK33');
add_assessment_code(v_id1, owner_id, owner_id, 'P1829', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1829', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1829', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1829', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P193', 1776, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1878', 1715, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 30');
add_assessment_code(v_id1, owner_id, owner_id, 'P1878', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1878', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1878', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1878', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1311', 1148, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P190', 163, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1198', 1035, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P191', 164, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1199', 1036, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P196', 167, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P197', 168, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P290', 1809, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1318', 1155, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1744', 1581, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 1');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1744', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P206', 1781, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P417', 314, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P1319', 1156, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1680', 1517, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 41');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1680', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1681', 1518, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 42');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1681', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1682', 1519, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 43');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1682', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1683', 1520, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 44');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1683', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1684', 1521, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 45');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1684', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1685', 1522, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 46');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1685', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1686', 1523, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 47');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1686', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1687', 1524, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 48');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1687', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1688', 1525, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 49');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1688', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1689', 1526, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 50');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1689', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1761', 1598, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 18');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1761', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1760', 1597, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 17');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1760', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1767', 1604, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 24');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1767', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1766', 1603, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 23');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1766', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1765', 1602, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 22');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1765', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1764', 1601, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 21');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1764', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1059', 896, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P207', 174, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P940', 777, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P416', 1851, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P1742', 1579, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 51');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1742', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1192', 1029, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1850', 1687, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 2');
add_assessment_code(v_id1, owner_id, owner_id, 'P1850', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1850', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1850', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1850', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1193', 1030, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P984', 821, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1194', 1031, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1195', 1032, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P353', 272, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P982', 819, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1196', 1033, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1619', 1456, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1618', 1455, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1617', 1454, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1616', 1453, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1615', 1452, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1197', 1034, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1613', 1450, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1612', 1449, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1611', 1448, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1610', 1447, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1226', 1063, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P531', 390, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P532', 391, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P533', 392, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 77');

add_assessment_score(v_id1, owner_id, owner_id, 'P1468', 1305, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1469', 1306, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P929', 766, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P928', 765, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P538', 395, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P539', 396, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 78');

add_assessment_score(v_id1, owner_id, owner_id, 'P1466', 1303, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P924', 761, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P923', 760, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P922', 759, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P921', 758, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P920', 757, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P361', 1832, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1148', 985, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1373', 1210, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P414', 313, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P958', 795, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1374', 1211, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1852', 1689, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 4');
add_assessment_code(v_id1, owner_id, owner_id, 'P1852', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1852', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1852', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1852', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1227', 1064, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1375', 1212, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1860', 1697, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 12');
add_assessment_code(v_id1, owner_id, owner_id, 'P1860', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1860', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1860', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1860', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1861', 1698, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 13');
add_assessment_code(v_id1, owner_id, owner_id, 'P1861', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1861', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1861', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1861', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1862', 1699, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 14');
add_assessment_code(v_id1, owner_id, owner_id, 'P1862', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1862', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1862', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1862', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1863', 1700, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 15');
add_assessment_code(v_id1, owner_id, owner_id, 'P1863', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1863', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1863', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1863', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P986', 823, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1376', 1213, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P779', 616, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1867', 1704, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 19');
add_assessment_code(v_id1, owner_id, owner_id, 'P1867', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1867', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1867', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1867', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1868', 1705, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 20');
add_assessment_code(v_id1, owner_id, owner_id, 'P1868', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1868', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1868', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1868', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1869', 1706, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 21');
add_assessment_code(v_id1, owner_id, owner_id, 'P1869', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1869', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1869', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1869', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1377', 1214, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1042', 879, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1043', 880, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1040', 877, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1041', 878, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1046', 883, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1047', 884, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1044', 881, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1045', 882, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1048', 885, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1049', 886, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P690', 527, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P325', 1820, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P324', 253, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P327', 254, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P326', 1821, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1389', 1226, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1388', 1225, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P288', 229, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P322', 251, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1385', 1222, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1384', 1221, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1387', 1224, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1386', 1223, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1381', 1218, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P328', 255, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1383', 1220, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1382', 1219, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1143', 980, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK24');

add_assessment_score(v_id1, owner_id, owner_id, 'P1142', 979, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1141', 978, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1269', 1106, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P996', 833, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P997', 834, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1145', 982, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1144', 981, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1262', 1099, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1263', 1100, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1149', 986, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK30');

add_assessment_score(v_id1, owner_id, owner_id, 'P999', 836, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1266', 1103, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1267', 1104, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1264', 1101, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1265', 1102, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P980', 817, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1279', 1116, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1278', 1115, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P200', 1779, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P338', 1825, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P419', 316, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 58');

add_assessment_score(v_id1, owner_id, owner_id, 'P840', 677, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P841', 678, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P842', 679, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P843', 680, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P844', 681, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P845', 682, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P846', 683, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P847', 684, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P848', 685, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P849', 686, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1015', 852, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1819', 1656, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK23');
add_assessment_code(v_id1, owner_id, owner_id, 'P1819', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1819', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1819', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1819', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1818', 1655, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK22');
add_assessment_code(v_id1, owner_id, owner_id, 'P1818', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1818', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1818', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1818', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P983', 820, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1548', 1385, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1846', 1683, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK50');
add_assessment_code(v_id1, owner_id, owner_id, 'P1846', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1846', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1846', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1846', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P205', 1780, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P954', 791, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1316', 1153, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1317', 1154, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P213', 178, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1315', 1152, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P743', 580, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1313', 1150, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1310', 1147, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P740', 577, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P219', 182, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P661', 498, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P662', 499, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P663', 500, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P664', 501, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P665', 502, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P749', 586, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P667', 504, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1738', 1575, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 47');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1738', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P331', 1822, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1739', 1576, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 48');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1739', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1275', 1112, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P380', 1839, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1274', 1111, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P695', 532, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P694', 531, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P697', 534, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P696', 533, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P691', 528, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P334', 259, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1017', 854, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P692', 529, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1635', 1472, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P335', 260, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P699', 536, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P698', 535, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P3', 14, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH RELATIONSHIP INFORMANT TO PROBAND');

add_assessment_score(v_id1, owner_id, owner_id, 'P6', 17, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PHONE INTERVIEW WITH SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'P7', 18, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH LETTER FROM SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'P4', 15, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH CURRENT PSYCHIATRIC TX STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 1, 'Inpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 2, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 3, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 4, 'Nonpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P4', 5, 'Outpatient/Day Tx', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P5', 16, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FACE TO FACE INTERVIEW W/ SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'P8', 19, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FACE TO FACE WITH RELATIVE/FRIEND');

add_assessment_score(v_id1, owner_id, owner_id, 'P9', 20, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH PHONE INTERVIEW WITH RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'P1639', 1476, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1221', 1058, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1016', 853, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P1722', 1559, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 31');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1722', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1464', 1301, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1638', 1475, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P818', 655, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P264', 213, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P265', 1800, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P266', 1801, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P267', 214, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P109', 1748, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P108', 109, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P262', 211, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P263', 212, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P105', 106, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P953', 790, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P107', 108, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P106', 107, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P101', 104, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P100', 103, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P103', 1746, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P102', 105, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1465', 1302, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1737', 1574, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 46');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1737', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1110', 947, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P800', 637, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P412', 311, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 57');

add_assessment_score(v_id1, owner_id, owner_id, 'P1112', 949, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P526', 387, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P1010', 847, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1445', 1282, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P463', 1866, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 65');

add_assessment_score(v_id1, owner_id, owner_id, 'P1114', 951, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1113', 950, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1115', 952, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1284', 1121, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1116', 953, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P1285', 1122, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1117', 954, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1286', 1123, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1013', 850, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1467', 1304, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1293', 1130, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P38', 49, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS STEPDAD BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P38', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P39', 50, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS SPOUSE WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P39', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1058', 895, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1292', 1129, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P32', 43, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS MOTHER BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P32', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P33', 44, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS FATHER WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P33', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P30', 41, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SCHOOL WORK IMPAIRMENT BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P31', 42, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS MOTHER WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P31', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P36', 47, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS STEPMOM BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P36', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P37', 48, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS STEPDAD WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P37', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P34', 45, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS FATHER BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P34', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P830', 667, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1290', 1127, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P1282', 1119, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P826', 663, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P832', 669, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1460', 1297, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P827', 664, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'fuper', 1912, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'P1295', 1132, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1824', 1661, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK28');
add_assessment_code(v_id1, owner_id, owner_id, 'P1824', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1824', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1824', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1824', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P260', 1799, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1449', 1286, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P261', 210, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1583', 1420, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1288', 1125, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P939', 776, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1801', 1638, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK5');
add_assessment_code(v_id1, owner_id, owner_id, 'P1801', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1801', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1801', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1801', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P838', 675, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P104', 1747, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1211', 1048, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 6, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TYPE OF SUBJECT');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1888', 1725, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 40');
add_assessment_code(v_id1, owner_id, owner_id, 'P1888', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1888', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1888', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1888', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P745', 582, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P268', 215, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1462', 1299, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P269', 216, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1175', 1012, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1507', 1344, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P991', 828, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1228', 1065, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1812', 1649, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK16');
add_assessment_code(v_id1, owner_id, owner_id, 'P1812', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1812', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1812', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1812', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1463', 1300, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P556', 1900, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE BEGAN LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P557', 1901, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AXIS I DATE ENDED LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1301', 1138, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P356', 1831, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1828', 1665, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK32');
add_assessment_code(v_id1, owner_id, owner_id, 'P1828', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1828', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1828', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1828', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P505', 1880, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 72');

add_assessment_score(v_id1, owner_id, owner_id, 'P1229', 1066, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P729', 566, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1300', 1137, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1505', 1342, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1597', 1434, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1729', 1566, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 38');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1729', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1840', 1677, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK44');
add_assessment_code(v_id1, owner_id, owner_id, 'P1840', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1840', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1840', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1840', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P589', 426, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DEPRESSED SYND. IN EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P1305', 1142, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P728', 565, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1304', 1141, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P1307', 1144, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1825', 1662, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK29');
add_assessment_code(v_id1, owner_id, owner_id, 'P1825', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1825', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1825', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1825', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P962', 799, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1306', 1143, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1444', 1281, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P202', 171, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1257', 1094, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P994', 831, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P203', 172, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P936', 773, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P1679', 1516, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 40');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1679', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1303', 1140, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1675', 1512, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 36');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1675', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1674', 1511, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 35');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1674', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1302', 1139, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P753', 590, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1671', 1508, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 32');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1671', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1670', 1507, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 31');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1670', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1673', 1510, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 34');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1673', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1672', 1509, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 33');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1672', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P995', 832, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1024', 861, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P404', 1847, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P611', 448, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1026', 863, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P610', 447, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-MONTH OF WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1608', 1445, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1609', 1446, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1849', 1686, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 1');
add_assessment_code(v_id1, owner_id, owner_id, 'P1849', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1849', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1849', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1849', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P208', 175, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1255', 1092, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1600', 1437, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1423', 1260, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1602', 1439, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 15');

add_assessment_score(v_id1, owner_id, owner_id, 'P209', 176, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1604', 1441, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1605', 1442, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P1606', 1443, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1607', 1444, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 20');

add_assessment_score(v_id1, owner_id, owner_id, 'P1419', 1256, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1418', 1255, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P918', 755, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P919', 756, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P527', 388, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P1022', 859, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P405', 306, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P524', 1887, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 75');

add_assessment_score(v_id1, owner_id, owner_id, 'P1411', 1248, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1410', 1247, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1413', 1250, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1412', 1249, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1415', 1252, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1414', 1251, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1417', 1254, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1416', 1253, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1789', 1626, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 46');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1789', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P956', 793, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P735', 572, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 32');

add_assessment_score(v_id1, owner_id, owner_id, 'P957', 794, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1781', 1618, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 38');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1781', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1780', 1617, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 37');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1780', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1783', 1620, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 40');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1783', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1782', 1619, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 39');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1782', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1785', 1622, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 42');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1785', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1185', 1022, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1787', 1624, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 44');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1787', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1786', 1623, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 43');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1786', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P955', 792, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P406', 307, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'P1898', 1735, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 50');
add_assessment_code(v_id1, owner_id, owner_id, 'P1898', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1898', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1898', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1898', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1895', 1732, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 47');
add_assessment_code(v_id1, owner_id, owner_id, 'P1895', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1895', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1895', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1895', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1028', 865, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P1897', 1734, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 49');
add_assessment_code(v_id1, owner_id, owner_id, 'P1897', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1897', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1897', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1897', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1826', 1663, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK30');
add_assessment_code(v_id1, owner_id, owner_id, 'P1826', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1826', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1826', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1826', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1086', 923, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1890', 1727, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 42');
add_assessment_code(v_id1, owner_id, owner_id, 'P1890', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1890', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1890', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1890', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1893', 1730, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:OBS-COMP BEH WEEK 45');
add_assessment_code(v_id1, owner_id, owner_id, 'P1893', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1893', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1893', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1893', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1029', 866, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1774', 1611, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 31');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1774', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1775', 1612, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 32');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1775', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1253', 1090, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P1777', 1614, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:TX STATUS WEEK 34');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1777', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P998', 835, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P950', 787, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1079', 916, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1078', 915, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1077', 914, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 10');

add_assessment_score(v_id1, owner_id, owner_id, 'P1076', 913, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 9');

add_assessment_score(v_id1, owner_id, owner_id, 'P1075', 912, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1074', 911, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P1073', 910, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 6');

add_assessment_score(v_id1, owner_id, owner_id, 'P1072', 909, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P1071', 908, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1070', 907, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 3');

add_assessment_score(v_id1, owner_id, owner_id, 'P1525', 1362, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1524', 1361, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1527', 1364, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P1526', 1363, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P1521', 1358, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1520', 1357, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1523', 1360, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P1522', 1359, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1396', 1233, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P359', 276, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P293', 232, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P292', 231, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1392', 1229, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 13');

add_assessment_score(v_id1, owner_id, owner_id, 'P294', 233, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P297', 234, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1258', 1095, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P596', 433, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ABUSE DUR. COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P597', 434, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ABUSE IN EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'P594', 431, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ALCOHOL ABUSE # CURRENT EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P595', 432, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ABUSE # COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P989', 826, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1090', 927, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1093', 930, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P1092', 929, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P985', 822, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P1155', 992, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1156', 993, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1157', 994, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1150', 987, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK31');

add_assessment_score(v_id1, owner_id, owner_id, 'P1151', 988, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK32');

add_assessment_score(v_id1, owner_id, owner_id, 'P1152', 989, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1153', 990, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1309', 1146, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P964', 801, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ALOGIA WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P730', 567, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P1084', 921, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P815', 652, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P731', 568, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P853', 690, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P852', 689, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P851', 688, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P850', 687, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P857', 694, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P856', 693, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P855', 692, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P854', 691, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1558', 1395, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1559', 1396, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P859', 696, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P858', 695, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1308', 1145, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1809', 1646, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK13');
add_assessment_code(v_id1, owner_id, owner_id, 'P1809', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1809', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1809', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1809', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P185', 160, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P184', 159, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P187', 1774, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P186', 161, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P181', 1772, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P180', 157, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P183', 158, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P182', 1773, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P189', 162, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P188', 1775, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P1424', 1261, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P1323', 1160, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P1322', 1159, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 47');

add_assessment_score(v_id1, owner_id, owner_id, 'P1321', 1158, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P771', 608, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1327', 1164, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1369', 1206, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P1325', 1162, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 50');

add_assessment_score(v_id1, owner_id, owner_id, 'P1324', 1161, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P673', 510, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 22');

add_assessment_score(v_id1, owner_id, owner_id, 'P672', 509, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1329', 1166, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P670', 507, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 19');

add_assessment_score(v_id1, owner_id, owner_id, 'P677', 514, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 26');

add_assessment_score(v_id1, owner_id, owner_id, 'P676', 513, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 25');

add_assessment_score(v_id1, owner_id, owner_id, 'P675', 512, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 24');

add_assessment_score(v_id1, owner_id, owner_id, 'P674', 511, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 23');

add_assessment_score(v_id1, owner_id, owner_id, 'P1563', 1400, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1165', 1002, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1822', 1659, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK26');
add_assessment_code(v_id1, owner_id, owner_id, 'P1822', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1822', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1822', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1822', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'P1231', 1068, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P452', 1863, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 63');

add_assessment_score(v_id1, owner_id, owner_id, 'P1051', 888, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1179', 1016, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 8');

add_assessment_score(v_id1, owner_id, owner_id, 'P1208', 1045, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1160', 997, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AFFECT FLATTENING WK41');

add_assessment_score(v_id1, owner_id, owner_id, 'P1823', 1660, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK27');
add_assessment_code(v_id1, owner_id, owner_id, 'P1823', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1823', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1823', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1823', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1230', 1067, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P309', 242, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1475', 1312, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 44');

add_assessment_score(v_id1, owner_id, owner_id, 'P308', 1815, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P748', 585, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P307', 1814, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P1050', 887, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ANHEDONIA WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P306', 241, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P305', 240, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P178', 155, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 18');

add_assessment_score(v_id1, owner_id, owner_id, 'P276', 221, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P275', 220, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P304', 239, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P273', 218, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P272', 1803, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1474', 1311, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P270', 217, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P170', 1769, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P1200', 1037, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P172', 151, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P173', 152, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DOSE LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P174', 153, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P175', 1770, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P279', 222, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P177', 154, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 17');

add_assessment_score(v_id1, owner_id, owner_id, 'P1107', 944, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 40');

add_assessment_score(v_id1, owner_id, owner_id, 'P301', 1812, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1632', 1469, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:DEPRESSED SYNDROME WK 45');

add_assessment_score(v_id1, owner_id, owner_id, 'P300', 237, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1081', 918, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 14');

add_assessment_score(v_id1, owner_id, owner_id, 'P1641', 1478, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 2');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1641', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P736', 573, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 33');

add_assessment_score(v_id1, owner_id, owner_id, 'P1642', 1479, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 3');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1642', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1657', 1494, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:ALCOHOL USE WEEK 18');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1657', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1728', 1565, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 37');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1728', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1106', 943, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 39');

add_assessment_score(v_id1, owner_id, owner_id, 'P141', 130, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 11');

add_assessment_score(v_id1, owner_id, owner_id, 'P1287', 1124, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P171', 150, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 16');

add_assessment_score(v_id1, owner_id, owner_id, 'P737', 574, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1724', 1561, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 33');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1724', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1723', 1560, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SUBSTANCE USE:DRUG USE WEEK 32');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1723', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P1105', 942, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 38');

add_assessment_score(v_id1, owner_id, owner_id, 'P1280', 1117, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:MANIC MOOD WEEK 5');

add_assessment_score(v_id1, owner_id, owner_id, 'P49', 60, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH CHANGES IN MAR. STATUS-SEPARATED');

add_assessment_score(v_id1, owner_id, owner_id, 'P48', 59, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH CHANGES IN MAR. STATUS-MARRIED');

add_assessment_score(v_id1, owner_id, owner_id, 'P47', 58, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH MARITAL STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 1, 'Single', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 2, 'Married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 3, 'Living/Opp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 4, 'Widowed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 5, 'Seperated', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 6, 'Divorced', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P47', 7, 'Living/Same', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P46', 57, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FRIENDS RELATIONS BEST 6 MOS');

add_assessment_score(v_id1, owner_id, owner_id, 'P45', 56, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FRIENDS RELATIONS WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P45', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P35', 46, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS STEPMOM WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P35', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P43', 54, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS OTHER WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P43', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P42', 53, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS CHILDREN BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P42', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P41', 52, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS CHILDREN WK PRIOR');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P41', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P40', 51, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH FAM. RELATIONS SPOUSE BEST 6 MOS');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 0, 'Not applicable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 1, 'Very good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 5, 'Very Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 6, 'Variable/At least one good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 7, 'Variable/None good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P40', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P734', 571, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P369', 282, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P880', 717, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:BIZARRE BEHAVIOR WK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P259', 1798, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 31');

add_assessment_score(v_id1, owner_id, owner_id, 'P402', 305, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 55');

add_assessment_score(v_id1, owner_id, owner_id, 'P1104', 941, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 37');

add_assessment_score(v_id1, owner_id, owner_id, 'P1103', 940, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1259', 1096, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEG SX:INAPPROPRIATE AFFECT WK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1102', 939, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 35');

add_assessment_score(v_id1, owner_id, owner_id, 'P1370', 1207, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:DEPRESSED MOOD WK 43');

add_assessment_score(v_id1, owner_id, owner_id, 'P819', 656, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 12');

add_assessment_score(v_id1, owner_id, owner_id, 'P1537', 1374, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:MANIC SYNDROME WEEK 2');

add_assessment_score(v_id1, owner_id, owner_id, 'P1452', 1289, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P959', 796, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P408', 309, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'P530', 1889, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 76');

add_assessment_score(v_id1, owner_id, owner_id, 'P360', 277, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P732', 569, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P363', 278, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 48');

add_assessment_score(v_id1, owner_id, owner_id, 'P678', 515, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 27');

add_assessment_score(v_id1, owner_id, owner_id, 'P693', 530, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-DAY OF WEEK 42');

add_assessment_score(v_id1, owner_id, owner_id, 'P98', 1745, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P814', 651, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:HALLUCINATIONS WEEK 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P99', 102, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CHANGE LINE 4');

add_assessment_score(v_id1, owner_id, owner_id, 'P1534', 1371, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 51');

add_assessment_score(v_id1, owner_id, owner_id, 'P1459', 1296, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:POS PSYCHOTIC WEEK 28');

add_assessment_score(v_id1, owner_id, owner_id, 'P1223', 1060, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:ATTENTION WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P364', 279, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG CODE LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P592', 429, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ALCOHOL ABUSE DUR. COMPLETED EPIS');

add_assessment_score(v_id1, owner_id, owner_id, 'P739', 576, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 36');

add_assessment_score(v_id1, owner_id, owner_id, 'P1512', 1349, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 29');

add_assessment_score(v_id1, owner_id, owner_id, 'P733', 570, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH TIMELINE-YEAR OF WEEK 30');

add_assessment_score(v_id1, owner_id, owner_id, 'P366', 281, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 49');

add_assessment_score(v_id1, owner_id, owner_id, 'P789', 626, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P198', 169, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG ROUTE LINE 21');

add_assessment_score(v_id1, owner_id, owner_id, 'P1101', 938, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH NEGATIVE SX:AVOLITION WEEK 34');

add_assessment_score(v_id1, owner_id, owner_id, 'P1535', 1372, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH SYNDROMES:NEG PSYCHOTIC WEEK 52');

add_assessment_score(v_id1, owner_id, owner_id, 'P1425', 1262, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH AFFECTIVE SX:ANXIOUS MOOD WEEK 46');

add_assessment_score(v_id1, owner_id, owner_id, 'P1831', 1668, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH OTHER BEH:ANTISOCIAL BEH WK35');
add_assessment_code(v_id1, owner_id, owner_id, 'P1831', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1831', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1831', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'P1831', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'P115', 1750, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE BEGAN LINE 7');

add_assessment_score(v_id1, owner_id, owner_id, 'P912', 749, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:POS THOUGHT DIS WK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P593', 430, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH ALCOHOL ABUSE IN EPISODE?');

add_assessment_score(v_id1, owner_id, owner_id, 'P756', 593, 'numeric', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH POSITIVE SX:DELUSIONS WEEK 1');

add_assessment_score(v_id1, owner_id, owner_id, 'P410', 1849, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 56');

add_assessment_score(v_id1, owner_id, owner_id, 'P92', 1743, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCH DRUG DATE ENDED LINE 3');

commit;
END;
/
