set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9113816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '2210210',
      NULL,
      0,
      3,
      '00241',
      1.270270,
      ' 9- 3-2001',
      37,
      NULL,
      1.067208,
      3,
      2.716241,
      NULL,
      1,
      NULL,
      1.390238,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.789112,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550311,
      NULL,
      0.805028,
      5,
      0.852297,
      3.585700,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      0,
      0,
      6,
      NULL,
      0,
      1,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.414850,
      0,
      1,
      2,
      NULL,
      1.162872,
      0,
      0.445704,
      6,
      0,
      1,
      9.101220,
      0.064632,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      7,
      2,
      65.368556,
      NULL,
      13601,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.850084,
      195.627407,
      16335,
      0.421263,
      NULL,
      82,
      18702.342636,
      NULL,
      NULL,
      173.059007,
      17735.728137,
      3,
      0,
      506.203267,
      17709,
      2,
      1.219668,
      4,
      NULL,
      5,
      1,
      34.416679,
      19972,
      0,
      2,
      522.611914,
      14666,
      1.002522,
      5.432837,
      NULL,
      1502,
      2.608792,
      2.060184,
      171.062687,
      40,
      3.021703,
      1.135444,
      NULL,
      NULL,
      3,
      2,
      73.434656,
      1178.450666,
      NULL,
      0,
      34,
      52.484621,
      NULL,
      2,
      205,
      5,
      NULL,
      2.147472,
      66,
      34.292072,
      2.301122,
      1,
      237,
      5.077505,
      1,
      5,
      121.500148,
      NULL,
      2,
      NULL,
      234.089018,
      42,
      3,
      3.953961,
      48,
      NULL,
      3,
      6,
      NULL,
      22.157557,
      1,
      NULL,
      30,
      101.815245,
      NULL,
      NULL,
      206,
      NULL,
      3.120437,
      0.146894,
      51.549357,
      590.295358,
      0.835392,
      2,
      185.578524,
      366,
      0,
      5,
      109,
      187.650842,
      2,
      2.410776,
      125.694256,
      253.454922,
      3,
      1,
      NULL,
      723.747264,
      NULL,
      7,
      205,
      588.532220,
      1,
      2,
      167,
      431,
      1,
      1.683243,
      333.997666,
      3705,
      0.501904,
      1.681201,
      333.454474,
      17768,
      1.786724,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.616639,
      '42422',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.467609,
      '',
      NULL,
      '',
      2,
      '14233',
      '',
      '',
      0,
      NULL,
      NULL,
      3.533688,
      2.339406,
      0,
      NULL,
      1,
      NULL,
      1.992849,
      NULL,
      1.484035,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.489930,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1996',
      7,
      7.866974,
      0.435273,
      3,
      2,
      0.920205,
      7.176667,
      15,
      1.977515,
      NULL,
      4.882882,
      0.950797,
      3,
      NULL,
      5.169180,
      0.380389,
      17.885711,
      0.900934,
      4,
      NULL,
      6.454717,
      2.319178,
      5.630946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.099671,
      0.251196,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      4.007435,
      6.180600,
      0,
      NULL,
      9,
      NULL,
      6.706057,
      26.309045,
      1.713470,
      22,
      9.963905,
      0.136116,
      9.816333,
      37,
      8,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      150.025835,
      80.273962,
      NULL,
      NULL,
      148.796524,
      61.211233,
      129,
      NULL,
      112,
      114,
      72.138311,
      129,
      172,
      4.541788,
      NULL,
      39,
      123.201640,
      182.011654,
      95.298038,
      15.246474,
      NULL,
      170.824481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098117,
      4.817321,
      NULL,
      9.395291,
      0,
      10,
      NULL,
      8.358402,
      4.845805,
      NULL,
      5,
      6.928093,
      NULL,
      8.395750,
      NULL,
      7.415071,
      1,
      7,
      7,
      0,
      2,
      NULL,
      4.965910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0.418139,
      1.183566,
      11.369029,
      0,
      0,
      NULL,
      8.081165,
      7.091370,
      10.011574,
      3,
      NULL,
      5,
      0,
      3.070949,
      8,
      NULL,
      11.225484,
      3.665799,
      1.696942,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439219,
      1,
      2.521940,
      4,
      7,
      6.148142,
      3.423552,
      6,
      6.162261,
      3.428744,
      7,
      0,
      NULL,
      1.477672,
      4.650771,
      7.599170,
      3,
      NULL,
      7.327997,
      6.060993,
      NULL,
      0,
      1.367019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265672,
      5.401160,
      NULL,
      1,
      1,
      3.127263,
      NULL,
      3.456697,
      7,
      2.106601,
      4.547026,
      5,
      5,
      4.576003,
      5,
      5,
      7,
      1.985360,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694622,
      2.494052,
      0,
      3.490784,
      3.021233,
      NULL,
      2,
      NULL,
      1,
      5.320248,
      3,
      7,
      6.408042,
      2.265125,
      3.931497,
      5.160072,
      NULL,
      NULL,
      2.517915,
      0.982625,
      NULL,
      1.191538,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747500,
      5.245355,
      2,
      11.866670,
      NULL,
      11,
      3,
      10,
      2,
      NULL,
      0.795168,
      2,
      0.559107,
      NULL,
      NULL,
      4.868787,
      3.526733,
      11,
      0,
      10.137793,
      NULL,
      11,
      9.391406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222014,
      1.263499,
      NULL,
      5,
      3,
      NULL,
      0,
      7.821582,
      0.384226,
      6.366434,
      1.678082,
      0.122094,
      NULL,
      NULL,
      NULL,
      4.385228,
      5,
      0.643394,
      1.914551,
      6,
      3.396591,
      5.320343,
      9.966107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.938516,
      1.625649,
      0.074127,
      4.562093,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      1,
      3,
      4.147916,
      4,
      NULL,
      1,
      0.548899,
      NULL,
      5,
      2,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      0,
      NULL,
      8,
      2.935884,
      5.098502,
      1,
      8.725253,
      NULL,
      4,
      4.726990,
      2,
      0,
      1.667074,
      0,
      0,
      5.034085,
      4.021643,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3,
      1,
      NULL,
      3.721910,
      1.781348,
      4.200479,
      2.105983,
      5,
      NULL,
      6.719407,
      5,
      3.382308,
      0,
      3.335356,
      7.520190,
      5,
      1.005132,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1.974682,
      0,
      2.081726,
      NULL,
      NULL,
      1,
      0.093288,
      1,
      1,
      1.014466,
      1.400081,
      1.548782,
      1.995209,
      1,
      3,
      1,
      2.466179,
      0.672915,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.904330,
      1.481165,
      0.690197,
      0,
      0.140144,
      0,
      0,
      0.611409,
      0.246184,
      1.919755,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.743787,
      NULL,
      1.887828,
      1.297014,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235500,
      1,
      1.966543,
      1.109758,
      1.997443,
      0.497964,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.540266,
      1.381460,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1.704092,
      1.281339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.987249,
      NULL,
      7,
      7.047527,
      2.997682,
      NULL,
      6.933059,
      8,
      1,
      9,
      7.551667,
      8,
      5,
      10,
      4,
      NULL,
      NULL,
      7.309883,
      7,
      9.664017,
      1.885740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199100,
      0.515512,
      5.583094,
      9.584497,
      3.749711,
      NULL,
      NULL,
      1,
      5.093021,
      9,
      1.166420,
      0.801928,
      2,
      NULL,
      2.920615,
      9,
      1,
      6,
      NULL,
      NULL,
      6.871049,
      2.114277,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.092677,
      0.458428,
      0,
      0,
      0,
      0.657360,
      1.048095,
      1.425060,
      NULL,
      0.991412,
      NULL,
      0,
      0,
      NULL,
      1.839158,
      1.008888,
      1,
      1,
      0.204582,
      1.567854,
      0.427120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761055,
      0,
      1.279368,
      0,
      NULL,
      0.488201,
      NULL,
      1.169019,
      0,
      0.998760,
      0.718819,
      NULL,
      1.765357,
      0,
      1,
      NULL,
      1.376396,
      0,
      NULL,
      1,
      1.841381,
      0,
      0.131018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      2,
      NULL,
      3,
      1,
      0,
      1,
      0,
      1,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      3,
      5,
      3,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-18-1990',
      ' 5-20-1987',
      NULL,
      ' 6-13-1998',
      '10-21-1990',
      '11-23-1976',
      NULL,
      ' 5- 5-1983',
      NULL,
      '10-29-1975',
      '10- 2-1986',
      ' 1- 5-1979',
      '11- 6-1989',
      ' 0-26-1988',
      ' 5-20-1981',
      NULL,
      ' 7- 4-1995',
      ' 3-24-1984',
      ' 9-27-1997',
      ' 3- 6-1980',
      NULL,
      NULL,
      ' 5- 1-1985',
      '10-18-1975',
      ' 9-23-1977',
      ' 5-14-1988',
      NULL,
      ' 2- 2-1978',
      ' 8-18-1993',
      ' 9-15-1978',
      ' 7-20-1978',
      '10-18-1993',
      ' 8- 6-2002',
      ' 3-25-1982',
      ' 7-27-1979',
      NULL,
      ' 9-25-2001',
      NULL,
      ' 7- 4-1981',
      ' 3-10-1993',
      ' 6- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762664);
commit;
end;
/


