set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8720748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '4102221',
      1,
      1.240050,
      2,
      NULL,
      3.152306,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.438539,
      1.267534,
      1.383345,
      0.765350,
      0,
      1.706944,
      2.027404,
      NULL,
      0.218352,
      7,
      NULL,
      NULL,
      0,
      0.616698,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689150,
      1,
      NULL,
      NULL,
      1.765325,
      4,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      5,
      4,
      8,
      6.953819,
      0,
      8.814621,
      2,
      0.857280,
      1.549959,
      NULL,
      NULL,
      3,
      NULL,
      18,
      8,
      NULL,
      9,
      15,
      NULL,
      7,
      NULL,
      7,
      NULL,
      1,
      37,
      '10- 1-1997',
      186,
      0.038003,
      NULL,
      3,
      6,
      NULL,
      5,
      3,
      7,
      143,
      14889,
      3,
      0,
      620,
      NULL,
      3,
      NULL,
      152,
      3156,
      2,
      NULL,
      NULL,
      19302,
      0,
      5.222371,
      NULL,
      7081,
      2.620479,
      2.287340,
      65,
      17782,
      NULL,
      NULL,
      98,
      2201.387649,
      1.374091,
      NULL,
      110,
      15095.545431,
      3,
      5.833228,
      128.520374,
      13514,
      1,
      5,
      137.075212,
      16675.501414,
      0,
      4,
      254,
      8629,
      0,
      1.132947,
      33.996442,
      NULL,
      0,
      0.234640,
      209.089785,
      NULL,
      NULL,
      2.401322,
      246.855107,
      4.353539,
      0.944857,
      NULL,
      15.363447,
      25,
      3.293763,
      3.372312,
      78.632631,
      85.629130,
      0.714781,
      1.968099,
      110.640501,
      112,
      1.456607,
      4,
      NULL,
      62,
      3.265606,
      7.059215,
      35.375045,
      278,
      2,
      3,
      187.803484,
      2,
      3,
      NULL,
      153,
      41,
      2.133665,
      NULL,
      NULL,
      448,
      3.330564,
      3,
      45.225426,
      87.383684,
      NULL,
      4.587772,
      131.289069,
      49,
      3,
      6,
      213,
      487.064167,
      3.464675,
      2.981936,
      126,
      536.736856,
      NULL,
      3.402533,
      21.168626,
      NULL,
      3.158821,
      2,
      NULL,
      43,
      0,
      5,
      50,
      385,
      2.797978,
      3.107588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '41203',
      '',
      NULL,
      2,
      2.798261,
      NULL,
      1.669639,
      1128.743232,
      0.179051,
      NULL,
      1.958750,
      NULL,
      0,
      NULL,
      1.802573,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.402577,
      NULL,
      0.986330,
      NULL,
      '11-12-1998',
      1,
      4,
      4,
      15.996451,
      2,
      4,
      2.767271,
      8.089084,
      17,
      7.744759,
      2.587960,
      NULL,
      9,
      2,
      1,
      NULL,
      11,
      13,
      1.517594,
      2,
      2,
      4.197594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317722,
      3,
      NULL,
      16,
      1,
      NULL,
      11,
      18.625410,
      1.067951,
      1.663232,
      17.873845,
      24,
      3,
      1.927873,
      12,
      13,
      3.688293,
      2,
      18,
      27,
      2,
      33,
      37.979540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      80,
      30,
      37,
      NULL,
      89.651957,
      65,
      NULL,
      50.698086,
      1.618977,
      121,
      63,
      NULL,
      108,
      NULL,
      76,
      4.291490,
      126,
      47,
      NULL,
      64,
      94,
      85.053776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2,
      0.421210,
      6,
      NULL,
      1,
      6,
      0,
      0,
      0.662735,
      3,
      5.520965,
      NULL,
      NULL,
      10.926836,
      6,
      6,
      NULL,
      NULL,
      0.204330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285523,
      1,
      4.324371,
      3.785810,
      4,
      2.060776,
      7.123829,
      1.178342,
      2,
      4,
      2.357284,
      0,
      10,
      4.496395,
      8.404797,
      3.030318,
      4,
      2.859929,
      6.996559,
      NULL,
      1,
      9.569367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133139,
      NULL,
      NULL,
      1.817926,
      0,
      3.678531,
      NULL,
      0.018792,
      1,
      NULL,
      1,
      0.692126,
      NULL,
      NULL,
      4,
      NULL,
      1,
      2.804483,
      NULL,
      2,
      4,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.408989,
      NULL,
      1.955160,
      0,
      2.531853,
      4.713183,
      0,
      5,
      1.964868,
      0,
      1,
      3.331315,
      3,
      NULL,
      1,
      1.560381,
      NULL,
      5.021296,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.964113,
      NULL,
      2,
      0.066631,
      0,
      2,
      NULL,
      NULL,
      0.280206,
      NULL,
      5,
      5.639383,
      2.153512,
      2.473032,
      2.810975,
      0,
      NULL,
      1,
      3,
      0.002934,
      0,
      1.863770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9,
      6,
      7,
      4,
      NULL,
      2.922080,
      NULL,
      4,
      2.862192,
      NULL,
      6,
      3.995808,
      NULL,
      NULL,
      0,
      4,
      6,
      7.832919,
      5,
      0.114945,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      NULL,
      9,
      7,
      10,
      9.159744,
      NULL,
      7.237427,
      10,
      4.132409,
      0,
      4.579852,
      2,
      3.960597,
      NULL,
      3.179241,
      NULL,
      3.811606,
      3,
      3.845758,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.943286,
      NULL,
      2,
      2,
      7.959649,
      NULL,
      NULL,
      3,
      4.156415,
      NULL,
      0.929225,
      2,
      1.387078,
      1,
      NULL,
      1.088437,
      7.752109,
      0,
      0.007412,
      0.852447,
      NULL,
      0.928079,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568915,
      7,
      NULL,
      4,
      4,
      NULL,
      2.459077,
      6,
      0.174115,
      NULL,
      5.693873,
      8,
      0,
      NULL,
      2.661122,
      5.725346,
      3,
      4,
      5.506000,
      2,
      NULL,
      4.529486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.209816,
      1,
      0,
      NULL,
      0,
      0.786461,
      0,
      2,
      1,
      1,
      2.905108,
      1.436054,
      2,
      0.785677,
      0.084118,
      3.756360,
      1.724237,
      2.673193,
      3.926342,
      2,
      2,
      0,
      1.769921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.675720,
      0.937267,
      0.514152,
      0,
      NULL,
      NULL,
      0.847204,
      0,
      0,
      1,
      1,
      NULL,
      0.469186,
      0.793030,
      1.590131,
      NULL,
      1,
      0.524126,
      0.745807,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798945,
      NULL,
      1.106055,
      0.039900,
      1.677831,
      1.800522,
      1,
      1,
      1.549686,
      1,
      0,
      1.490569,
      1,
      0,
      0,
      1.370079,
      1.205777,
      1.461833,
      1.097155,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.373449,
      1.760319,
      NULL,
      0,
      1.446822,
      0,
      1,
      0,
      1.369783,
      0,
      1.127775,
      0.789663,
      NULL,
      1,
      0,
      1.962388,
      NULL,
      1.713448,
      0.593556,
      1,
      1.366582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654535,
      2.972206,
      11.599944,
      7.270168,
      1.992163,
      3,
      NULL,
      8.028744,
      5.633801,
      9.540474,
      NULL,
      7,
      9.905451,
      8.842327,
      7.918255,
      3,
      11.610568,
      9.573070,
      NULL,
      0.871306,
      9.249929,
      3.461130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.031011,
      1.285698,
      2.053602,
      2,
      0.497586,
      NULL,
      3,
      NULL,
      0,
      NULL,
      5.839393,
      2.473031,
      1,
      7,
      7,
      4,
      8.702749,
      NULL,
      NULL,
      5.692817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.595547,
      NULL,
      0,
      1,
      1.941373,
      0,
      0,
      0.014454,
      0.177903,
      NULL,
      NULL,
      0.860450,
      1.840483,
      1.017461,
      NULL,
      0.953837,
      NULL,
      0.306042,
      0.202046,
      0.797598,
      0,
      0.926311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147788,
      1,
      1.882638,
      1,
      0,
      0,
      1,
      1.153399,
      0,
      1.032988,
      1.203732,
      1,
      0.532120,
      1,
      0,
      NULL,
      1.084108,
      1.892630,
      1,
      0.706081,
      0.921621,
      0,
      1.744784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      3,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      4,
      1,
      3,
      2,
      NULL,
      2,
      5,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-2002',
      NULL,
      ' 2-11-1997',
      NULL,
      ' 7- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1982',
      NULL,
      ' 1- 5-1981',
      NULL,
      ' 4- 1-1997',
      ' 1- 3-1977',
      NULL,
      ' 0-19-1992',
      NULL,
      '11-21-1995',
      ' 6-16-2000',
      ' 4-12-2003',
      ' 8- 6-1985',
      ' 1-20-2002',
      ' 8-22-1978',
      '11-11-2002',
      NULL,
      ' 8-17-1984',
      ' 2-27-1996',
      ' 4- 4-1989',
      ' 5-29-1991',
      ' 3-22-2003',
      ' 3-17-1996',
      ' 3- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1982',
      ' 5- 9-1976',
      ' 3- 6-1992',
      ' 3-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


