set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '0010212',
      3,
      NULL,
      3,
      '04123',
      2,
      ' 1- 7-1997',
      NULL,
      NULL,
      0,
      2,
      2.131428,
      1.712701,
      1,
      0,
      NULL,
      3.045857,
      2.331373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.751858,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.507251,
      6,
      NULL,
      3.515454,
      NULL,
      NULL,
      0,
      NULL,
      7,
      6,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      7.370358,
      7,
      8.517744,
      1,
      0.362706,
      0,
      1.440621,
      NULL,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      4.422166,
      4,
      NULL,
      9,
      4,
      0.714695,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737343,
      NULL,
      0,
      NULL,
      1,
      1,
      5,
      59.388818,
      89,
      8,
      0,
      1,
      98.963567,
      NULL,
      1.893478,
      0,
      98.112219,
      3,
      5.645505,
      3,
      260.873995,
      NULL,
      0,
      2,
      NULL,
      8,
      1,
      3,
      67,
      5,
      0.591561,
      6.618431,
      NULL,
      23.680806,
      1,
      0.511756,
      224,
      114.964479,
      2,
      1,
      NULL,
      60,
      NULL,
      1,
      238,
      7,
      3.583188,
      2,
      33,
      48.683284,
      5,
      NULL,
      599.078153,
      12.465636,
      4.045448,
      NULL,
      18,
      41.870425,
      4,
      0,
      24,
      19,
      4.436004,
      3.568272,
      221,
      NULL,
      1.032543,
      9.581812,
      326,
      1,
      3,
      1,
      579,
      NULL,
      0.955193,
      0.693696,
      65.262029,
      18.753690,
      NULL,
      2.492402,
      49.286279,
      16,
      2,
      1,
      177.712209,
      174,
      0,
      2.572387,
      140,
      52,
      NULL,
      0,
      129.549580,
      59.268260,
      1.423247,
      7,
      82,
      123.797192,
      2,
      5,
      872,
      2.275574,
      3.887502,
      2,
      156,
      1134.296036,
      1,
      1,
      4.508554,
      5.481369,
      NULL,
      3,
      229.832695,
      47,
      NULL,
      NULL,
      90,
      55,
      1.422916,
      1.022948,
      386.089310,
      6,
      1.661897,
      NULL,
      321,
      8.332305,
      2.313397,
      6,
      161.983220,
      118.443937,
      0,
      6,
      351.514618,
      10.560062,
      0.365595,
      0,
      32,
      NULL,
      1,
      6,
      138.219794,
      7,
      0,
      4.680231,
      64.803517,
      33.636569,
      1,
      6,
      310,
      6,
      1,
      7,
      76.821386,
      191,
      0,
      8,
      20.525613,
      38.303000,
      0,
      1,
      NULL,
      4,
      2.442990,
      NULL,
      3.653870,
      506.750641,
      NULL,
      2.049518,
      931.457952,
      169.668661,
      2,
      3.210061,
      42,
      NULL,
      NULL,
      NULL,
      135.044376,
      166.432378,
      1,
      0,
      1131.951973,
      NULL,
      3,
      1.053278,
      NULL,
      NULL,
      1.037556,
      0.458134,
      185,
      2.355315,
      2,
      0.038396,
      606.753904,
      66,
      2.103006,
      NULL,
      NULL,
      1586,
      2.566309,
      2.521233,
      381,
      73.463243,
      1,
      1,
      1370,
      142.332214,
      1,
      2,
      157.813346,
      NULL,
      NULL,
      1.048825,
      197.978037,
      2,
      0.330655,
      NULL,
      159,
      3,
      1,
      3,
      1005.116158,
      164,
      0.966586,
      0.828134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '13310',
      '13443',
      NULL,
      NULL,
      '',
      NULL,
      '41024',
      '',
      '',
      6,
      '10412',
      '1410',
      NULL,
      NULL,
      NULL,
      212.596659,
      0.644736,
      190.053033,
      0,
      NULL,
      NULL,
      NULL,
      1.044425,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      ' 8-15-1993',
      11,
      13.600353,
      17.411500,
      20.538413,
      11,
      5.932921,
      1.147607,
      NULL,
      11,
      3.152582,
      NULL,
      3.308283,
      7,
      6.469093,
      16,
      8.464443,
      4,
      4,
      0.422627,
      3,
      NULL,
      10.371229,
      13,
      2,
      15.695055,
      5,
      2.886693,
      6.682067,
      2,
      0.988120,
      6.215695,
      3,
      NULL,
      9.873259,
      8.302515,
      NULL,
      6.148554,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.394686,
      7.911380,
      5,
      14.502817,
      31,
      6,
      8,
      3.842782,
      17,
      24.741227,
      2.447551,
      45,
      0.073804,
      8,
      31.145804,
      NULL,
      5,
      35,
      6.340294,
      33.348456,
      8,
      40,
      33.755226,
      18,
      42.793869,
      19,
      1,
      15.880168,
      14.643949,
      14,
      15,
      9.957570,
      5,
      NULL,
      25,
      0.069151,
      3.508991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110.429772,
      94.060794,
      31.304715,
      NULL,
      43.842989,
      NULL,
      65.925084,
      144,
      85,
      NULL,
      85.185165,
      103,
      NULL,
      54.543260,
      NULL,
      59,
      NULL,
      NULL,
      98.890873,
      174,
      66,
      169.878859,
      0.420385,
      NULL,
      31,
      111.763348,
      98,
      NULL,
      NULL,
      111,
      5,
      12,
      NULL,
      NULL,
      98,
      135.252662,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903332,
      1.198596,
      NULL,
      NULL,
      1,
      7.025657,
      NULL,
      1,
      2.357026,
      NULL,
      7,
      3.005668,
      1.954045,
      0,
      4,
      2,
      0,
      6,
      0.152476,
      5.137820,
      5.991497,
      2.591196,
      0,
      8.845853,
      2.092082,
      NULL,
      NULL,
      4,
      5.887090,
      1,
      0.762481,
      5,
      4,
      3.403221,
      6.870298,
      7.549598,
      5.635863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0.905211,
      1.449499,
      1,
      1,
      4.227139,
      NULL,
      0,
      3.205280,
      5,
      0.258325,
      1,
      1.771608,
      0.851211,
      0,
      1.476349,
      NULL,
      1.042152,
      0.894653,
      6,
      7.629253,
      7,
      NULL,
      NULL,
      0,
      NULL,
      0.215970,
      4,
      1.685651,
      NULL,
      1.724735,
      5.136621,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.790891,
      5.254839,
      NULL,
      1.509758,
      1.155685,
      6.804499,
      NULL,
      7,
      0.623695,
      0,
      0,
      NULL,
      1,
      8,
      1,
      7,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      0,
      1,
      1.830768,
      5,
      3,
      3.733591,
      2.992763,
      5,
      5.427037,
      2,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.907949,
      0.433951,
      1.105498,
      1,
      0,
      0.649800,
      0.798829,
      1.485278,
      NULL,
      0.691604,
      1.282342,
      1,
      0,
      0,
      0,
      1,
      1,
      5.547705,
      1,
      0,
      0,
      0,
      1.054631,
      0,
      0,
      1,
      0,
      2.896122,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.193792,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.638372,
      1,
      0.277712,
      0.925802,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.344252,
      0.570719,
      0.558916,
      0,
      0.445607,
      1.634860,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.179761,
      0.333874,
      1.155057,
      0.191273,
      0,
      0.663474,
      NULL,
      0,
      0.386319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702477,
      NULL,
      6,
      6.214944,
      0,
      5,
      0.972779,
      5.396003,
      6,
      0.511356,
      0,
      5,
      2.839207,
      0.885738,
      NULL,
      NULL,
      2,
      3.738605,
      2,
      6,
      0.076128,
      3,
      NULL,
      0.845366,
      6.657907,
      0.081482,
      NULL,
      1,
      2.968722,
      2,
      NULL,
      7,
      0,
      2.162402,
      1,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      7,
      1.384300,
      5,
      0.151356,
      2.219980,
      0.603576,
      9.148643,
      NULL,
      7,
      3,
      NULL,
      5,
      6.265111,
      8,
      7,
      7,
      NULL,
      NULL,
      6.531774,
      NULL,
      NULL,
      2.708718,
      3.995766,
      8.004572,
      9.066336,
      9,
      4.455343,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.991819,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229953,
      0.454127,
      1,
      3,
      1,
      1,
      0.931040,
      1.632601,
      NULL,
      3,
      0.034736,
      2,
      0.250695,
      0.960181,
      0,
      1,
      1.726767,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0.394119,
      1.301459,
      0.359312,
      NULL,
      0.508783,
      NULL,
      NULL,
      3.705132,
      1,
      NULL,
      3.951466,
      3,
      NULL,
      4.620692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.022493,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1.594458,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.319340,
      NULL,
      1,
      1,
      0.678960,
      1.639169,
      NULL,
      1.541051,
      NULL,
      0,
      1.250223,
      3.063256,
      0,
      NULL,
      NULL,
      NULL,
      1.450962,
      0,
      NULL,
      1.631694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.916594,
      0.511713,
      1,
      1,
      1.890380,
      1.579977,
      1.135998,
      1,
      0.482694,
      1.742383,
      NULL,
      0.525276,
      1,
      0,
      NULL,
      1.808336,
      0.489714,
      0,
      NULL,
      1.024687,
      0.991885,
      1,
      0,
      2,
      2,
      7,
      1,
      1.954008,
      0.800897,
      0,
      2,
      3.603771,
      0.076442,
      0.369374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605826,
      1.794440,
      3,
      4,
      7,
      2,
      3.633726,
      3,
      0,
      2,
      4,
      2,
      6.451436,
      1.522098,
      0.960870,
      NULL,
      NULL,
      3,
      1,
      3,
      4.782297,
      5.351429,
      2.723218,
      2,
      2.878474,
      NULL,
      5,
      4.979713,
      4.920422,
      NULL,
      4.385289,
      3.465861,
      NULL,
      8,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.245397,
      0.216063,
      1.314755,
      0,
      1.307429,
      1,
      3.376978,
      3.515027,
      1.436227,
      2.800668,
      NULL,
      3,
      1.064526,
      1,
      1.648130,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      2.886140,
      0.454012,
      2.618628,
      0,
      0.362766,
      5,
      NULL,
      NULL,
      5.816840,
      3.550057,
      3,
      0,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369647,
      7,
      5,
      NULL,
      1,
      1.421600,
      4.058706,
      5.313115,
      NULL,
      2,
      2.210391,
      1.435049,
      NULL,
      0.979995,
      2.971101,
      5.511245,
      7,
      5.964559,
      5.737675,
      4.606887,
      NULL,
      2.671465,
      0.147268,
      NULL,
      0.051541,
      0,
      3.185047,
      NULL,
      1,
      NULL,
      4.616783,
      NULL,
      NULL,
      1.948941,
      5,
      5.702854,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496133,
      NULL,
      1,
      0,
      6,
      NULL,
      6.117409,
      1.025051,
      NULL,
      0.877978,
      9,
      4,
      NULL,
      6.273529,
      7.574098,
      5,
      3,
      3,
      NULL,
      3,
      4.481560,
      0.715140,
      5.503371,
      NULL,
      6,
      7,
      0,
      0,
      7,
      3,
      4.918227,
      7,
      8.539955,
      5.967180,
      5,
      7.047620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.257048,
      NULL,
      NULL,
      3.297311,
      NULL,
      8,
      5.978154,
      4.995522,
      3.809981,
      6.688374,
      1.570717,
      NULL,
      5.884210,
      0.736207,
      0,
      6.704419,
      NULL,
      6.021725,
      1,
      4.708335,
      NULL,
      6,
      1,
      0,
      7.187581,
      7.267608,
      7.910573,
      6,
      NULL,
      4.373019,
      4,
      3,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592505,
      0,
      0,
      0.959766,
      0.686793,
      1.935979,
      NULL,
      1.759772,
      0,
      1,
      1,
      0.793306,
      NULL,
      0,
      NULL,
      NULL,
      3.969671,
      0,
      3,
      1,
      2.102389,
      0.997289,
      1.139722,
      1.853190,
      3.183389,
      0,
      1.920573,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.288035,
      0.240981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.964354,
      0.964467,
      1.354516,
      1.658358,
      1,
      NULL,
      NULL,
      NULL,
      2.425587,
      0.825243,
      NULL,
      1,
      1,
      1,
      1.731267,
      1.699771,
      1.555051,
      0.228629,
      0.472539,
      NULL,
      NULL,
      0.115172,
      2.446661,
      1.634231,
      0,
      1,
      0,
      NULL,
      2.368516,
      2.295569,
      1,
      2,
      NULL,
      1.384947,
      3,
      1.871511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      3,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      5,
      2,
      1,
      NULL,
      3,
      0,
      1,
      2,
      1,
      1,
      0,
      1,
      NULL,
      0,
      2,
      3,
      2,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      1,
      1,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441275,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      2,
      3,
      2,
      0,
      3,
      0,
      1,
      1,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      0,
      3,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-1986',
      NULL,
      ' 7-18-1986',
      ' 1-19-2001',
      NULL,
      '11-27-1975',
      '10-24-2001',
      NULL,
      NULL,
      ' 9- 9-1986',
      ' 7-24-1996',
      ' 0- 6-1978',
      ' 4-11-1982',
      ' 8- 6-1990',
      ' 2-17-1992',
      ' 5-19-1992',
      NULL,
      NULL,
      ' 3-10-2000',
      '11- 6-1991',
      ' 0-19-1998',
      ' 2-10-1981',
      ' 5-25-1984',
      ' 1-15-1990',
      NULL,
      ' 8-14-1980',
      '11- 9-1990',
      ' 7-25-1995',
      '10-18-1997',
      ' 9-16-1984',
      ' 1-23-1990',
      '11- 9-1978',
      '10- 0-2000',
      ' 1-14-1999',
      NULL,
      NULL,
      '10-15-1985',
      ' 0-25-1977',
      ' 7-29-1978',
      ' 2-15-1991',
      ' 1-18-1998',
      ' 1- 6-1984',
      ' 0-22-1977',
      ' 7-23-1995',
      ' 1-14-1975',
      ' 5-11-1998',
      ' 4-12-1974',
      ' 4-18-1981',
      ' 6-29-1994',
      ' 7-26-1978',
      '10-24-2002',
      ' 1- 9-1991',
      '10-10-2000',
      NULL,
      ' 0-20-2000',
      ' 1-14-1997',
      ' 5-18-1987',
      ' 7- 5-2003',
      ' 0-27-1976',
      NULL,
      ' 4-12-1988',
      ' 0-19-1974',
      ' 2- 9-1996',
      ' 6-13-2000',
      ' 0- 8-2000',
      ' 5-28-1992',
      ' 3-11-1987',
      ' 2-19-1989',
      ' 4- 2-1974',
      ' 4- 9-1982',
      ' 8-21-2001',
      NULL,
      ' 6-28-1997',
      NULL,
      NULL,
      ' 7-12-1981',
      ' 4- 7-1989',
      ' 4-19-1996',
      ' 0-29-1995',
      ' 9-17-1974',
      ' 4-17-1991',
      NULL,
      ' 0-19-2003',
      ' 4- 4-1983',
      '10- 2-1999',
      ' 5-14-1974',
      ' 4-28-1981',
      ' 9- 6-1984',
      ' 1-21-1993',
      ' 9- 3-1999',
      ' 7-26-1979',
      ' 3-24-2002',
      ' 7- 9-1988',
      NULL,
      '11- 1-1994',
      '11-26-1986',
      ' 1- 1-1990',
      ' 4-20-1974',
      ' 2- 4-1993',
      ' 7-18-2000',
      ' 9-14-1976',
      NULL,
      ' 4- 9-2000',
      NULL,
      ' 3- 8-1994',
      NULL,
      ' 3-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1983',
      ' 0-25-2003',
      ' 1-22-1978',
      ' 3-10-2001',
      ' 1-24-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


