set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '0300114',
      0,
      0,
      0,
      '03304',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.496114,
      0,
      0.112998,
      NULL,
      0,
      3.516419,
      1,
      1.560520,
      1,
      9,
      NULL,
      NULL,
      1,
      2.724451,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      3,
      0.544724,
      2,
      8.075901,
      1,
      NULL,
      NULL,
      0.093049,
      0.314056,
      NULL,
      0,
      0,
      1.661833,
      0.327203,
      2,
      NULL,
      NULL,
      2,
      0,
      5.920130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      67,
      238,
      12338.583948,
      18.472548,
      NULL,
      108.117370,
      31,
      3,
      NULL,
      177.524053,
      3.199315,
      1.473059,
      NULL,
      110,
      31,
      3.673026,
      2,
      252.331913,
      108,
      3.546758,
      1,
      137.355808,
      NULL,
      NULL,
      6,
      182,
      6.170413,
      2.822113,
      0,
      NULL,
      9.641237,
      3,
      2,
      NULL,
      144,
      1.833506,
      0.362688,
      122,
      6.002494,
      0,
      5.796408,
      161.629965,
      NULL,
      NULL,
      3.499360,
      NULL,
      NULL,
      NULL,
      9.330775,
      157,
      NULL,
      2.583473,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      NULL,
      1,
      9,
      195.857686,
      13,
      3,
      0,
      177,
      8.653769,
      3,
      3.514738,
      99.087400,
      62.135246,
      NULL,
      NULL,
      140.865508,
      312.623473,
      2.401542,
      2,
      599,
      4,
      2.138322,
      3,
      NULL,
      0,
      1,
      NULL,
      115.628438,
      79.218866,
      NULL,
      NULL,
      156,
      1.110834,
      0,
      1,
      213,
      59.648893,
      1.075660,
      NULL,
      149,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      NULL,
      1,
      NULL,
      6.672700,
      2.208954,
      NULL,
      128.161191,
      11,
      2.758614,
      8,
      93,
      13,
      NULL,
      3.297062,
      302,
      15.236591,
      0.204736,
      2.461809,
      559,
      1.741617,
      3,
      6.719361,
      54.373101,
      24.790554,
      0,
      NULL,
      722,
      2,
      3,
      4,
      NULL,
      8,
      0,
      2.275023,
      822,
      2.793029,
      3,
      0.536904,
      73,
      NULL,
      0,
      6.722878,
      148,
      115,
      3.452522,
      0.890224,
      205.531371,
      151.168298,
      1,
      NULL,
      226,
      2,
      NULL,
      1,
      20,
      134.643512,
      1,
      7.818492,
      NULL,
      306.804692,
      NULL,
      NULL,
      188,
      309.946141,
      3.526900,
      7,
      65,
      NULL,
      2.851945,
      2.043377,
      166.541197,
      358,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '30022',
      '',
      '',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '3411',
      '23123',
      '',
      4,
      0.331989,
      NULL,
      3,
      NULL,
      1.252758,
      NULL,
      1.400147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886498,
      NULL,
      1.240594,
      NULL,
      0.834566,
      NULL,
      0,
      NULL,
      ' 6-26-1998',
      NULL,
      18,
      0.451004,
      10.065938,
      15.601143,
      10,
      14,
      10,
      5,
      3,
      6,
      NULL,
      8.802921,
      11,
      2,
      5,
      15,
      7.619152,
      NULL,
      1.123149,
      2,
      0.453129,
      5.568551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      16,
      2,
      16.871248,
      NULL,
      29,
      19,
      1,
      20,
      16,
      28.474689,
      25.471417,
      25.562839,
      31,
      22.695545,
      NULL,
      22,
      23.916799,
      31,
      14.932930,
      22,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      0,
      5.552188,
      84,
      6.676566,
      53.985609,
      131.951888,
      NULL,
      105.662749,
      28,
      24,
      57,
      NULL,
      4.382321,
      67.029297,
      NULL,
      15,
      65,
      156,
      NULL,
      150.500245,
      58.673149,
      10.500362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      7,
      4.511949,
      NULL,
      NULL,
      5.693312,
      8,
      6.480696,
      NULL,
      4,
      5.939172,
      2,
      7,
      2,
      2.059816,
      3,
      6,
      2,
      0,
      9,
      6.272627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      3,
      NULL,
      0.465964,
      5,
      10,
      NULL,
      2.261787,
      1,
      0,
      7.509814,
      9.977226,
      3.020537,
      NULL,
      0,
      4.420174,
      NULL,
      NULL,
      3,
      11,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005630,
      4,
      NULL,
      0.706568,
      2,
      3.122287,
      2,
      NULL,
      4.724916,
      NULL,
      4,
      NULL,
      NULL,
      4,
      4,
      6,
      NULL,
      NULL,
      7.548949,
      3.178552,
      8,
      2.725076,
      6.320054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.125370,
      NULL,
      0.640504,
      1,
      2.246641,
      2.020645,
      2.333107,
      0.520029,
      4,
      5,
      3,
      0.682329,
      NULL,
      NULL,
      1.608571,
      1,
      2,
      3,
      0.786028,
      3.082014,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.162504,
      4,
      3.669134,
      2.413669,
      5,
      4,
      4,
      NULL,
      0,
      0.098261,
      2,
      6,
      0,
      0.902211,
      NULL,
      9.250152,
      5.325421,
      1,
      NULL,
      7.986405,
      5.604383,
      0,
      9.791077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.675277,
      6.085166,
      7,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      3.530671,
      NULL,
      NULL,
      NULL,
      1.842918,
      1.954859,
      3,
      1.929969,
      6,
      6.368284,
      3.739385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      6.202945,
      NULL,
      7.943342,
      NULL,
      3,
      NULL,
      7.997646,
      0,
      9.455947,
      9,
      8,
      1,
      8,
      3,
      5.596219,
      6,
      1.996129,
      2,
      0.444085,
      10,
      9.225281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879212,
      0.291107,
      3,
      2,
      5.580371,
      NULL,
      3,
      4,
      7.854401,
      1,
      0,
      6,
      NULL,
      6.091488,
      0.754469,
      4.532749,
      NULL,
      2.277830,
      NULL,
      6.728316,
      4,
      3,
      6.349989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.757132,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      6.298363,
      7,
      2.025055,
      1.571149,
      NULL,
      2,
      6.393618,
      7.149872,
      NULL,
      5,
      NULL,
      7.788026,
      1,
      5.374510,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572595,
      1.729023,
      NULL,
      0.164446,
      1,
      0.092558,
      1.056214,
      NULL,
      0.878277,
      NULL,
      1.818756,
      0.148217,
      NULL,
      0,
      NULL,
      1,
      0.438736,
      1,
      0,
      1,
      0,
      NULL,
      1.130844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.978642,
      1.278396,
      0,
      NULL,
      1,
      1.083668,
      1,
      1,
      0.818975,
      0,
      0.168873,
      1,
      1,
      NULL,
      1.644291,
      1.603592,
      NULL,
      1,
      1,
      NULL,
      0.421901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.379916,
      5.500925,
      NULL,
      1,
      3.874333,
      NULL,
      0.629470,
      3,
      NULL,
      1.098823,
      3.065364,
      3,
      NULL,
      3.295230,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487032,
      4.085561,
      2.614835,
      3,
      5.658160,
      NULL,
      NULL,
      1.485299,
      3,
      1.684633,
      1.787316,
      1.240245,
      0,
      2,
      NULL,
      1,
      NULL,
      2.371867,
      1.326633,
      3.185671,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.099129,
      2,
      1,
      0,
      0,
      5,
      5.220993,
      7,
      5,
      NULL,
      2,
      4.915959,
      7,
      NULL,
      11.381289,
      0,
      9.439994,
      NULL,
      NULL,
      9.127243,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.017676,
      2,
      6,
      0.734204,
      NULL,
      4,
      7.829100,
      NULL,
      5.802162,
      1.816097,
      NULL,
      NULL,
      9,
      8.978165,
      6,
      NULL,
      9,
      7,
      5,
      NULL,
      8,
      5.839437,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555334,
      1,
      1,
      1.716921,
      0.153068,
      0,
      0.824383,
      1.195949,
      1,
      0,
      1.699229,
      0.062242,
      1,
      0,
      NULL,
      1.636211,
      1.498847,
      NULL,
      1.135557,
      0,
      1,
      1.841353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415287,
      1.464026,
      NULL,
      2,
      NULL,
      3.651061,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      1.028816,
      1,
      0.160934,
      3.506031,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      NULL,
      1,
      5,
      2,
      4,
      NULL,
      0,
      NULL,
      2,
      3,
      4,
      0,
      0,
      NULL,
      2,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-2002',
      ' 8- 5-2001',
      ' 6-17-2001',
      NULL,
      ' 3-28-1983',
      ' 3-10-2001',
      NULL,
      ' 4-24-1986',
      ' 1- 8-1990',
      ' 2- 4-1976',
      ' 3-24-1980',
      ' 9- 3-1994',
      ' 8-27-1992',
      ' 7-19-1985',
      ' 6-12-2000',
      NULL,
      ' 7- 5-1992',
      NULL,
      '10-29-1987',
      NULL,
      ' 2-27-1997',
      ' 3-20-2002',
      ' 9-25-1988',
      ' 4-13-1988',
      NULL,
      ' 4-15-1989',
      ' 2-19-2003',
      NULL,
      ' 5-25-1980',
      ' 7-27-2000',
      NULL,
      ' 9-23-1981',
      ' 7-20-1994',
      ' 0-16-1977',
      NULL,
      ' 8-22-1982',
      NULL,
      ' 0-12-1992',
      NULL,
      ' 9- 1-1992',
      ' 4-27-2001',
      ' 4-19-1975',
      '10-20-1986',
      ' 2-28-1976',
      NULL,
      ' 4-28-1995',
      ' 4- 8-2000',
      '11- 6-1987',
      NULL,
      '11-28-2002',
      ' 8-20-1981',
      NULL,
      ' 8-22-1986',
      ' 2-23-2003',
      ' 6-15-1995',
      ' 0-13-1980',
      ' 8-18-1994',
      ' 1-15-1995',
      NULL,
      ' 7-10-1978',
      ' 7-10-1979',
      ' 4-17-1979',
      '10-20-1979',
      ' 0-25-2002',
      ' 9-22-1997',
      '11- 9-2000',
      ' 4-14-1999',
      NULL,
      ' 1- 3-1993',
      ' 9-25-1987',
      ' 3-27-1979',
      ' 9-22-1981',
      ' 4-24-1999',
      ' 6-16-1974',
      '10- 5-1996',
      '10-11-1989',
      ' 1-14-1978',
      ' 7-14-1986',
      ' 0-21-1997',
      ' 5-23-1981',
      NULL,
      ' 2-12-1994',
      ' 6- 1-1984',
      '10-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933204);
commit;
end;
/


