set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7913233';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '4144023',
      0,
      2.912196,
      NULL,
      '01441',
      0.066036,
      ' 4-19-1985',
      36.351178,
      NULL,
      1.095157,
      2,
      NULL,
      1,
      1.989131,
      NULL,
      NULL,
      3.649221,
      0,
      3.448132,
      NULL,
      6,
      NULL,
      NULL,
      1,
      NULL,
      1.332423,
      0.599515,
      9.259616,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      4.309076,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.973570,
      1.629728,
      1.212854,
      1,
      0,
      6.585000,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1.598493,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.465812,
      0,
      0,
      1,
      1.443463,
      3,
      51.019349,
      0.577986,
      64.631483,
      3,
      3.675908,
      NULL,
      8,
      1,
      2,
      6.575754,
      17.656882,
      0.633305,
      2.009149,
      46,
      12,
      1.759207,
      5,
      7,
      65,
      3,
      1,
      16,
      NULL,
      3,
      NULL,
      64.130274,
      22.453832,
      2.326737,
      NULL,
      NULL,
      33.257882,
      3,
      0,
      220,
      NULL,
      4.137870,
      3.565585,
      176.849777,
      7.271935,
      2.390507,
      7.823296,
      NULL,
      NULL,
      3.652540,
      1.558630,
      39,
      NULL,
      2.242543,
      3,
      132.929651,
      NULL,
      5,
      2.537088,
      NULL,
      NULL,
      3.999446,
      1,
      186.439905,
      NULL,
      NULL,
      3,
      27.761169,
      417.882612,
      3,
      1,
      215,
      2,
      2.303832,
      1,
      169,
      NULL,
      2,
      6.679759,
      221.702587,
      NULL,
      NULL,
      6.403546,
      105,
      55.603843,
      NULL,
      NULL,
      28.242672,
      96,
      0,
      3.649789,
      NULL,
      NULL,
      1.690292,
      NULL,
      47,
      161.444514,
      2,
      2,
      NULL,
      46.700470,
      1.544610,
      0.487799,
      NULL,
      NULL,
      1,
      0.942210,
      NULL,
      302.575430,
      0.380351,
      1,
      78.875155,
      NULL,
      3.390122,
      2,
      73.783463,
      4.925151,
      1,
      NULL,
      95.221206,
      133,
      2,
      2.219943,
      87,
      66.894025,
      0,
      0,
      321,
      463,
      NULL,
      0.400246,
      99.831372,
      149,
      2.939029,
      NULL,
      NULL,
      20,
      NULL,
      2.493302,
      329,
      1068,
      0.191722,
      0,
      NULL,
      2,
      2,
      2,
      NULL,
      50,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.515935,
      '12000',
      '33412',
      '04031',
      '02234',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      33,
      NULL,
      1.181398,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5,
      1795,
      NULL,
      NULL,
      1.209544,
      255,
      0,
      NULL,
      ' 3-19-1978',
      8.022804,
      12,
      6.748528,
      7,
      NULL,
      12,
      3,
      6,
      21.727154,
      5,
      7.011991,
      3.169054,
      NULL,
      0,
      4.201440,
      8,
      8.003343,
      2,
      0,
      15.823703,
      3.714333,
      3.764379,
      4.021399,
      NULL,
      4.477578,
      0.127494,
      17,
      9.575129,
      16.818982,
      NULL,
      4.966577,
      2.848753,
      1.938349,
      5.262656,
      1.526428,
      4.620884,
      15,
      4.332401,
      3.108510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.041473,
      2,
      2.691058,
      0.250962,
      19,
      5,
      1,
      11.764348,
      7,
      2,
      9,
      NULL,
      2,
      35.113986,
      5.134424,
      NULL,
      33,
      20.469899,
      3,
      20.118443,
      NULL,
      NULL,
      1,
      10,
      18,
      7,
      1.117962,
      2,
      16.188895,
      22.772448,
      11,
      33.134861,
      11.045471,
      39.596556,
      NULL,
      11.850237,
      25.482795,
      2.287703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.221154,
      80.701830,
      128.433506,
      122.170890,
      72,
      61,
      12.903962,
      NULL,
      NULL,
      38,
      45.436181,
      NULL,
      30,
      86.788538,
      NULL,
      33,
      121,
      98,
      98,
      88.899170,
      17,
      NULL,
      108,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      100,
      43.837014,
      3.660883,
      172.836882,
      141.853758,
      49,
      77,
      137,
      119.296808,
      43,
      25.322054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218088,
      NULL,
      2.191958,
      2.857747,
      NULL,
      4,
      4,
      NULL,
      NULL,
      7,
      1,
      3,
      NULL,
      5,
      2,
      8,
      0,
      8.151095,
      2.076748,
      7.284474,
      0,
      2.339926,
      4.043952,
      1,
      3.498785,
      1,
      2,
      NULL,
      3,
      5.221084,
      4.829387,
      2.990076,
      5.187135,
      NULL,
      2,
      2.888383,
      5.272628,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296599,
      1.116529,
      1.314570,
      0.767396,
      NULL,
      1.643499,
      1,
      1.125745,
      1.240990,
      0,
      NULL,
      0.359573,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.966231,
      NULL,
      NULL,
      0,
      1,
      0.528434,
      1.304816,
      1,
      0.868736,
      NULL,
      NULL,
      0.565749,
      NULL,
      1,
      1.773862,
      1.272005,
      NULL,
      0.075648,
      0,
      1.314427,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.118470,
      2.071649,
      NULL,
      NULL,
      4.054697,
      0,
      3,
      2.775507,
      0.281957,
      3.166715,
      4.039394,
      3,
      2.504687,
      3.174462,
      2,
      0.406337,
      6.839987,
      2,
      NULL,
      NULL,
      5,
      3.397162,
      7.164283,
      0.537280,
      4.162566,
      2.390257,
      2.723805,
      2,
      3,
      2,
      0,
      1,
      3,
      1,
      0,
      NULL,
      1.152201,
      1.747883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490159,
      0,
      0.718688,
      0,
      6.023921,
      1,
      1.709273,
      NULL,
      1,
      2,
      NULL,
      4.291600,
      1,
      NULL,
      0.695405,
      4.749783,
      0.869541,
      1.849932,
      1,
      0,
      NULL,
      4.117986,
      NULL,
      2.148367,
      NULL,
      4,
      2,
      5.583011,
      NULL,
      2.729182,
      0,
      0,
      1,
      0.247622,
      0.516239,
      NULL,
      0,
      0.384844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743676,
      0,
      1.497388,
      1.169131,
      1.734220,
      0,
      0,
      NULL,
      1,
      0.376658,
      NULL,
      NULL,
      1,
      NULL,
      2.594292,
      NULL,
      2.881623,
      NULL,
      0,
      0.448686,
      1.321583,
      4.932566,
      4.507305,
      4,
      3,
      1.199773,
      2,
      NULL,
      NULL,
      2.555876,
      1.131764,
      NULL,
      1,
      2.294485,
      3.073066,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.988389,
      NULL,
      1.621017,
      NULL,
      1.577537,
      1,
      NULL,
      0.484148,
      NULL,
      0.425745,
      1.936218,
      NULL,
      0,
      NULL,
      1,
      2.835454,
      3,
      1.601129,
      NULL,
      3,
      4,
      3,
      2,
      5.955559,
      4,
      1,
      1,
      4.883745,
      6.844996,
      NULL,
      8.979670,
      NULL,
      NULL,
      7.958791,
      NULL,
      9.648673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.685951,
      2.337206,
      0,
      1.843225,
      0.812160,
      NULL,
      0,
      2,
      1.300008,
      1,
      2,
      NULL,
      1.586476,
      3,
      1.109302,
      0,
      1,
      0.466202,
      0,
      0.585786,
      1,
      4.965730,
      2.366970,
      7.450833,
      0,
      4,
      5.717812,
      3,
      0,
      NULL,
      NULL,
      1.497614,
      0,
      2.141281,
      NULL,
      3.105002,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532199,
      3.341242,
      1,
      0,
      NULL,
      0,
      1,
      1,
      3,
      0.040310,
      1,
      0,
      2.340395,
      0,
      NULL,
      NULL,
      3.171830,
      NULL,
      2,
      1.031957,
      1,
      2.579451,
      0,
      0,
      7,
      4.834899,
      NULL,
      0.838180,
      1.838228,
      6,
      NULL,
      1.279105,
      3,
      1,
      3.467334,
      NULL,
      5,
      5.960756,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.591462,
      1.830759,
      0,
      1,
      0.058900,
      1,
      1.702950,
      0,
      2,
      0,
      NULL,
      2.553964,
      NULL,
      0,
      0.151090,
      5.989969,
      1.991892,
      3.832204,
      2,
      NULL,
      3,
      3,
      5,
      0,
      3.228948,
      1.219773,
      2,
      1,
      1.851470,
      2.899905,
      2,
      2.694735,
      NULL,
      1.112556,
      7.665088,
      7.128447,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.323978,
      NULL,
      3.602150,
      2,
      5,
      3.783958,
      3.003178,
      2.085273,
      NULL,
      7.821325,
      NULL,
      6.233908,
      NULL,
      10.356425,
      NULL,
      0,
      NULL,
      6,
      3.863751,
      5,
      1.348097,
      8.236101,
      6,
      7,
      1.887581,
      1,
      0.066455,
      7,
      7,
      0,
      0,
      6.998410,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.628232,
      1.011301,
      0.594180,
      NULL,
      1.417113,
      1.195513,
      0.975586,
      0,
      1,
      1,
      1.085828,
      0.910750,
      1.439289,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.835220,
      0.083248,
      0,
      0.195519,
      1,
      0,
      0.251120,
      1,
      NULL,
      1.330348,
      1,
      1.851536,
      1,
      0.046241,
      1,
      0.589169,
      0.013027,
      NULL,
      1.294108,
      1.693820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.244843,
      1.960494,
      1.926055,
      1,
      NULL,
      NULL,
      1,
      1,
      0.522098,
      NULL,
      1,
      0.965616,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.661197,
      NULL,
      1,
      1,
      1,
      0.654159,
      NULL,
      NULL,
      0.578771,
      0.804330,
      0.245974,
      0.338648,
      1,
      1.554063,
      0.113331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.949008,
      1.442986,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.852713,
      NULL,
      1.688653,
      0.018387,
      1.096791,
      1,
      1,
      1,
      1.754379,
      0.528752,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.739864,
      0,
      1,
      1.322288,
      0.140161,
      1.490963,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.882071,
      0.968754,
      0,
      5,
      4,
      2.568939,
      NULL,
      4.558747,
      8.872311,
      5,
      0,
      NULL,
      4,
      4,
      9,
      NULL,
      NULL,
      3,
      7,
      1.813771,
      5,
      5.457906,
      6,
      2.866663,
      5,
      2.163728,
      5,
      0.564252,
      NULL,
      0.500040,
      2,
      0.452165,
      2,
      0,
      NULL,
      1,
      0.797166,
      1.383904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740531,
      1,
      1.487976,
      1.447095,
      0.676506,
      0,
      3,
      1.361803,
      1.199341,
      2,
      3,
      1.486654,
      2,
      2.681724,
      3,
      4,
      2,
      NULL,
      2,
      3.740198,
      3,
      0.820850,
      NULL,
      7.479422,
      4,
      4,
      1.068313,
      NULL,
      5,
      7,
      4,
      1.499897,
      7.479141,
      NULL,
      NULL,
      4,
      6.000847,
      NULL,
      5.674300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.910248,
      NULL,
      1.028922,
      1.394963,
      0.762070,
      1.640298,
      0.562677,
      1,
      0.897707,
      1,
      0.728612,
      0,
      1.461867,
      NULL,
      0.008862,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.184412,
      NULL,
      0.287728,
      1,
      0,
      0,
      0.623044,
      1,
      0.960058,
      0.687993,
      NULL,
      1.792297,
      NULL,
      1.398240,
      0,
      1,
      0.204030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520889,
      0,
      0.130354,
      1.376146,
      1,
      0.322324,
      0.025910,
      0,
      0,
      0,
      0.733254,
      1,
      1.415404,
      0,
      0.494252,
      NULL,
      1,
      0,
      1,
      0.504089,
      NULL,
      0.216682,
      1.175593,
      1.358454,
      NULL,
      1.064140,
      0.288889,
      0.803066,
      1.541395,
      0.022872,
      1.989059,
      NULL,
      0.508356,
      NULL,
      NULL,
      0,
      1.620138,
      1.862921,
      1.395971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1,
      0,
      5,
      1,
      0,
      0,
      2,
      0,
      4,
      1,
      NULL,
      0,
      1,
      0,
      2,
      1,
      7,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      5,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      NULL,
      6,
      1,
      6,
      0,
      0,
      NULL,
      0,
      6,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      6,
      1,
      3,
      0,
      6,
      1,
      0,
      0,
      4,
      0,
      4,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      1,
      2,
      0,
      2,
      1,
      1,
      3,
      3,
      NULL,
      0,
      4,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      3,
      1,
      3,
      5,
      NULL,
      3,
      NULL,
      2,
      3,
      0,
      2,
      5,
      2,
      2,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.909890,
      1,
      2,
      0,
      0,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      2,
      1,
      1,
      2,
      3,
      3,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      3,
      2,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 6-1985',
      ' 1-23-2003',
      ' 3- 3-1989',
      ' 6-23-1979',
      ' 5- 8-2001',
      NULL,
      ' 4-17-1990',
      ' 5-20-1982',
      '10-29-1988',
      NULL,
      ' 2-18-2000',
      NULL,
      ' 8- 5-1985',
      ' 2-23-2002',
      NULL,
      NULL,
      ' 8-26-1985',
      NULL,
      '11-28-1993',
      '11- 5-1974',
      NULL,
      ' 3-24-1989',
      NULL,
      ' 2-24-2000',
      ' 6-27-2003',
      ' 1- 5-2000',
      ' 8-12-1997',
      ' 5-19-2003',
      ' 8- 5-2001',
      ' 3- 8-1976',
      '11-24-1986',
      ' 7- 7-1987',
      ' 1-29-1983',
      '11- 8-2001',
      NULL,
      ' 0-13-1979',
      ' 5- 9-1996',
      '10-18-2001',
      NULL,
      ' 1-25-1987',
      '10- 5-1985',
      NULL,
      ' 7-10-1985',
      NULL,
      ' 0- 3-1978',
      ' 6-27-1981',
      ' 8-12-1974',
      '10-12-1997',
      ' 5-26-1988',
      ' 3- 9-1999',
      '10-23-1974',
      '10-28-1982',
      ' 1-16-1991',
      ' 3- 4-2002',
      ' 7-21-1985',
      ' 1-20-1998',
      ' 4-25-1989',
      '10- 5-1985',
      ' 5-26-1984',
      ' 4-29-1992',
      '10-22-2000',
      ' 7- 1-1974',
      ' 0-21-1992',
      NULL,
      ' 7- 0-1980',
      ' 0-19-2003',
      ' 6-18-1986',
      ' 5-10-1974',
      NULL,
      ' 6-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1984',
      NULL,
      ' 0-11-1982',
      NULL,
      '11-28-1992',
      ' 2-18-1993',
      ' 3-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


