set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '1113420',
      3,
      0.927984,
      2,
      '22102',
      2.621897,
      ' 6- 2-1981',
      72,
      NULL,
      0,
      1,
      3,
      0,
      1,
      3,
      0.808181,
      3.916407,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4.786976,
      NULL,
      NULL,
      7,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      7,
      5,
      4,
      0,
      1,
      NULL,
      6,
      NULL,
      5,
      NULL,
      0.305825,
      0,
      NULL,
      NULL,
      3,
      1.229794,
      4,
      7.075689,
      NULL,
      6.309400,
      6,
      8.009919,
      7,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      613.692965,
      32,
      2.758297,
      NULL,
      116.983285,
      6.219583,
      0.163956,
      2.606285,
      160.635298,
      NULL,
      3.682110,
      2.343716,
      136,
      17,
      NULL,
      1,
      108.745674,
      NULL,
      1,
      2.205453,
      171.496617,
      21.763588,
      1.854409,
      0.200941,
      NULL,
      2,
      NULL,
      0.198380,
      509.216772,
      20,
      0.997552,
      0,
      145,
      17.818115,
      0.151632,
      5.767242,
      NULL,
      NULL,
      0.833448,
      3,
      74.796434,
      3.184780,
      1.594329,
      4.197360,
      NULL,
      144.579277,
      3,
      3,
      813.587983,
      3.369017,
      0,
      2.204267,
      154.072669,
      173.986643,
      NULL,
      2.858949,
      106,
      18.123926,
      2,
      0,
      328,
      NULL,
      0.266691,
      7.293944,
      26,
      NULL,
      2,
      0.841910,
      143,
      7,
      NULL,
      4.776323,
      387.304779,
      8.619178,
      NULL,
      4.095799,
      NULL,
      2.286366,
      0.924727,
      3,
      660,
      1.283802,
      0,
      7.967306,
      568.860023,
      1.754901,
      2,
      1,
      NULL,
      3625.775418,
      3.940909,
      1,
      243,
      3.695307,
      2,
      4,
      109,
      NULL,
      3,
      2,
      13.431896,
      27,
      1,
      0.624091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.493131,
      '31411',
      '41114',
      '',
      '',
      '',
      '',
      0.881065,
      '',
      '',
      '',
      0,
      '23441',
      NULL,
      NULL,
      1,
      0,
      39.503497,
      0,
      NULL,
      0.798832,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.962783,
      NULL,
      1,
      NULL,
      1,
      NULL,
      ' 8- 1-1984',
      9,
      7,
      NULL,
      1.667186,
      3.139195,
      NULL,
      10,
      NULL,
      NULL,
      2,
      6.114406,
      2,
      4,
      3,
      NULL,
      1,
      5.707967,
      NULL,
      3,
      7,
      10.005927,
      4.520460,
      3.009437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      25.908690,
      30.984932,
      1,
      9,
      11.995696,
      NULL,
      2.349683,
      1.576661,
      5.198492,
      NULL,
      NULL,
      1.311303,
      28,
      10,
      13,
      41.414704,
      3,
      NULL,
      18.869087,
      0.111357,
      45,
      3.925454,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      97.134136,
      56,
      120,
      93,
      82,
      84.633849,
      82,
      NULL,
      NULL,
      63,
      137,
      32.561599,
      1.483221,
      105,
      NULL,
      41,
      145.047723,
      57.575592,
      131,
      NULL,
      94,
      97,
      156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      5.367284,
      8.397771,
      4,
      1.681613,
      1,
      8.175188,
      2,
      6.330896,
      NULL,
      1,
      8,
      2.233144,
      1.280910,
      2.936177,
      5,
      NULL,
      3.952409,
      NULL,
      3.718564,
      1.533894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235323,
      1.610520,
      NULL,
      NULL,
      0.462166,
      0,
      0,
      NULL,
      5,
      0,
      0.623380,
      0,
      0,
      NULL,
      0.208195,
      0.942177,
      NULL,
      0,
      1.796452,
      1,
      1.723617,
      1.569540,
      0.081425,
      0.139252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.573481,
      0,
      1.469888,
      7.118607,
      1,
      NULL,
      1,
      1,
      2.671803,
      NULL,
      8,
      8.555400,
      1.064008,
      4,
      NULL,
      0.608126,
      0.840431,
      3.994491,
      1.221536,
      5,
      NULL,
      3,
      1.823225,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744075,
      1,
      1,
      0,
      NULL,
      1.897391,
      1,
      1.718274,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1.093833,
      0.410756,
      4,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.082771,
      1,
      1.083891,
      1.365564,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0.260834,
      1,
      NULL,
      4,
      0,
      5.279449,
      7,
      1.212560,
      1,
      0.482151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377681,
      1,
      1,
      1.666289,
      NULL,
      0,
      0.347557,
      0,
      1.000447,
      0,
      NULL,
      1.933258,
      NULL,
      1,
      NULL,
      7.998673,
      3.071555,
      0.880403,
      7,
      NULL,
      0.495412,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.035449,
      0,
      NULL,
      NULL,
      0.838613,
      0.980350,
      0.433001,
      1,
      0.295960,
      0,
      0,
      0,
      1,
      NULL,
      9,
      0.779182,
      NULL,
      0.897924,
      NULL,
      NULL,
      5.988188,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634348,
      0.273724,
      NULL,
      4.079391,
      3.258820,
      NULL,
      0.285498,
      1,
      NULL,
      NULL,
      NULL,
      1.848865,
      5,
      3.817916,
      4,
      5.023977,
      1,
      NULL,
      3.559007,
      4.823357,
      7.606912,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.325064,
      1.171372,
      1,
      NULL,
      1,
      1.931778,
      1.531050,
      NULL,
      1.352446,
      0.530861,
      NULL,
      NULL,
      1,
      NULL,
      0.199394,
      NULL,
      NULL,
      NULL,
      0.027798,
      5.166833,
      NULL,
      4.214748,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700792,
      1,
      0.937760,
      1.120002,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0.828209,
      1,
      1.372795,
      1.327503,
      0.138346,
      0.017474,
      0,
      1.746138,
      NULL,
      0.115262,
      0,
      1.862037,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574033,
      0.924736,
      NULL,
      0,
      1.129093,
      1.278739,
      1.387892,
      0,
      0,
      NULL,
      0.411564,
      1.260023,
      1,
      0.056083,
      0,
      NULL,
      1.300411,
      0,
      1,
      NULL,
      0.769413,
      1,
      1.239079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.605070,
      0,
      0.949143,
      1,
      NULL,
      0,
      4.136102,
      NULL,
      7.889940,
      1,
      NULL,
      5,
      NULL,
      NULL,
      1,
      4.744345,
      1.826383,
      1.411509,
      NULL,
      4,
      3.251084,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.548101,
      0.872273,
      0,
      1.487166,
      1.493682,
      3.822474,
      8.917666,
      0,
      2.692074,
      1,
      0.641281,
      1,
      2.777117,
      3.484176,
      1,
      NULL,
      NULL,
      2.086977,
      0,
      NULL,
      2,
      1,
      5.199724,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.822958,
      0.859058,
      3,
      7.841500,
      6.748105,
      4.185239,
      5.576927,
      5,
      NULL,
      0.734511,
      5,
      3.500475,
      NULL,
      1.145014,
      0.164210,
      1.116107,
      0,
      NULL,
      0.949043,
      0,
      1.522817,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.198637,
      5,
      3,
      NULL,
      0.089831,
      1.552460,
      1,
      1.197185,
      NULL,
      1,
      1,
      1.985777,
      0.164987,
      5,
      4,
      5.962351,
      NULL,
      0,
      0.180653,
      5,
      0.458801,
      3.771610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.849573,
      NULL,
      1.896744,
      NULL,
      1,
      1.335538,
      1.803897,
      1.965991,
      1.458753,
      1.857548,
      0.416783,
      0.141843,
      0.712956,
      1.176329,
      0,
      0.118858,
      1,
      0.452689,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033232,
      1.465945,
      1.549323,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      2.933173,
      0,
      3,
      3,
      2.894117,
      1.576724,
      0.076396,
      0,
      5,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      6,
      3,
      3,
      2,
      4,
      3,
      1,
      NULL,
      0,
      3,
      1,
      2,
      2,
      NULL,
      4,
      NULL,
      4,
      2,
      0,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-23-1979',
      NULL,
      NULL,
      ' 0-26-1977',
      ' 1-29-1992',
      NULL,
      ' 4-27-1981',
      ' 5- 1-1974',
      ' 0-14-1980',
      ' 1-10-1989',
      ' 6-13-1997',
      ' 7- 9-1974',
      NULL,
      '11- 6-1992',
      ' 2- 1-1984',
      ' 5-17-1979',
      ' 3-12-1982',
      NULL,
      '10- 3-1995',
      ' 9- 3-1975',
      ' 4-14-1987',
      ' 8- 9-1998',
      NULL,
      '11-24-1996',
      NULL,
      ' 0- 5-1984',
      NULL,
      ' 4-18-1989',
      ' 7-18-1986',
      NULL,
      NULL,
      '10-10-1998',
      ' 6- 8-1995',
      NULL,
      '10-24-1974',
      ' 4-17-1977',
      ' 9-14-1977',
      ' 1-15-1979',
      ' 9- 2-1998',
      '10-21-1979',
      ' 8-18-1981',
      ' 2-26-1998',
      ' 2-22-1984',
      ' 1-13-1997',
      ' 8-16-1999',
      ' 2-14-1997',
      NULL,
      '11- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1977',
      ' 6-17-2001',
      ' 3-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817066);
commit;
end;
/


