set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '1041211',
      2,
      NULL,
      0,
      '33030',
      3.312552,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      0.570224,
      0.716289,
      1,
      NULL,
      1,
      3,
      NULL,
      1.657968,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.930363,
      26.332319,
      NULL,
      6,
      3,
      NULL,
      3.414603,
      NULL,
      0.911167,
      NULL,
      NULL,
      NULL,
      3,
      7,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      6,
      5,
      5,
      2.408013,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1.143981,
      NULL,
      12.123763,
      6,
      3.910088,
      NULL,
      0.319081,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      86,
      86.197262,
      3,
      NULL,
      92,
      1,
      2.397120,
      NULL,
      41,
      NULL,
      0,
      3,
      NULL,
      2.049894,
      2.498492,
      0.233868,
      208.022303,
      NULL,
      3,
      0.396370,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.746546,
      1,
      1,
      NULL,
      2.461771,
      1.009050,
      0.986516,
      70,
      88,
      2.625385,
      3,
      795,
      3.036513,
      1,
      2.609341,
      138,
      NULL,
      2.907254,
      0.755257,
      324.257739,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.649296,
      107.650473,
      1,
      1,
      3.855138,
      NULL,
      16,
      1.517578,
      2,
      127,
      131,
      0.626342,
      3.051567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '41004',
      '',
      '',
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.036231,
      '',
      '',
      NULL,
      5,
      0,
      NULL,
      2.394420,
      1202.958488,
      1.715844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292030,
      NULL,
      1.044907,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.429151,
      NULL,
      ' 3- 9-1974',
      12.933544,
      11,
      2.603918,
      5.749026,
      NULL,
      NULL,
      NULL,
      6,
      7,
      NULL,
      NULL,
      14,
      NULL,
      12.713011,
      NULL,
      21,
      18.551796,
      21,
      11.966410,
      1.754908,
      2,
      9.182197,
      NULL,
      3.169017,
      11,
      13.819676,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.842413,
      27.499968,
      NULL,
      29,
      19.941913,
      28,
      11,
      3.624639,
      24,
      NULL,
      4.902189,
      15.057292,
      44,
      0,
      NULL,
      NULL,
      17.164999,
      26.491747,
      22.820490,
      4.933146,
      NULL,
      4,
      0,
      3,
      1,
      35,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.688416,
      21,
      98.598849,
      88,
      85.466998,
      NULL,
      110.556970,
      NULL,
      NULL,
      NULL,
      48,
      107,
      NULL,
      111.945919,
      42.728467,
      166.103216,
      64.045448,
      NULL,
      77.347955,
      61,
      106.573931,
      38.004150,
      145.458153,
      89.469756,
      180.106427,
      165.632067,
      53.919182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      4,
      NULL,
      0.749129,
      7.424266,
      4,
      5.385948,
      3.130314,
      7.436326,
      0.918102,
      9.207991,
      6.965495,
      NULL,
      1.055596,
      NULL,
      5,
      7.249971,
      NULL,
      7.678945,
      NULL,
      NULL,
      NULL,
      NULL,
      6.508261,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.779655,
      4,
      NULL,
      4,
      6,
      5,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.030752,
      6,
      5,
      5,
      7,
      2.277428,
      2.434786,
      2.433794,
      1.841153,
      NULL,
      3,
      2.174676,
      5,
      4.364171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.204237,
      3,
      5.773122,
      NULL,
      3,
      NULL,
      0.299304,
      5,
      4.867901,
      NULL,
      6,
      0,
      NULL,
      4.980860,
      1.376407,
      0.342523,
      5.155888,
      8,
      4,
      2.682267,
      5,
      7.680840,
      5,
      5,
      9,
      4.476644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.544464,
      1.511687,
      0.283539,
      2,
      0.438691,
      1.038295,
      1,
      0,
      5.606745,
      3.846534,
      3.043073,
      1.051123,
      5,
      0.835288,
      NULL,
      3,
      1.697807,
      0.580720,
      5.919779,
      2.842267,
      5,
      5,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.279999,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      1,
      3.189438,
      0,
      0.319589,
      2.601907,
      7,
      5,
      4.076887,
      0.607307,
      5,
      1.733502,
      2,
      NULL,
      3.251686,
      6,
      1.216988,
      1.591101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.944905,
      1.918557,
      2.403842,
      3.559616,
      0.628691,
      2.025603,
      1.949405,
      NULL,
      5.347172,
      11.440615,
      2,
      2.771011,
      4.628775,
      6.454442,
      NULL,
      3,
      0,
      7,
      0,
      2,
      1.364702,
      3,
      11.406612,
      NULL,
      9.615315,
      2.166738,
      0.663711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      3.531987,
      4.077962,
      6.639721,
      0,
      9.086436,
      0,
      7.512311,
      4.539903,
      1,
      5.443858,
      NULL,
      4.416239,
      4.865139,
      2.906632,
      9,
      NULL,
      7.640959,
      8,
      3.509345,
      4.314593,
      8.201260,
      NULL,
      7,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885720,
      0,
      5,
      4,
      0,
      1,
      NULL,
      3.334814,
      6,
      NULL,
      7.820232,
      4,
      7.501548,
      3.532050,
      1.405377,
      5,
      7.360349,
      1,
      6,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.357774,
      5.327777,
      4.091667,
      2,
      5.598412,
      NULL,
      5.162560,
      2,
      9,
      NULL,
      7.894196,
      NULL,
      7.646651,
      NULL,
      4,
      NULL,
      NULL,
      7.573472,
      4,
      3,
      6.609334,
      6.472183,
      5.438415,
      0,
      4,
      1.665323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      5,
      5.992095,
      4,
      4,
      0.924701,
      3,
      NULL,
      1.360458,
      4.040625,
      NULL,
      2.714986,
      NULL,
      4.658613,
      1.665110,
      NULL,
      2,
      4,
      2,
      1,
      0,
      4,
      4,
      0,
      7.684677,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.092157,
      0,
      1.464148,
      0.671719,
      0.146122,
      0,
      0,
      NULL,
      0.912791,
      1.690272,
      0.239733,
      0.121374,
      1,
      0,
      0,
      NULL,
      NULL,
      1.541443,
      0.794775,
      0.221321,
      1,
      1.443165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.560051,
      1.761245,
      NULL,
      3,
      1,
      NULL,
      5.184897,
      2.996199,
      4,
      6,
      1,
      2,
      4.287004,
      3,
      4.045122,
      0.247230,
      NULL,
      0.464723,
      0.810244,
      0.506076,
      NULL,
      0.075451,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.556061,
      1,
      0.659383,
      0,
      0,
      0.764755,
      3,
      0,
      NULL,
      1.614586,
      1.762173,
      1,
      0,
      NULL,
      1.904156,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.706374,
      1,
      1.752928,
      NULL,
      1.256464,
      0.169906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      2.567569,
      3.390240,
      NULL,
      NULL,
      8,
      NULL,
      1.667487,
      3.776139,
      NULL,
      6.548957,
      7.060586,
      4.538108,
      6.382578,
      0,
      0,
      9.440190,
      1.195294,
      1.618772,
      7,
      3,
      1.177366,
      6,
      3.367562,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.977338,
      NULL,
      0.686620,
      0,
      8.192539,
      5.802094,
      2,
      4.449444,
      4.275245,
      NULL,
      9.062065,
      5.794389,
      NULL,
      NULL,
      3.560282,
      2,
      NULL,
      2.921258,
      5.820683,
      5,
      2.110647,
      4,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.249750,
      0,
      NULL,
      0.179982,
      1.458189,
      0.039656,
      1,
      NULL,
      1,
      NULL,
      1,
      0.996941,
      0.177664,
      1.807741,
      NULL,
      0,
      1.430088,
      1,
      0.044364,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657133,
      1,
      0.691212,
      0,
      1,
      NULL,
      5.262713,
      3.017836,
      0.552329,
      0,
      NULL,
      5,
      NULL,
      NULL,
      1,
      5,
      NULL,
      3.158143,
      1.099466,
      1,
      1.583449,
      0,
      1,
      1.043780,
      NULL,
      1.180397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      4,
      1,
      3,
      1,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      NULL,
      2,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      1,
      0,
      3,
      0,
      3,
      0,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      0,
      2,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      2,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      2,
      3,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1992',
      NULL,
      ' 3-11-1993',
      ' 2-23-1995',
      NULL,
      ' 6- 8-2001',
      ' 3-16-1993',
      ' 6-26-1998',
      '10- 1-1992',
      ' 1-16-2002',
      NULL,
      NULL,
      ' 7-23-2001',
      '10-27-1984',
      ' 7-25-1992',
      NULL,
      NULL,
      ' 7-27-1996',
      ' 4-17-1978',
      ' 7-17-1998',
      ' 3-24-1981',
      ' 3- 4-1990',
      NULL,
      NULL,
      ' 5- 9-2001',
      '10- 8-2002',
      ' 3-19-2000',
      '10-19-1995',
      NULL,
      ' 7- 2-1990',
      ' 8-29-1981',
      ' 1-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712178);
commit;
end;
/


