set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '0030322',
      3,
      0,
      2,
      '04123',
      0,
      ' 0-13-1992',
      16,
      NULL,
      1.473532,
      1,
      3.540789,
      1,
      1.650240,
      NULL,
      1,
      3,
      0,
      0.762564,
      0.090330,
      9,
      NULL,
      NULL,
      2,
      NULL,
      1.269331,
      34.464472,
      13.760682,
      6,
      1,
      NULL,
      4.535056,
      6,
      2.681953,
      NULL,
      2,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      0,
      0,
      0,
      1,
      4,
      6.060980,
      1,
      1.293879,
      2,
      1.216540,
      NULL,
      0.328451,
      NULL,
      2,
      0,
      6.915421,
      0.243425,
      8,
      0,
      1,
      5,
      1.870553,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.974633,
      0.002169,
      0,
      NULL,
      3,
      0,
      0,
      7.975655,
      145.014793,
      NULL,
      1.724349,
      NULL,
      109,
      11.920076,
      3.671665,
      NULL,
      205.628708,
      94,
      3,
      6,
      36,
      7,
      0,
      0.464237,
      65,
      0,
      NULL,
      0,
      NULL,
      163.293591,
      NULL,
      9.715429,
      216.884066,
      0.483689,
      3.439144,
      1.109025,
      NULL,
      89,
      3.265925,
      1.714174,
      340.119483,
      25,
      3,
      6,
      134.564697,
      3,
      1.203544,
      NULL,
      248,
      2.353532,
      2,
      6.817027,
      104.234014,
      6,
      2.267229,
      NULL,
      4.192863,
      4.504838,
      0.284319,
      3,
      58.056778,
      3,
      1,
      1.629095,
      23.910426,
      10,
      3,
      6,
      77.985381,
      6,
      1.480875,
      1,
      NULL,
      72.435164,
      0.715042,
      3.378528,
      155,
      NULL,
      3.368951,
      7.025632,
      219.314333,
      4.653840,
      1.090597,
      NULL,
      229.956471,
      5.143430,
      0,
      1.016139,
      178,
      13,
      2,
      3.790666,
      462,
      11.899171,
      NULL,
      4,
      269.483641,
      0,
      2,
      2,
      1234.209213,
      23,
      1.873320,
      1.320856,
      240,
      6,
      2.815303,
      3.285555,
      323.702161,
      73,
      NULL,
      0.873115,
      11.874222,
      NULL,
      3.151070,
      7.613000,
      72,
      18,
      3.838514,
      1.004162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650902,
      NULL,
      '',
      '',
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      5.384237,
      19,
      NULL,
      NULL,
      0.307574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.362482,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 1-14-1980',
      15.953406,
      21,
      0,
      13.696695,
      13.920512,
      1.959641,
      NULL,
      9.812302,
      13.029475,
      6.990433,
      6,
      4.988206,
      14.071646,
      16,
      18.770595,
      17.777038,
      5,
      NULL,
      11.736035,
      1,
      13,
      14.661347,
      11.508113,
      16.541587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      14.420411,
      NULL,
      29.522207,
      25,
      14,
      32,
      36.772159,
      7.844784,
      5,
      31.205036,
      7.416910,
      17,
      46,
      8.820119,
      NULL,
      7.475558,
      NULL,
      14,
      21.943191,
      NULL,
      16,
      2.163006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.620134,
      NULL,
      NULL,
      67.975842,
      NULL,
      32.626815,
      7.784937,
      19,
      NULL,
      123,
      19.061942,
      88,
      19.682207,
      141,
      NULL,
      11,
      34.983380,
      147,
      NULL,
      96,
      101.478294,
      190,
      NULL,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.099015,
      NULL,
      1,
      2.285544,
      7,
      9.794974,
      6,
      3.352819,
      0.927723,
      0,
      2.646431,
      2.837630,
      3,
      NULL,
      1,
      NULL,
      4.986406,
      8.644589,
      6.294455,
      3.297637,
      NULL,
      3,
      3.569562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938946,
      3,
      1,
      0.861228,
      NULL,
      0,
      1,
      1.951255,
      1,
      1,
      NULL,
      1,
      1.245031,
      1,
      0,
      0,
      0.777118,
      0,
      0,
      0.051632,
      0.137838,
      1.091708,
      1.340304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.658210,
      NULL,
      NULL,
      4,
      2,
      2,
      0,
      0.642060,
      NULL,
      NULL,
      4.461449,
      0.796255,
      0.834761,
      3.045175,
      1.199461,
      NULL,
      0,
      1,
      0.718597,
      1.123476,
      0.653313,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.147183,
      5.647763,
      NULL,
      4,
      5,
      10,
      NULL,
      NULL,
      4,
      4,
      6,
      5.501161,
      1,
      0.273713,
      2,
      NULL,
      3.255519,
      NULL,
      6,
      0,
      NULL,
      0.874593,
      2.309142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.062624,
      0.015704,
      2.649533,
      0,
      0.308563,
      5.390709,
      0,
      4,
      NULL,
      0.014828,
      0.615507,
      0.254610,
      NULL,
      1,
      2,
      2,
      1.941032,
      1,
      1.718162,
      1.889887,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      1.463528,
      4,
      5.252461,
      3,
      7.235074,
      4.453398,
      0,
      1,
      6,
      1,
      1.541516,
      2,
      1,
      2,
      NULL,
      0.901534,
      2.624361,
      1,
      7.480083,
      5.958413,
      5.096944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.673831,
      NULL,
      0,
      NULL,
      3,
      2,
      NULL,
      7.149297,
      4.583219,
      0.912392,
      NULL,
      4.341761,
      0.761623,
      2.772548,
      1.021198,
      2,
      6,
      NULL,
      NULL,
      3.491534,
      4.019310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.510853,
      3.759541,
      0.746544,
      1,
      1.015205,
      0.933699,
      1.399751,
      NULL,
      0.636652,
      1,
      NULL,
      2.758117,
      2.122289,
      NULL,
      4.418719,
      4,
      0.409652,
      7,
      NULL,
      0,
      2.338243,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453506,
      4.252516,
      1,
      3.210634,
      2.530727,
      3.723034,
      2,
      2.598735,
      0,
      NULL,
      0,
      1.865493,
      0.601258,
      3,
      3,
      2.106436,
      0,
      2.168985,
      7,
      NULL,
      0,
      1,
      0.048565,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981440,
      1,
      1,
      2.368101,
      2,
      3,
      3.677031,
      9,
      5,
      NULL,
      4.515581,
      1.959889,
      0.755797,
      NULL,
      1.901250,
      0,
      3.745419,
      1,
      5.729649,
      2.487378,
      4,
      2.007863,
      0.741160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.823597,
      0.235360,
      0,
      NULL,
      1,
      0.028546,
      2,
      1,
      0,
      NULL,
      0,
      0.154450,
      0.881817,
      NULL,
      0.417434,
      0,
      0.218629,
      0,
      1.202354,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.457647,
      4.985955,
      NULL,
      3,
      1,
      0.956992,
      1,
      1,
      NULL,
      1,
      1.776032,
      0,
      NULL,
      0.265010,
      0,
      5,
      0,
      5,
      4,
      2,
      5.824092,
      2.301104,
      NULL,
      1.457839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.633365,
      0.364475,
      NULL,
      NULL,
      2,
      3.650737,
      4.557435,
      0,
      2,
      5,
      4,
      NULL,
      NULL,
      4.194510,
      0.901687,
      3.064733,
      3,
      2.534253,
      1.748492,
      1.147468,
      1.208174,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.971411,
      NULL,
      NULL,
      NULL,
      5.385672,
      5,
      7,
      5.334425,
      5.147080,
      NULL,
      5.246076,
      1,
      0.629231,
      0.377406,
      NULL,
      6,
      6,
      2.608424,
      3.925913,
      3.965199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.061727,
      4,
      NULL,
      5.996976,
      NULL,
      NULL,
      6,
      NULL,
      5,
      0,
      6,
      NULL,
      0.431767,
      4.214930,
      5,
      6,
      NULL,
      3,
      NULL,
      7.474362,
      NULL,
      3.668311,
      NULL,
      7.357378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.931561,
      0.916145,
      0,
      1.440944,
      0.023315,
      2.696813,
      1.468227,
      0.303448,
      NULL,
      0.457318,
      0.891181,
      1,
      NULL,
      0,
      NULL,
      1.698779,
      NULL,
      0.578273,
      1,
      1.442722,
      1,
      1.305378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.057628,
      2.451503,
      5.192951,
      1,
      1,
      1,
      1.776274,
      0.280424,
      1,
      0.995494,
      1.029468,
      0.926409,
      3.643551,
      4.403975,
      4.712898,
      1.793166,
      3,
      NULL,
      4.769281,
      1.778526,
      3.524322,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      4,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      4,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      4,
      4,
      NULL,
      7,
      3,
      NULL,
      2,
      2,
      1,
      4,
      0,
      1,
      NULL,
      5,
      4,
      0,
      3,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1990',
      '10-16-1980',
      ' 9- 3-1998',
      ' 3-13-1975',
      ' 3-21-2001',
      ' 1- 7-1978',
      ' 5-20-1993',
      ' 8-12-1987',
      ' 9- 9-2000',
      ' 1-17-1976',
      ' 8- 1-1993',
      ' 2-16-1990',
      ' 1-27-1982',
      ' 4-15-1982',
      '11-15-1975',
      ' 8-15-1976',
      '10- 4-1987',
      ' 8-21-1990',
      ' 3- 6-1998',
      ' 8-14-1996',
      NULL,
      ' 0-25-1990',
      ' 8-11-2002',
      NULL,
      ' 5-20-1982',
      ' 1- 4-1980',
      ' 5-24-1975',
      '10-22-1980',
      '11- 6-1991',
      ' 9-12-1979',
      '11-15-1991',
      ' 8- 4-2001',
      ' 7-20-1993',
      ' 3- 2-1995',
      NULL,
      ' 4-22-1974',
      NULL,
      NULL,
      ' 1- 6-1977',
      ' 2-29-1990',
      ' 4-18-1977',
      ' 3-20-1985',
      ' 1- 0-2000',
      ' 4- 6-2003',
      ' 6-20-2000',
      ' 4- 9-1990',
      ' 8-29-1979',
      NULL,
      ' 6-21-1976',
      ' 2-16-1999',
      '11- 3-1995',
      NULL,
      ' 8-10-2000',
      ' 7- 2-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


