set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '0332023',
      3,
      3,
      1,
      '32234',
      3,
      ' 8- 7-1991',
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      1.476060,
      0.304025,
      2.704714,
      0,
      NULL,
      1,
      9,
      NULL,
      NULL,
      0.023691,
      NULL,
      NULL,
      25.066139,
      1.106201,
      4.924430,
      NULL,
      NULL,
      NULL,
      0.104356,
      2.566311,
      NULL,
      0,
      11.597114,
      1,
      1,
      9,
      1,
      0,
      NULL,
      5,
      0,
      1,
      0,
      1,
      1,
      6,
      NULL,
      9,
      7,
      2,
      0,
      1.934705,
      1.356351,
      1,
      0,
      0,
      4.889926,
      4.401496,
      2,
      8,
      3,
      NULL,
      7.647815,
      6,
      NULL,
      1.128328,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.680926,
      NULL,
      NULL,
      2,
      NULL,
      1,
      32.575767,
      327.294870,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      6.154517,
      NULL,
      NULL,
      129,
      6.109301,
      NULL,
      1,
      99.491038,
      NULL,
      NULL,
      0.610693,
      NULL,
      37,
      1,
      3.295616,
      1266.850756,
      0.251534,
      3.127749,
      6,
      325,
      NULL,
      NULL,
      9.570523,
      145.061710,
      NULL,
      4.664947,
      NULL,
      121,
      35,
      0.118871,
      2.172547,
      NULL,
      50.214831,
      0.989782,
      3,
      29,
      32,
      3,
      2,
      561,
      382,
      2.746416,
      1,
      177.199155,
      1059,
      2.273107,
      2.156297,
      17.315154,
      128.650561,
      9,
      NULL,
      204.953387,
      20.031293,
      1.783683,
      0,
      NULL,
      4.374425,
      3,
      7.653180,
      17,
      7,
      1,
      1.061684,
      453,
      153,
      2.866503,
      NULL,
      86.217159,
      7.366874,
      1,
      NULL,
      213,
      76.836317,
      2.324042,
      NULL,
      64,
      13854.358823,
      0.503939,
      3.384661,
      83,
      23,
      NULL,
      0,
      195.655145,
      93,
      4.793710,
      2.324978,
      219.950941,
      21,
      1,
      2,
      NULL,
      34,
      3,
      1,
      52,
      NULL,
      1,
      3.400172,
      66.831923,
      27.951085,
      2,
      NULL,
      38.836085,
      NULL,
      0,
      4,
      76,
      0,
      1,
      4.007845,
      152,
      7.153373,
      NULL,
      1,
      NULL,
      1051.050204,
      3,
      6.541264,
      561,
      NULL,
      NULL,
      1,
      501.490712,
      176.764201,
      3.729279,
      NULL,
      34.872280,
      124.032907,
      0.093461,
      0.457194,
      30.680926,
      3,
      0,
      1.450372,
      11.121271,
      NULL,
      0.116979,
      NULL,
      530,
      413.100330,
      1,
      3,
      621,
      2,
      3,
      0.795594,
      113,
      16,
      2.806134,
      5,
      65.262356,
      3.320635,
      2,
      NULL,
      NULL,
      NULL,
      2.542359,
      3.154609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.372048,
      '00334',
      '',
      '',
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      5,
      1.054741,
      NULL,
      3.555716,
      87,
      1,
      NULL,
      NULL,
      NULL,
      9.883829,
      25.564688,
      0,
      NULL,
      0,
      NULL,
      0.285808,
      NULL,
      0.735290,
      NULL,
      0.988693,
      NULL,
      ' 0- 7-1988',
      15,
      22,
      16,
      5,
      4,
      4.389117,
      NULL,
      1.468173,
      8,
      8,
      8,
      4.352919,
      6.279107,
      22,
      23.875001,
      21,
      2.033700,
      5.039058,
      7,
      NULL,
      3.782048,
      8.695627,
      6,
      21.680345,
      10.172731,
      13.647921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.027209,
      NULL,
      8,
      2.023877,
      22.242739,
      4,
      NULL,
      10.712803,
      NULL,
      14,
      NULL,
      41.469363,
      15.556259,
      3,
      4.266470,
      NULL,
      1,
      26,
      NULL,
      9,
      6.364087,
      NULL,
      10.274534,
      NULL,
      26,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      122.011807,
      62,
      54.725278,
      32.208139,
      NULL,
      NULL,
      133,
      112.974951,
      170,
      11,
      38.545034,
      NULL,
      135,
      160.315441,
      182,
      102.539764,
      50,
      86,
      182.717574,
      95.418087,
      78.969413,
      59.110286,
      NULL,
      188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.407334,
      1,
      6.991058,
      1.240778,
      4.770764,
      4.419171,
      6.317351,
      6.686161,
      NULL,
      2.271033,
      NULL,
      NULL,
      6,
      4,
      2,
      1,
      4.553941,
      NULL,
      9.065761,
      1.273278,
      NULL,
      NULL,
      0.643722,
      11.131131,
      6.406500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      2,
      1,
      4.132314,
      1.379306,
      3.970737,
      2.346644,
      NULL,
      5,
      8.223977,
      2,
      2,
      9,
      5,
      3,
      NULL,
      3.695454,
      9.660696,
      NULL,
      1.251475,
      3.315383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269398,
      3,
      3.088656,
      4,
      2,
      1,
      NULL,
      1.653498,
      NULL,
      1.934892,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.505340,
      6,
      3.999076,
      1,
      1.022832,
      4.809727,
      2.528296,
      1.829505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.654092,
      NULL,
      0.320536,
      1.607119,
      3.697509,
      1.578028,
      0.794064,
      0,
      1.694060,
      1.448959,
      0,
      0,
      0,
      NULL,
      1,
      1.474587,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.682507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.061580,
      NULL,
      3.224092,
      0,
      0.333566,
      2,
      NULL,
      2.331112,
      2.155323,
      1,
      1,
      0.725100,
      1.813490,
      1,
      NULL,
      1.706472,
      1.324915,
      4.775572,
      1,
      0.972846,
      2.507925,
      11.327232,
      2.095198,
      1.333790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410423,
      NULL,
      4,
      0.736309,
      2,
      0.840729,
      4,
      2,
      7,
      0.598570,
      7.254198,
      NULL,
      NULL,
      0.653657,
      NULL,
      NULL,
      7,
      3,
      6,
      5.373389,
      3.356472,
      2,
      10.333308,
      8.780848,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.850557,
      NULL,
      3.819692,
      4.134897,
      NULL,
      6,
      0,
      5.044544,
      5.503693,
      3.405630,
      NULL,
      1,
      3.665615,
      2,
      NULL,
      2,
      4,
      1.614807,
      NULL,
      NULL,
      0.314433,
      7.819485,
      0.073042,
      2,
      7,
      5.526482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211741,
      0,
      3.001790,
      3,
      1.378862,
      1.490419,
      4.954569,
      3.852189,
      2.030733,
      NULL,
      1.239061,
      NULL,
      5,
      8,
      3.192158,
      3,
      1,
      5.230065,
      NULL,
      3,
      NULL,
      9.655330,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.596484,
      1,
      2,
      5.977246,
      0,
      NULL,
      NULL,
      1.406733,
      4.351472,
      1.136321,
      NULL,
      0,
      5,
      NULL,
      3,
      2,
      4,
      3.990197,
      10.288482,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      2,
      0.768487,
      1.525599,
      4.197280,
      2.577680,
      0.921763,
      NULL,
      1,
      NULL,
      3.547657,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      0.684806,
      0.682360,
      0,
      1,
      0.983327,
      0,
      1.872751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134501,
      NULL,
      0,
      NULL,
      0.628888,
      NULL,
      1,
      0.348757,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.385491,
      NULL,
      NULL,
      0.850147,
      1,
      0,
      0.209356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596545,
      1,
      NULL,
      1.055783,
      2.982566,
      0.344664,
      4.608097,
      NULL,
      5.486690,
      5,
      0.008226,
      7.061885,
      1,
      5.152043,
      0.515123,
      2,
      5.146047,
      2,
      1.564571,
      4,
      0,
      3,
      7,
      NULL,
      2,
      4.058389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.877947,
      0.535516,
      1,
      4,
      0,
      3.086888,
      2.647007,
      4.853496,
      0,
      4.328090,
      0.581941,
      4.260836,
      7,
      3,
      5.884295,
      3.062948,
      2,
      2,
      NULL,
      2,
      1.217424,
      1,
      3,
      3,
      0.163291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.275398,
      0,
      3,
      2,
      7.214890,
      0,
      6,
      8,
      5,
      5.973014,
      9.191485,
      NULL,
      8.560715,
      0.312963,
      7,
      NULL,
      9,
      3,
      8.429058,
      0.803074,
      7,
      3.076391,
      8,
      2.655104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.216581,
      1.962536,
      1,
      5,
      7.861166,
      6.092170,
      5.880954,
      4,
      6.965557,
      1.654528,
      NULL,
      2,
      2.024432,
      0.047094,
      6,
      4.539868,
      0.100698,
      NULL,
      0.632086,
      3,
      NULL,
      0.307555,
      2.369479,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801991,
      1,
      0,
      0.620975,
      0,
      0,
      NULL,
      NULL,
      1.962314,
      1,
      0,
      1,
      1,
      0.488031,
      1,
      NULL,
      1,
      0,
      NULL,
      0.425167,
      1,
      1.155109,
      0.132966,
      1.925090,
      1,
      1.729735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421505,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      1,
      NULL,
      7,
      1,
      2.703836,
      4,
      2.751661,
      1,
      3.197755,
      4.621191,
      NULL,
      NULL,
      7,
      NULL,
      3,
      6,
      7.568844,
      0.647889,
      1.886274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      5,
      5,
      2,
      NULL,
      2,
      0,
      3,
      NULL,
      4,
      NULL,
      3,
      5,
      3,
      1,
      3,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-2002',
      ' 5-10-1974',
      NULL,
      ' 5- 3-1999',
      NULL,
      ' 2-15-1985',
      ' 6-19-2003',
      ' 2-19-1982',
      ' 4-12-1979',
      NULL,
      ' 8-18-2000',
      ' 7-21-1989',
      ' 4- 0-1979',
      ' 6-25-1997',
      ' 3-11-2003',
      ' 2-25-1974',
      ' 2-18-1998',
      ' 7- 4-1986',
      ' 7- 5-1980',
      '10- 9-1984',
      ' 2- 6-1994',
      NULL,
      '11-27-1988',
      '10-11-1994',
      ' 0- 9-1993',
      ' 0-16-1981',
      ' 1-10-1981',
      ' 6- 2-1978',
      ' 0-27-1978',
      '11- 9-1996',
      ' 3-14-1980',
      ' 7- 2-1984',
      ' 8-17-1978',
      ' 5-21-1997',
      '11- 5-1999',
      ' 6- 9-1998',
      '11-17-1988',
      ' 7- 8-1993',
      ' 5-12-1999',
      ' 0- 8-2000',
      ' 6-23-1977',
      NULL,
      ' 9-18-1988',
      NULL,
      '11- 1-1991',
      ' 6-24-1995',
      NULL,
      NULL,
      ' 3-29-1994',
      '11-18-2003',
      '11- 9-1998',
      ' 3-23-1987',
      ' 7-16-2002',
      ' 8-17-1987',
      ' 4-18-2002',
      ' 0-19-1975',
      NULL,
      ' 8- 1-1978',
      ' 0-10-1999',
      ' 9-17-1988',
      ' 6-10-1989',
      ' 9- 8-1987',
      ' 7-23-1978',
      '10-14-1987',
      ' 7-25-1974',
      NULL,
      NULL,
      '11-29-2003',
      ' 4-12-1986',
      ' 1-17-1993',
      ' 7- 4-2002',
      ' 0-26-1987',
      ' 0-27-1983',
      NULL,
      NULL,
      ' 5-14-1998',
      ' 6-28-1984',
      ' 7-29-1993',
      ' 1-23-1990',
      NULL,
      '11-17-1990',
      NULL,
      ' 9-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484160);
commit;
end;
/


