set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7807074';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      '01024',
      0.156245,
      NULL,
      53.547204,
      NULL,
      1,
      NULL,
      1.025648,
      0,
      0,
      0.851631,
      0.938931,
      1.057634,
      1.954055,
      NULL,
      1.731846,
      8,
      NULL,
      NULL,
      1.257532,
      2.707569,
      NULL,
      NULL,
      NULL,
      NULL,
      2.981617,
      NULL,
      10,
      NULL,
      1.383604,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      10.514688,
      0,
      2.046305,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      5,
      1,
      3,
      12.724851,
      2,
      9,
      8,
      1.723179,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.293230,
      0,
      1,
      1,
      4,
      2,
      6,
      NULL,
      91.906111,
      2,
      2.320792,
      NULL,
      9,
      3,
      3,
      186.341985,
      5,
      0.406286,
      1.093247,
      105,
      45,
      4,
      0,
      183,
      14,
      NULL,
      2.507978,
      65.551266,
      18.044539,
      0.599355,
      0.780527,
      NULL,
      32,
      3,
      NULL,
      252.687804,
      1168.003409,
      0,
      1.866323,
      110,
      58,
      NULL,
      4,
      195.185970,
      109,
      NULL,
      3,
      240,
      1.282509,
      2.195131,
      NULL,
      49,
      18.839517,
      NULL,
      5,
      NULL,
      0,
      3,
      3,
      26.693077,
      NULL,
      0,
      NULL,
      NULL,
      62.581449,
      1.739256,
      NULL,
      7,
      293,
      1.827957,
      2,
      332,
      NULL,
      0,
      2,
      NULL,
      3,
      2.914922,
      6,
      NULL,
      2.553826,
      3.206847,
      0.747095,
      NULL,
      23.266301,
      0.495132,
      NULL,
      119,
      333.285294,
      2,
      0.165997,
      112.657959,
      NULL,
      2.318149,
      0,
      246.243217,
      172,
      1,
      1.114946,
      169,
      13,
      NULL,
      NULL,
      135.899799,
      0.880476,
      2,
      0.656984,
      NULL,
      91.609433,
      3,
      4.320670,
      110,
      117.225442,
      1.463561,
      NULL,
      12,
      111.278707,
      1,
      2,
      208.480826,
      343,
      1,
      1.751579,
      133.002298,
      372,
      0,
      NULL,
      207.961280,
      199.526849,
      0.215302,
      5.532348,
      36.169608,
      606.311184,
      1.869009,
      NULL,
      146.508392,
      245,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.619457,
      '01030',
      NULL,
      '41411',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5,
      1,
      NULL,
      0,
      629.798291,
      1.143864,
      NULL,
      1.982958,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.706180,
      NULL,
      1,
      NULL,
      1.639960,
      NULL,
      NULL,
      0,
      7.873528,
      14.628971,
      7,
      9.733269,
      NULL,
      14,
      NULL,
      21,
      NULL,
      1.606687,
      NULL,
      0,
      19.722093,
      2,
      9,
      24.197216,
      0,
      3.663482,
      17.234976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      5.734486,
      30.974133,
      NULL,
      56,
      5.355718,
      7.712569,
      13.926573,
      2.360219,
      5,
      NULL,
      58,
      10,
      NULL,
      6.608223,
      29,
      0.183718,
      21.820863,
      29,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.558962,
      103.902314,
      37.078243,
      139.375973,
      NULL,
      120,
      119,
      143,
      NULL,
      23.309512,
      NULL,
      NULL,
      NULL,
      149.479234,
      NULL,
      108.934151,
      167.836448,
      26,
      53.209544,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745931,
      0.472076,
      1.701518,
      1.369288,
      3,
      2.166000,
      5,
      5.938503,
      3,
      6.134355,
      NULL,
      7.315574,
      2,
      NULL,
      1.167538,
      5,
      7.017854,
      NULL,
      NULL,
      6.589792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599440,
      NULL,
      1,
      3.249072,
      4,
      NULL,
      2,
      0,
      NULL,
      5.757261,
      7.970073,
      5,
      2.701312,
      7.642226,
      0.750436,
      NULL,
      1.120283,
      4,
      6.814466,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.630465,
      6.922517,
      7.890206,
      0.361296,
      5,
      NULL,
      NULL,
      4.607280,
      5.929216,
      3,
      3.462594,
      7.774525,
      3,
      7,
      0,
      NULL,
      2,
      0.051752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511642,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      0.157750,
      NULL,
      2.112163,
      NULL,
      NULL,
      3,
      1,
      5.249643,
      5,
      6.386385,
      6,
      1,
      NULL,
      1.550399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846636,
      4.133321,
      NULL,
      4,
      5,
      4,
      3.880916,
      NULL,
      0,
      NULL,
      7,
      5.692542,
      6.295143,
      NULL,
      4,
      6.781748,
      3.088655,
      8,
      7.153067,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.590046,
      5,
      2.457174,
      5,
      5.852882,
      0.418624,
      5,
      7,
      7,
      4,
      8,
      4,
      6,
      6,
      2.556262,
      4.371331,
      9,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599758,
      2,
      5,
      0,
      6.394819,
      5,
      NULL,
      2,
      5.801722,
      7.907740,
      NULL,
      NULL,
      NULL,
      3.139158,
      4.648514,
      1.567678,
      1,
      NULL,
      4,
      2.663546,
      5.763277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.973510,
      0,
      7.179675,
      2,
      NULL,
      NULL,
      3.617235,
      1,
      0.817529,
      5,
      NULL,
      6,
      NULL,
      8,
      0,
      2,
      3,
      NULL,
      5.881609,
      0.981792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340519,
      5.692517,
      NULL,
      1.999173,
      1.117153,
      1.840836,
      0.570495,
      0.473111,
      3.731781,
      1.113258,
      4,
      1.865220,
      6,
      1.784297,
      NULL,
      9.568276,
      7,
      NULL,
      2,
      6,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      4.062236,
      0.194106,
      0,
      0,
      1.167594,
      1.055780,
      2,
      0,
      NULL,
      NULL,
      5,
      5.151046,
      NULL,
      0.204284,
      3,
      2,
      3,
      1.792339,
      2.960041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.568817,
      0,
      1.857494,
      0.495601,
      0,
      0.614786,
      1,
      1,
      0,
      1.272837,
      1.129809,
      0,
      0,
      NULL,
      0.380037,
      NULL,
      1.380243,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.906213,
      4.347614,
      2.218651,
      NULL,
      5,
      2.223190,
      NULL,
      NULL,
      1,
      NULL,
      5.003569,
      2,
      NULL,
      3,
      2.186618,
      1,
      0.281596,
      0.480394,
      2,
      NULL,
      2.682076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364627,
      0.663925,
      1.992296,
      0.329943,
      1,
      0.197055,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.647833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838696,
      NULL,
      6,
      2,
      1,
      0,
      7.499972,
      NULL,
      3,
      NULL,
      1.713308,
      0.695169,
      7.843708,
      1,
      8,
      3.867265,
      0.347534,
      6,
      2.455502,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.011440,
      0,
      6,
      3,
      5.539652,
      1.702628,
      NULL,
      0.380602,
      0.235991,
      4,
      7.640955,
      3.319505,
      NULL,
      NULL,
      5.240022,
      4,
      9.707912,
      2,
      7.091459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813350,
      1.604149,
      1.356807,
      1.594224,
      0.542455,
      0.590381,
      0,
      1.639948,
      0.813731,
      1,
      1.419782,
      0.933934,
      NULL,
      1.251922,
      0,
      1.448851,
      NULL,
      1.676026,
      1.554801,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      5.253042,
      3,
      5,
      0,
      NULL,
      0.269326,
      0.638371,
      3.201166,
      1.609713,
      1.934574,
      0,
      5.224765,
      1.994493,
      1.940845,
      3,
      1,
      NULL,
      3.325793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      4,
      1,
      NULL,
      0,
      4,
      2,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      2,
      0,
      0,
      1,
      2,
      4,
      5,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      4,
      0,
      5,
      2,
      2,
      2,
      0,
      0,
      2,
      2,
      2,
      3,
      3,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1991',
      ' 3-20-1991',
      '10-27-1976',
      ' 1-22-1981',
      ' 8- 1-1982',
      '11-14-1974',
      ' 2-18-1997',
      ' 6- 9-1992',
      NULL,
      ' 2- 8-1981',
      '11-23-2003',
      NULL,
      ' 9-19-1976',
      ' 8-17-1998',
      ' 2-13-2001',
      ' 9-19-1995',
      '10- 4-1981',
      '10- 0-1988',
      ' 0-17-1990',
      ' 3-13-1983',
      ' 7-23-2000',
      ' 4-16-1992',
      ' 9-10-1995',
      ' 5- 1-2002',
      NULL,
      ' 9- 3-1997',
      ' 9-13-2000',
      NULL,
      ' 3-28-2001',
      ' 1-25-1997',
      NULL,
      ' 3-15-1986',
      '10-22-1983',
      ' 5- 0-1995',
      ' 6-22-1990',
      NULL,
      NULL,
      ' 1-17-1992',
      NULL,
      '10- 4-1986',
      NULL,
      ' 2-16-1997',
      ' 1-12-1974',
      ' 1- 0-1985',
      ' 1-13-2003',
      ' 6-17-1988',
      ' 0-25-2002',
      ' 5-13-1979',
      ' 5- 3-1989',
      ' 6- 9-1974',
      ' 7-17-2000',
      NULL,
      ' 7-22-1987',
      NULL,
      ' 3-27-1987',
      '11- 2-1991',
      ' 7- 3-2002',
      ' 7- 7-1985',
      ' 4- 7-1986',
      ' 3-28-1993',
      ' 4- 6-1979',
      NULL,
      '11- 2-1986',
      '11-18-1999',
      ' 5- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1992',
      NULL,
      ' 6-20-1978',
      ' 4- 6-1991',
      ' 8-14-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


