set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7531456';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '1223120',
      3,
      NULL,
      0,
      '02004',
      3.898588,
      ' 2- 9-2002',
      72.007866,
      NULL,
      1,
      0,
      3.141761,
      0,
      0.462605,
      1.380619,
      1.447850,
      NULL,
      3,
      2.087502,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.079849,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      NULL,
      0,
      2,
      NULL,
      NULL,
      5,
      3,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      4.448251,
      7,
      4.785978,
      2,
      0.776734,
      0,
      1,
      1.883192,
      0,
      6,
      NULL,
      11.351681,
      16.108045,
      0,
      2.310000,
      4,
      NULL,
      2,
      4,
      1.625351,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      29,
      217,
      34,
      3,
      1.257594,
      34,
      157.769937,
      1.384043,
      3,
      227,
      6.446927,
      0.954143,
      1.726007,
      272,
      NULL,
      0,
      2,
      NULL,
      154,
      3,
      NULL,
      311,
      2.096416,
      1,
      1.563645,
      772.590734,
      314,
      1,
      1.822309,
      375.121500,
      53,
      3.342166,
      1,
      6.055743,
      NULL,
      1,
      NULL,
      154.892420,
      0.345571,
      1.935863,
      2,
      256,
      47,
      3,
      NULL,
      100.492570,
      199,
      NULL,
      NULL,
      80.871444,
      97,
      1.789295,
      2.242973,
      386,
      4,
      NULL,
      NULL,
      125,
      52,
      0.447196,
      0,
      NULL,
      1.202690,
      1,
      0,
      NULL,
      29,
      2,
      3.416798,
      85,
      NULL,
      1,
      0.412192,
      73.594638,
      5.232017,
      3,
      1.618496,
      26,
      NULL,
      1,
      3.954437,
      7,
      68.019965,
      1,
      2,
      115.699962,
      6,
      2,
      1,
      224,
      61,
      3.667517,
      2.445173,
      NULL,
      44.278103,
      0,
      0.873268,
      34,
      101,
      0,
      2.924112,
      NULL,
      82,
      2.757387,
      NULL,
      385.967279,
      2,
      2.024042,
      3,
      269,
      2,
      1.536926,
      3.805742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.602915,
      '21240',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      '03231',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5,
      0,
      NULL,
      2.765166,
      1022,
      1.046979,
      NULL,
      1.229139,
      NULL,
      NULL,
      NULL,
      0.297666,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 5-25-1987',
      14,
      7.798030,
      17,
      NULL,
      1.232273,
      2.880509,
      6.822434,
      NULL,
      4.057125,
      18,
      NULL,
      3,
      NULL,
      3.341454,
      0.950957,
      2.491323,
      1.833570,
      0,
      16.962617,
      NULL,
      3,
      8.442518,
      6.635482,
      4,
      11,
      13.887859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      24,
      NULL,
      14.679511,
      44,
      NULL,
      4.135667,
      14,
      8,
      11,
      12,
      44.132974,
      3.210055,
      5.469006,
      NULL,
      0,
      20,
      0,
      18,
      32,
      21,
      27,
      36,
      30.849353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      116,
      150,
      NULL,
      88.743123,
      130,
      120,
      145,
      NULL,
      5.800567,
      NULL,
      NULL,
      156.750185,
      88,
      19.890159,
      7.199505,
      51,
      126.117295,
      NULL,
      70.212202,
      82,
      145,
      26.383202,
      82.097195,
      169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.681540,
      2.626994,
      2,
      1.317071,
      2,
      4.672408,
      5,
      5,
      2.864748,
      NULL,
      0.724554,
      5.447627,
      NULL,
      3,
      7.101774,
      0.159996,
      NULL,
      NULL,
      NULL,
      2.283352,
      6,
      10,
      3,
      7.370612,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.324309,
      NULL,
      4,
      0.875948,
      3.640333,
      1,
      5,
      NULL,
      3.048003,
      NULL,
      1,
      NULL,
      2.365633,
      3.581549,
      1.662299,
      5.118904,
      7,
      NULL,
      3,
      1,
      NULL,
      3.012842,
      5.911184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049925,
      1,
      0.043445,
      3,
      3.952244,
      NULL,
      6.448031,
      2,
      4,
      4.693676,
      8.975080,
      3,
      8.785193,
      8.723553,
      3.163651,
      2.838077,
      0.976344,
      NULL,
      0,
      NULL,
      2,
      3.949982,
      4.651000,
      5.993050,
      7.865221,
      7.229959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.393178,
      1.512181,
      2.361720,
      5.492460,
      2.043694,
      1,
      4.725791,
      7,
      2,
      NULL,
      NULL,
      1,
      5,
      0.728342,
      NULL,
      4.691925,
      NULL,
      3,
      NULL,
      5,
      NULL,
      1.254550,
      3.730077,
      5.642752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465045,
      5,
      NULL,
      6.198361,
      3,
      0.547365,
      2,
      7,
      3,
      NULL,
      6,
      6,
      7.357245,
      2,
      7.241696,
      3.615836,
      0.073159,
      0.913854,
      1.693529,
      6,
      7.877995,
      3,
      2.273970,
      5.784667,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267149,
      3,
      2.525334,
      4,
      1,
      3.142737,
      NULL,
      5.870030,
      4,
      2.844536,
      9.666598,
      8.431525,
      8,
      NULL,
      0.127920,
      1.521409,
      1.137411,
      1,
      1,
      5.661052,
      3,
      NULL,
      NULL,
      4.025646,
      9,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.329895,
      7,
      5.861002,
      0,
      5,
      3,
      NULL,
      7.079205,
      NULL,
      7.577018,
      1.835486,
      7.464238,
      NULL,
      7.688089,
      1.267381,
      4,
      0.220832,
      7.266033,
      NULL,
      6.553764,
      7,
      3,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9,
      2.856991,
      4,
      1.261240,
      0.286370,
      6.380584,
      8,
      NULL,
      9.839967,
      NULL,
      8.276701,
      NULL,
      0.635673,
      2.116025,
      NULL,
      7,
      6,
      2.465128,
      7,
      NULL,
      NULL,
      3,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      1.955460,
      3,
      2,
      2.887616,
      0,
      NULL,
      0,
      NULL,
      7,
      4.893816,
      0.583394,
      4,
      6,
      NULL,
      NULL,
      NULL,
      4.435233,
      NULL,
      2,
      6,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.813050,
      NULL,
      4,
      1.969403,
      1.546192,
      NULL,
      7,
      NULL,
      NULL,
      6.288069,
      NULL,
      2,
      NULL,
      3.953620,
      0,
      5,
      6.293367,
      5,
      3,
      5.348586,
      6.123110,
      3.108380,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.167289,
      0,
      0.318947,
      0,
      1.214750,
      1.915236,
      1.052727,
      0.603591,
      1,
      0.944449,
      0.976475,
      0,
      1.504249,
      0,
      NULL,
      1,
      0.151359,
      NULL,
      1,
      0.581543,
      1,
      0.174967,
      0,
      0,
      0.504067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.456803,
      NULL,
      NULL,
      1.402783,
      2,
      2,
      1.363624,
      1.303776,
      1.693468,
      NULL,
      3,
      1.505658,
      NULL,
      3,
      1.200104,
      1.125580,
      0,
      1.121496,
      1.265477,
      NULL,
      1,
      1.173574,
      0.775741,
      0.241688,
      1,
      1.307955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.764574,
      NULL,
      0,
      NULL,
      NULL,
      1.844226,
      1,
      0.595038,
      NULL,
      NULL,
      0.787475,
      0,
      1,
      NULL,
      1.794600,
      0,
      1.240102,
      1,
      NULL,
      1,
      NULL,
      1.207189,
      1.993675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.262278,
      0.535790,
      NULL,
      1,
      NULL,
      7,
      0.875734,
      9.230566,
      4.848751,
      9,
      6,
      NULL,
      7.042832,
      1.077124,
      0,
      7,
      6.375214,
      2,
      2,
      5,
      9,
      7.837955,
      8,
      7,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.293538,
      0.284997,
      NULL,
      7,
      5,
      0,
      2,
      6.576876,
      1,
      6.814243,
      6,
      0,
      1,
      9,
      4,
      9,
      1,
      8,
      4,
      6.827450,
      5.624884,
      8,
      1.777856,
      NULL,
      9,
      9.069471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.273258,
      0.889993,
      NULL,
      0.867914,
      1.909962,
      1,
      0.163592,
      NULL,
      1,
      NULL,
      1.593545,
      NULL,
      0,
      0,
      NULL,
      0.671843,
      1.600632,
      1,
      0,
      NULL,
      1.863495,
      0.693197,
      1.134214,
      0,
      0.882267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231895,
      NULL,
      1.680908,
      1,
      2.679072,
      1,
      1,
      NULL,
      0.434943,
      NULL,
      2.751576,
      3.126847,
      1,
      3.107432,
      1.277028,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.914443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      0,
      1,
      0,
      5,
      2,
      NULL,
      4,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      2,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-20-1979',
      ' 3-23-1985',
      '11- 3-1991',
      ' 7-13-1977',
      ' 6-29-2001',
      ' 1- 4-1975',
      NULL,
      '11-22-1989',
      '11-21-2001',
      NULL,
      NULL,
      ' 8- 3-1999',
      ' 3-17-1976',
      ' 6- 5-1993',
      ' 1-20-1995',
      NULL,
      NULL,
      ' 6-25-1986',
      NULL,
      ' 8-29-1978',
      NULL,
      ' 2-15-1993',
      NULL,
      '10-20-1975',
      ' 5-27-1981',
      NULL,
      NULL,
      ' 7- 7-1976',
      ' 9- 4-1975',
      ' 8- 9-1978',
      ' 9-25-1993',
      ' 8- 8-1993',
      ' 5- 4-1974',
      ' 8- 6-1998',
      ' 2-12-1977',
      ' 8- 0-1983',
      ' 3-16-2002',
      NULL,
      ' 4-17-1988',
      '10-11-1975',
      ' 3- 3-1984',
      ' 8-28-1975',
      NULL,
      ' 3- 6-1989',
      '10-16-2000',
      ' 2-27-1998',
      ' 5- 4-1998',
      NULL,
      ' 8-23-1999',
      NULL,
      ' 2- 8-1982',
      NULL,
      ' 5- 1-1989',
      NULL,
      ' 8- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


