set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '3122302',
      NULL,
      4.010176,
      3,
      '40134',
      0,
      ' 5- 7-2002',
      9.920319,
      NULL,
      0,
      0,
      2,
      0.969033,
      0,
      0.007548,
      1.619641,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.790294,
      37.244442,
      13.202897,
      NULL,
      1,
      5,
      NULL,
      NULL,
      3.301127,
      NULL,
      5,
      3.039572,
      4,
      NULL,
      2,
      5,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      2,
      10.214507,
      4,
      0.301261,
      0,
      0,
      1,
      0,
      NULL,
      2,
      1,
      2,
      1.557550,
      1,
      7,
      2,
      3,
      4,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.684056,
      NULL,
      5,
      1,
      5,
      12.664583,
      2,
      58,
      152.377852,
      73,
      0.018456,
      0.774981,
      NULL,
      0.836243,
      2,
      5,
      NULL,
      10,
      2,
      0,
      NULL,
      4.918439,
      3,
      1.791980,
      NULL,
      8,
      1,
      1,
      1,
      8.670946,
      NULL,
      6.410940,
      204,
      NULL,
      0,
      6.298229,
      NULL,
      NULL,
      1,
      6.288782,
      48,
      0.525846,
      2.870149,
      NULL,
      100,
      2.106251,
      2,
      0.786212,
      28.836114,
      11.368727,
      2.657799,
      1.854494,
      249,
      5.720553,
      1,
      NULL,
      118,
      4,
      0.964580,
      9,
      107,
      NULL,
      NULL,
      6.751918,
      30,
      NULL,
      3,
      NULL,
      202,
      2,
      3.659174,
      NULL,
      NULL,
      3.494671,
      1,
      6.164142,
      70,
      0.944232,
      NULL,
      1,
      589.749446,
      103,
      NULL,
      2.449365,
      534,
      68.593500,
      2.864027,
      3.438492,
      501.300583,
      184.933628,
      NULL,
      3,
      482,
      11.696583,
      3,
      4.115873,
      546,
      65,
      1.255592,
      3,
      NULL,
      189.814425,
      1.523036,
      6,
      116,
      531,
      NULL,
      NULL,
      NULL,
      558.492037,
      0.410603,
      NULL,
      176,
      326.864817,
      0.542681,
      5.122402,
      23,
      188,
      NULL,
      NULL,
      77,
      155.191107,
      NULL,
      2,
      110.344464,
      NULL,
      NULL,
      1.411093,
      224.463261,
      8,
      1.611950,
      2.445824,
      NULL,
      191.534803,
      NULL,
      NULL,
      103,
      255,
      0.335811,
      5,
      64.945456,
      126,
      1.992327,
      NULL,
      40.949627,
      123,
      0,
      0,
      142,
      250.837698,
      3,
      NULL,
      NULL,
      445.747125,
      0,
      1,
      159,
      690.861392,
      1,
      0.810958,
      137,
      NULL,
      2,
      3.202697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '2204',
      '',
      '',
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0.459216,
      '',
      '',
      NULL,
      2,
      3.479082,
      10.754012,
      1.640908,
      124,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.678716,
      NULL,
      0.920627,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.249872,
      NULL,
      ' 6-24-1992',
      NULL,
      18.687312,
      6.066301,
      18.112509,
      17,
      4.769252,
      18,
      19.450879,
      11,
      7.731460,
      3.751953,
      4,
      NULL,
      3,
      1.733049,
      9.593352,
      7,
      2,
      6.090695,
      7.550905,
      NULL,
      NULL,
      13.630509,
      9,
      7.194803,
      5,
      13.018287,
      8.585834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.864551,
      NULL,
      2,
      NULL,
      26.626434,
      NULL,
      5,
      12.706037,
      56.777136,
      11,
      1,
      14,
      2,
      3.186473,
      15,
      1,
      10,
      7,
      NULL,
      0.930373,
      NULL,
      NULL,
      6.372256,
      22,
      49.645293,
      10.198204,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      177,
      NULL,
      64.111885,
      161,
      168,
      NULL,
      166.979816,
      58,
      154.851770,
      146.812001,
      162.578775,
      74,
      71.063114,
      NULL,
      185,
      89,
      55.125531,
      48,
      179,
      151,
      62,
      NULL,
      174.206123,
      169.619617,
      68.120433,
      122.111444,
      26.364999,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689420,
      NULL,
      NULL,
      NULL,
      2.599224,
      2,
      6.858021,
      0.147697,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      7.891265,
      5.093171,
      0.149120,
      NULL,
      3,
      1,
      0,
      5,
      0.072254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.495296,
      3,
      2,
      1.683193,
      9.672212,
      NULL,
      2.411365,
      4.939609,
      NULL,
      2,
      3.522279,
      6,
      0.395089,
      4,
      8.948396,
      0,
      NULL,
      8.236871,
      1.441826,
      8.429119,
      1.552224,
      NULL,
      8.181556,
      11.967386,
      NULL,
      NULL,
      3.507685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.474381,
      NULL,
      1.056235,
      0.337365,
      0,
      NULL,
      0.364031,
      0,
      NULL,
      3.517911,
      NULL,
      4.708976,
      NULL,
      1,
      3,
      0,
      3.865523,
      NULL,
      5.207815,
      NULL,
      0,
      0,
      NULL,
      1.487199,
      3.721829,
      1.693747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.580425,
      1.951280,
      0.803616,
      1.688327,
      0.851308,
      NULL,
      0.285245,
      1.971401,
      0,
      1,
      0.188439,
      1.828355,
      0,
      0,
      NULL,
      0.704041,
      0.492242,
      NULL,
      1.771033,
      NULL,
      0.926871,
      0,
      1,
      0.941061,
      1,
      1.506535,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.818104,
      9.873807,
      5.319239,
      3,
      10.914066,
      7.503515,
      NULL,
      NULL,
      1,
      0,
      3,
      4,
      4.030890,
      4.013544,
      1,
      2.401494,
      NULL,
      5.922811,
      3.085075,
      3.936746,
      0,
      1.376812,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.825894,
      5.978775,
      0.916177,
      2,
      4.063630,
      1.059329,
      2.411925,
      6.501947,
      6,
      3,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      2,
      NULL,
      NULL,
      5.786683,
      6,
      3.630620,
      4,
      NULL,
      5.641316,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.608949,
      4,
      NULL,
      NULL,
      11,
      1.058879,
      8,
      3.304919,
      4,
      0,
      8.189768,
      3.925903,
      2,
      3,
      8,
      10.114658,
      9,
      4.183107,
      3,
      5.494783,
      4,
      1.968339,
      2,
      7,
      5,
      2.196866,
      4.885016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.264571,
      7.339238,
      NULL,
      NULL,
      1,
      7,
      5.493417,
      0.739434,
      2,
      2,
      0.900393,
      0,
      NULL,
      2,
      NULL,
      7.533234,
      NULL,
      3.925424,
      1,
      5,
      0,
      NULL,
      4.558835,
      6,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.146101,
      1,
      6.852106,
      2,
      3,
      1,
      0.042539,
      3.150817,
      1.374965,
      NULL,
      3.013587,
      6.116279,
      3.494490,
      4.868559,
      8.975544,
      3,
      6,
      5.634337,
      3,
      0,
      4,
      1.999111,
      1.790000,
      0,
      1,
      1,
      0,
      0.651576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.964513,
      NULL,
      7.386441,
      2.660733,
      NULL,
      0.868638,
      1.146604,
      0.670463,
      3.145323,
      2.051783,
      2.689543,
      1.759809,
      1,
      NULL,
      1.445897,
      NULL,
      2,
      0.298274,
      0,
      0.216250,
      0,
      0,
      3,
      5.274566,
      6.085581,
      0.636328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.690657,
      NULL,
      1.505434,
      1.614378,
      NULL,
      0,
      NULL,
      NULL,
      1.720434,
      0,
      1,
      NULL,
      1,
      1.769890,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.000369,
      NULL,
      1,
      1,
      0.876430,
      1,
      1.297342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      7.613028,
      NULL,
      4.544859,
      4.886890,
      NULL,
      0,
      0.475679,
      3.523865,
      0,
      2,
      NULL,
      1.054634,
      NULL,
      0.595642,
      3.736818,
      3.135680,
      2,
      2.857180,
      4,
      2.340156,
      0,
      1.145535,
      1,
      NULL,
      1.319201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539889,
      NULL,
      1.546128,
      2,
      2,
      2,
      0,
      NULL,
      0.931076,
      NULL,
      0.993472,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.759646,
      NULL,
      0,
      0,
      1.343577,
      0,
      NULL,
      0.481310,
      1.147110,
      0.868540,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.137663,
      6,
      6.210134,
      1,
      0.697077,
      2.323504,
      2.709779,
      NULL,
      5.221718,
      4.084573,
      3,
      9.827429,
      1.342788,
      1,
      2.680951,
      2,
      NULL,
      9.075945,
      NULL,
      5.067300,
      1.036417,
      NULL,
      5.845375,
      3.413929,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.247964,
      2.453831,
      NULL,
      3.403563,
      2.581348,
      7.362904,
      2.250459,
      3,
      2,
      NULL,
      2.921845,
      3,
      NULL,
      NULL,
      6,
      3.344670,
      9,
      8.187261,
      7,
      6,
      1.917387,
      NULL,
      1,
      3,
      NULL,
      1.928517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.938189,
      1.710361,
      1,
      0,
      0.666448,
      NULL,
      0.483848,
      1,
      0.697782,
      0.224875,
      1,
      1,
      0,
      1,
      1,
      1.612302,
      1.853415,
      NULL,
      1.532233,
      1.842369,
      0.487415,
      1,
      NULL,
      1.140136,
      0,
      1.713003,
      1.989608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456563,
      1,
      NULL,
      0.179440,
      NULL,
      2,
      2.947660,
      3,
      NULL,
      2.767010,
      NULL,
      NULL,
      2,
      0.037183,
      0,
      1,
      NULL,
      1.251876,
      NULL,
      2.643640,
      1.451129,
      1.758860,
      1.985940,
      0.257425,
      1.041944,
      NULL,
      1.303952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4,
      5,
      3,
      0,
      2,
      NULL,
      0,
      5,
      1,
      0,
      0,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1984',
      ' 5-26-1986',
      NULL,
      NULL,
      '11-22-1989',
      ' 7- 9-1975',
      ' 3- 8-1992',
      ' 1-15-2003',
      ' 8-25-1988',
      ' 0-10-1998',
      '10-11-1990',
      NULL,
      '11-11-1984',
      ' 9-22-2000',
      NULL,
      ' 4-21-2003',
      ' 1-19-1990',
      ' 5- 7-1995',
      NULL,
      ' 8-14-1999',
      ' 5-26-1993',
      ' 2-29-1976',
      ' 3-13-1995',
      ' 8- 8-1991',
      NULL,
      ' 8-20-1977',
      ' 9-12-2003',
      NULL,
      ' 3-28-1983',
      ' 6-16-1976',
      NULL,
      ' 5-29-1983',
      '11-10-1983',
      ' 2-20-2002',
      ' 5- 2-1989',
      ' 1- 6-2003',
      ' 7- 5-2000',
      ' 5-12-1987',
      ' 6-23-1992',
      NULL,
      ' 2- 5-2002',
      ' 5-19-1994',
      ' 0- 7-1998',
      '11- 6-1997',
      ' 1-26-1982',
      ' 4- 1-1989',
      '11- 7-1991',
      ' 5-19-1998',
      ' 2- 5-1994',
      ' 2-12-2001',
      ' 9-20-1986',
      ' 4-20-1976',
      ' 8- 3-1996',
      NULL,
      ' 8-11-1983',
      '11-13-1986',
      ' 7-29-1986',
      NULL,
      ' 2-23-1999',
      ' 7- 8-1994',
      NULL,
      ' 0- 3-1976',
      ' 2-27-1999',
      NULL,
      '11-11-1999',
      '11-15-1999',
      ' 9-27-1995',
      ' 5-22-1975',
      ' 3-23-2001',
      ' 4-17-2003',
      NULL,
      '10-10-2003',
      '10-21-1986',
      ' 5- 9-1980',
      ' 3- 0-1991',
      NULL,
      '11-14-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


