set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4310878';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '1122041',
      2,
      3.299413,
      2,
      '21232',
      2.787557,
      ' 2- 5-1979',
      49,
      NULL,
      0,
      0,
      NULL,
      1,
      0.853392,
      1,
      0,
      1,
      1,
      1.617971,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      55,
      13.881695,
      0,
      3.232132,
      NULL,
      6,
      NULL,
      0.607934,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      2,
      3,
      NULL,
      NULL,
      6,
      1.477745,
      1.872152,
      0.457481,
      1,
      1,
      4,
      5.601388,
      NULL,
      3,
      NULL,
      4,
      3,
      3,
      NULL,
      1.648529,
      0.283082,
      0.965553,
      5.682482,
      NULL,
      17,
      1.928283,
      1.405747,
      2,
      0,
      3,
      1,
      4,
      69.246538,
      166,
      4,
      NULL,
      NULL,
      49,
      233.937476,
      1.037598,
      NULL,
      356.992755,
      0,
      3.583676,
      1.230675,
      561.631095,
      NULL,
      NULL,
      1.325299,
      263.052731,
      NULL,
      2,
      NULL,
      15,
      5,
      0.267181,
      2,
      60,
      5.117390,
      1.313865,
      2.971266,
      323.651596,
      2,
      1,
      NULL,
      731,
      0,
      1,
      0,
      291.632660,
      NULL,
      2.534696,
      NULL,
      739,
      14.686446,
      NULL,
      1,
      59,
      52,
      2,
      NULL,
      373,
      13.528144,
      1.544609,
      NULL,
      600.752237,
      20,
      2,
      2,
      36.258412,
      0.415827,
      0.656233,
      0.753676,
      131,
      NULL,
      1,
      2.811528,
      222.942650,
      38,
      NULL,
      NULL,
      NULL,
      764.704237,
      0.430945,
      1,
      325.578794,
      55,
      NULL,
      0,
      597.993911,
      13.270386,
      1,
      1.404143,
      1003,
      16.474947,
      0.518888,
      3.869720,
      NULL,
      15,
      NULL,
      0,
      486.248420,
      85.575501,
      2.629400,
      0.349304,
      10,
      14,
      NULL,
      0,
      292.157424,
      81,
      1,
      0,
      562,
      82.872875,
      NULL,
      3.911295,
      218.541543,
      NULL,
      1.133962,
      5.689408,
      58,
      15.220427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.905810,
      NULL,
      40,
      88.531683,
      NULL,
      0.791875,
      106.912857,
      59.774183,
      3,
      NULL,
      165.133454,
      5.871143,
      2.548504,
      NULL,
      NULL,
      11,
      3.177917,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '4402',
      '31120',
      '03122',
      '',
      '',
      '',
      3,
      '2131',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      1,
      19.583418,
      0,
      NULL,
      0.591445,
      NULL,
      0.488658,
      NULL,
      2.265781,
      NULL,
      1.687938,
      NULL,
      0,
      NULL,
      1.257162,
      NULL,
      1,
      NULL,
      0.999452,
      NULL,
      NULL,
      16,
      9.315725,
      NULL,
      NULL,
      3.641157,
      0,
      1,
      NULL,
      NULL,
      1,
      4.230628,
      7.645254,
      9,
      NULL,
      NULL,
      17.719403,
      19.546944,
      12,
      1,
      19.690212,
      NULL,
      5,
      21.519588,
      NULL,
      NULL,
      6.275091,
      0.061089,
      1,
      5.936408,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.775670,
      31,
      60,
      7,
      21,
      NULL,
      8,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2.430884,
      21,
      36.956614,
      23.545720,
      3,
      35.783194,
      2.874864,
      54,
      27.563459,
      7.938272,
      37,
      21,
      9.983327,
      10.181151,
      19.931190,
      0.427522,
      13,
      10.462233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.829161,
      48,
      NULL,
      140,
      150,
      25,
      135.505488,
      80,
      0.075889,
      102,
      31,
      NULL,
      109,
      NULL,
      175,
      166.375963,
      NULL,
      183,
      61,
      12,
      174,
      93.375615,
      33.083616,
      NULL,
      40.176132,
      18,
      NULL,
      166,
      103.779606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.926428,
      4.600850,
      0,
      6.501858,
      7,
      1.077322,
      3,
      2,
      1,
      1.555836,
      3.757668,
      0.011325,
      0.731082,
      1.551955,
      0.963060,
      NULL,
      2,
      NULL,
      0.113954,
      NULL,
      1.766333,
      0,
      0.207207,
      0.867661,
      1.482435,
      1,
      1.722592,
      0.939344,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.675199,
      NULL,
      0,
      1.882567,
      1.637664,
      1.988156,
      NULL,
      1,
      0,
      1,
      1.449972,
      0,
      1.023442,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1.443445,
      NULL,
      0,
      0.470800,
      0,
      1,
      NULL,
      0,
      1.943909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.640228,
      NULL,
      0.560271,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0.305659,
      NULL,
      0.747897,
      6.954634,
      0,
      1.982723,
      0,
      NULL,
      1.435132,
      2.329189,
      0.887334,
      0.995642,
      NULL,
      0.213096,
      0.210214,
      NULL,
      1.055743,
      NULL,
      0.296147,
      1.854752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499927,
      0.066515,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.139480,
      0,
      0,
      0.052832,
      1.582011,
      0,
      1.634531,
      0,
      NULL,
      1.989030,
      1.930086,
      0,
      NULL,
      0.723381,
      0,
      1.606042,
      NULL,
      0,
      NULL,
      0,
      1,
      0.059092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292488,
      0.484562,
      1,
      1.591054,
      1.976634,
      1.241634,
      1.462448,
      0,
      NULL,
      1.274584,
      1.792017,
      0,
      1.523454,
      1.032677,
      0,
      0.814497,
      0.627211,
      3.049754,
      3.053791,
      1.465816,
      0.473177,
      4.260022,
      0,
      3,
      1,
      5.635124,
      3,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.419543,
      3,
      4,
      NULL,
      3,
      3,
      NULL,
      3.395487,
      3,
      5.844831,
      2,
      3,
      9.194213,
      7.111377,
      8,
      5.139003,
      0,
      9,
      5,
      4,
      2.241794,
      6.968244,
      2,
      NULL,
      2,
      1.036221,
      3.089716,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.151535,
      1,
      NULL,
      1.383589,
      1.810690,
      3,
      3.689883,
      3,
      NULL,
      5.835790,
      5.318756,
      1,
      3.410446,
      8,
      NULL,
      9,
      NULL,
      3.234526,
      7,
      7.488833,
      6,
      NULL,
      NULL,
      NULL,
      1.293654,
      5.852210,
      8.519857,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      4,
      3.326345,
      5.805095,
      4.944162,
      2.330074,
      0,
      5,
      NULL,
      4,
      NULL,
      2.451764,
      5.802383,
      1.956596,
      NULL,
      8,
      5,
      9,
      6,
      7,
      5,
      1,
      7,
      2.824764,
      6,
      NULL,
      0.674906,
      1.809107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.469540,
      NULL,
      2.184988,
      3,
      0,
      0.082160,
      NULL,
      1,
      3.481943,
      1,
      NULL,
      0,
      4,
      4.864913,
      2.250300,
      1.480999,
      6.206295,
      5.199809,
      5.070466,
      8,
      NULL,
      NULL,
      6.939522,
      NULL,
      4.781138,
      5.225719,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393520,
      1.309117,
      1,
      0,
      1.311151,
      1.152715,
      1.511649,
      1,
      0.748472,
      NULL,
      1.630747,
      NULL,
      0.336381,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.754210,
      1,
      0,
      1.521284,
      0.218211,
      1,
      1,
      1,
      0,
      0,
      1.194050,
      1.005551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705098,
      1,
      0.411300,
      1.968842,
      0.367713,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      0.136571,
      1,
      0,
      0,
      1.205096,
      0,
      0.748196,
      0.745417,
      1.677201,
      0,
      NULL,
      1,
      NULL,
      0,
      0.320759,
      0.744684,
      NULL,
      1.519774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010792,
      6,
      3.378970,
      NULL,
      3.928904,
      0,
      1,
      3.275878,
      NULL,
      6,
      0,
      1.968467,
      11.219963,
      NULL,
      6,
      5.088634,
      1.704733,
      7,
      4,
      7,
      4.069975,
      7.892738,
      NULL,
      1.958354,
      5,
      NULL,
      1.974621,
      0.074164,
      NULL,
      0.872046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.235200,
      0,
      1.556178,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      0.371027,
      3,
      5.110535,
      4.650883,
      4.940499,
      3,
      5.140739,
      6,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.156370,
      0,
      0.861893,
      0,
      0.582997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882133,
      3,
      NULL,
      7,
      3.405266,
      NULL,
      3,
      2.936388,
      3.531140,
      1.755135,
      1,
      1.763245,
      1.097728,
      NULL,
      1,
      NULL,
      1,
      0.961671,
      1.843779,
      0,
      0.911669,
      1,
      0.130532,
      1,
      0.969143,
      1.250524,
      NULL,
      NULL,
      1.326011,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.426099,
      0,
      2,
      3.350171,
      0,
      1.934284,
      2,
      6.819099,
      NULL,
      NULL,
      8.357259,
      1.210322,
      1,
      9,
      2.509530,
      0,
      NULL,
      6.413711,
      NULL,
      NULL,
      3,
      0,
      7.344011,
      4.764021,
      NULL,
      0,
      2.047253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.543624,
      0,
      0,
      1.585505,
      NULL,
      0.448691,
      NULL,
      0.964215,
      1,
      0.183797,
      1.342917,
      1,
      0.399857,
      1,
      0.652597,
      NULL,
      1.369263,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0.315729,
      0.353359,
      NULL,
      1.442387,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.688795,
      NULL,
      4,
      NULL,
      4,
      5.661034,
      5.020423,
      2,
      NULL,
      4,
      NULL,
      7.138518,
      9.444858,
      2.314801,
      5,
      2.254817,
      4,
      NULL,
      3.297132,
      2.755347,
      3,
      NULL,
      2,
      NULL,
      0,
      3.335172,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      5,
      2,
      NULL,
      0,
      5,
      1,
      NULL,
      0,
      4,
      NULL,
      NULL,
      3,
      3,
      2,
      4,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.917517,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      0,
      3,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1978',
      ' 8- 6-1985',
      ' 9-14-1989',
      ' 0- 4-1983',
      ' 0-13-1993',
      NULL,
      ' 3- 0-2002',
      NULL,
      ' 7- 6-1976',
      NULL,
      ' 3-18-1980',
      '10- 0-1976',
      ' 9-15-1984',
      ' 8- 4-1991',
      ' 6-16-1976',
      ' 6- 4-1985',
      NULL,
      ' 3- 0-1987',
      NULL,
      ' 5- 6-1993',
      '11-12-1997',
      ' 6- 8-1980',
      ' 7-27-1977',
      ' 3- 8-1991',
      NULL,
      ' 2-14-1979',
      ' 5-28-1979',
      ' 8-18-2003',
      ' 2-27-1992',
      '10-29-2002',
      '10- 5-1995',
      ' 5-24-1998',
      ' 1- 3-1998',
      NULL,
      ' 6-25-1986',
      '10- 7-1975',
      ' 6-24-1984',
      ' 6- 9-1987',
      NULL,
      ' 1-21-1990',
      '11-13-2001',
      ' 8-18-1983',
      ' 8-24-1979',
      NULL,
      ' 7-19-1990',
      ' 0-26-2003',
      NULL,
      ' 0- 5-1986',
      ' 1- 4-1997',
      ' 4-12-1983',
      NULL,
      ' 6-20-1978',
      NULL,
      ' 4- 1-2000',
      NULL,
      NULL,
      ' 1-12-1993',
      ' 6-20-1996',
      ' 6- 9-1987',
      ' 5-28-1985',
      ' 7-11-1982',
      ' 1-25-2002',
      ' 0- 3-1990',
      ' 4- 5-1992',
      ' 2-20-1980',
      ' 0- 8-1975',
      ' 3-19-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-26-2003',
      ' 4-17-1998',
      ' 6-24-1982',
      ' 0- 7-2003',
      ' 0-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1992',
      '10-20-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      0.968000);
commit;
end;
/


