set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '1230120',
      1,
      3,
      1,
      '20133',
      3.277616,
      ' 4- 9-1989',
      14.016008,
      NULL,
      2,
      1,
      2.182565,
      NULL,
      0,
      1.595637,
      0.999950,
      NULL,
      0,
      1.688832,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      43,
      1.478336,
      4,
      2,
      NULL,
      10,
      0.986301,
      3.871853,
      NULL,
      1,
      3.137140,
      7,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      7,
      2,
      9,
      0,
      0,
      0,
      1,
      1,
      1,
      3,
      1,
      1,
      1.535076,
      6,
      NULL,
      2,
      2,
      NULL,
      0,
      2,
      0.521503,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851540,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      146.453960,
      1.700244,
      NULL,
      0.087027,
      153,
      NULL,
      1,
      7,
      51,
      6,
      3.857543,
      9,
      NULL,
      NULL,
      0.938889,
      2.995386,
      223.522433,
      1.887141,
      1.010884,
      2,
      176.738967,
      1.710068,
      1,
      0.108806,
      475,
      2.424241,
      1.413865,
      7,
      NULL,
      134.161009,
      3.837467,
      6,
      337.814187,
      NULL,
      3.512103,
      0,
      209.947682,
      30.201400,
      NULL,
      9.626105,
      77.499325,
      244,
      1.237415,
      NULL,
      139,
      2,
      2.194023,
      0.865524,
      315,
      0.274103,
      2,
      2,
      212,
      16,
      NULL,
      4,
      0,
      5.170487,
      0.362650,
      0.297919,
      NULL,
      8,
      2,
      0,
      480.902861,
      100,
      2.259204,
      0,
      77.991927,
      13,
      0.077879,
      1.979821,
      NULL,
      7,
      3.392473,
      2,
      108,
      1.795777,
      1.438464,
      2.668535,
      19.552522,
      25.129361,
      2,
      0,
      108,
      11.273421,
      NULL,
      8,
      180,
      7,
      0,
      NULL,
      85,
      4,
      0,
      NULL,
      202.211726,
      3,
      0,
      2,
      NULL,
      NULL,
      1,
      3.882684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.432259,
      '20224',
      '04414',
      '24011',
      '22002',
      '00433',
      '',
      1,
      NULL,
      '',
      '',
      1.507831,
      '',
      '',
      NULL,
      NULL,
      NULL,
      9.410329,
      NULL,
      NULL,
      0,
      NULL,
      0.944988,
      NULL,
      0.134930,
      NULL,
      0,
      NULL,
      1.584821,
      NULL,
      3,
      113.814512,
      NULL,
      10,
      1.399431,
      NULL,
      NULL,
      24.618476,
      3.834601,
      3.209380,
      1.047011,
      2.341191,
      11.429315,
      5,
      16.842780,
      3.294228,
      NULL,
      3.408984,
      1.986043,
      3.582246,
      NULL,
      NULL,
      4,
      8,
      6,
      6,
      15,
      13.230295,
      9,
      8.776083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.697959,
      NULL,
      NULL,
      58.238294,
      2.937859,
      NULL,
      2,
      19,
      9,
      14.000058,
      33.109078,
      29,
      1,
      NULL,
      23,
      39.836220,
      11.992740,
      9,
      2.574633,
      2.264230,
      0.195025,
      5.539385,
      2.916910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      158.407980,
      155.386056,
      NULL,
      137,
      48.169322,
      NULL,
      97.404307,
      10,
      90,
      65.400836,
      151.190268,
      176.343145,
      NULL,
      8.938448,
      92.850740,
      70.956044,
      157.258547,
      45.845485,
      82.020816,
      165,
      39,
      NULL,
      53.451791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716835,
      5.739805,
      NULL,
      0,
      1.192044,
      0.121844,
      0,
      1,
      NULL,
      0,
      0.876021,
      4,
      0,
      0.021914,
      1.607459,
      5.047603,
      5,
      3.773345,
      1.696894,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.968246,
      0,
      1,
      NULL,
      1.733553,
      0,
      1,
      1.962878,
      NULL,
      NULL,
      7,
      4,
      4.517442,
      NULL,
      3,
      NULL,
      0,
      1,
      6,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      4.924523,
      0,
      1,
      1,
      1,
      6.430349,
      3.632454,
      0,
      1.286455,
      2,
      8,
      0.961126,
      1,
      1,
      NULL,
      1.605873,
      NULL,
      6,
      NULL,
      5.406399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843093,
      2.401417,
      3.583716,
      1,
      0.204266,
      0.162507,
      1.669701,
      0.283109,
      4.740819,
      1.549764,
      1,
      3,
      5.530020,
      0.132923,
      0,
      1.389346,
      NULL,
      0.670049,
      1,
      NULL,
      7,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      4.568700,
      NULL,
      2.253192,
      NULL,
      4.086423,
      5,
      0.741901,
      0.677497,
      1.305318,
      5.369380,
      0,
      0.249190,
      3,
      1.460624,
      2.293326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      3,
      3.498858,
      4,
      5,
      1.567439,
      NULL,
      1.101454,
      1.014343,
      1.241678,
      1.686605,
      NULL,
      3.283330,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.738401,
      0.868614,
      1,
      1,
      3,
      2.788387,
      3.752812,
      2.649267,
      NULL,
      0.571293,
      0,
      3,
      4.616316,
      1.051619,
      2.464755,
      0.381888,
      1,
      5.255132,
      3.162480,
      3,
      4.977776,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267571,
      0.763283,
      1.901742,
      0,
      NULL,
      3,
      0,
      1,
      5,
      0.300449,
      1,
      0.832159,
      2.062554,
      7.916203,
      1.361982,
      1,
      NULL,
      1.327248,
      NULL,
      1,
      NULL,
      5.477391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      2.681835,
      3.009185,
      1,
      7.770803,
      4,
      0,
      5,
      1.946963,
      NULL,
      1.844514,
      3,
      2,
      0,
      0.651443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862961,
      4,
      1,
      0.318282,
      0.957708,
      0.862120,
      1,
      0,
      7.923693,
      1.030135,
      1,
      4,
      1.576856,
      1,
      1,
      1.401606,
      0.249478,
      1.145770,
      1,
      0.005566,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848336,
      0.243910,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.940549,
      0.293259,
      1,
      4,
      2.206749,
      1,
      0,
      1.494757,
      0.739499,
      0.350129,
      NULL,
      0,
      0.889712,
      5,
      NULL,
      1.939245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712319,
      0,
      0,
      1,
      4.842470,
      NULL,
      0,
      3.288321,
      0,
      5,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      0.450335,
      0.362961,
      0.519232,
      1,
      2,
      0,
      0.975323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818183,
      NULL,
      NULL,
      1.834295,
      1,
      0.743001,
      0,
      0.159280,
      5,
      NULL,
      1.256039,
      NULL,
      0,
      1.822661,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      2.329803,
      1.092254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      4.586022,
      NULL,
      0,
      3.423631,
      3,
      2.668220,
      2,
      3,
      3,
      3,
      8,
      NULL,
      5.577534,
      5,
      NULL,
      NULL,
      NULL,
      3.797540,
      NULL,
      NULL,
      4.739996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386053,
      2.435622,
      1,
      0.770075,
      2,
      2,
      1,
      0,
      NULL,
      1,
      5.539362,
      NULL,
      3,
      NULL,
      2,
      1,
      3,
      NULL,
      5,
      NULL,
      5.728148,
      1.373458,
      0.800017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680403,
      4,
      1,
      NULL,
      0.814680,
      0.375927,
      0,
      0,
      1.606700,
      0,
      1,
      4,
      1,
      NULL,
      0,
      1,
      NULL,
      1.965407,
      1.700183,
      0.084155,
      1,
      0,
      1.065114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173769,
      1.307038,
      0,
      1,
      NULL,
      0.632390,
      1,
      2,
      4.003375,
      0.303744,
      0,
      0.980522,
      3.579607,
      0,
      1.385227,
      NULL,
      NULL,
      0.031488,
      0.870734,
      0.619808,
      NULL,
      1.831313,
      1.261463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      2,
      5,
      2,
      0,
      0,
      4,
      3,
      1,
      0,
      5,
      1,
      1,
      1,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      3,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      2,
      7,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      3,
      NULL,
      0,
      1,
      3,
      4,
      4,
      3,
      3,
      4,
      4,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 0-2000',
      ' 3- 6-1998',
      ' 2-14-1979',
      NULL,
      '11- 6-1978',
      NULL,
      ' 9- 1-1994',
      '11- 7-1990',
      ' 7-13-1987',
      NULL,
      NULL,
      NULL,
      '11-11-1979',
      ' 4-22-1996',
      ' 6-22-1976',
      NULL,
      NULL,
      ' 5-27-1987',
      ' 4-29-1985',
      ' 5-10-1986',
      ' 8-23-1989',
      NULL,
      ' 6- 1-1994',
      ' 2-21-1992',
      ' 3- 3-1993',
      ' 6-17-1992',
      ' 9-20-1987',
      NULL,
      ' 1-11-2000',
      '10-10-1999',
      NULL,
      ' 0- 3-1990',
      ' 5- 1-1985',
      ' 9-21-1998',
      ' 4-23-1975',
      ' 9-27-1997',
      ' 8-10-2001',
      '11-22-1989',
      ' 5-27-1982',
      ' 4-13-2000',
      ' 1-17-1978',
      NULL,
      ' 8-16-1992',
      ' 0-26-1993',
      ' 5- 8-1983',
      ' 2-25-2000',
      ' 9-10-1982',
      ' 4- 6-1978',
      ' 2-21-1986',
      NULL,
      '11-12-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-2001',
      ' 5-16-1992',
      ' 2- 4-1988',
      NULL,
      ' 6-12-1974',
      ' 8-27-1982',
      ' 8-18-2000',
      ' 2- 8-2001',
      '10- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125005);
commit;
end;
/


