set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '0014230',
      NULL,
      0.311605,
      2,
      '12333',
      0,
      ' 2- 2-1991',
      61,
      NULL,
      NULL,
      1,
      NULL,
      1.606179,
      1.380338,
      0,
      1,
      2,
      2.639448,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765224,
      36,
      0.886736,
      6.876189,
      0,
      NULL,
      3.038439,
      3,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      9,
      10.184095,
      6,
      6,
      3,
      1,
      NULL,
      0.103428,
      1,
      3,
      1,
      7.115397,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      3.621767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.484811,
      NULL,
      1,
      0,
      0,
      3.806488,
      1,
      NULL,
      146,
      NULL,
      1,
      9,
      191,
      9.169869,
      3.999244,
      NULL,
      398.982934,
      56,
      0,
      4.450898,
      393,
      0,
      3,
      0.041633,
      842,
      41,
      2.771397,
      NULL,
      54,
      NULL,
      NULL,
      7,
      38,
      11,
      1.139937,
      8.225923,
      NULL,
      0,
      3.807858,
      NULL,
      166.793325,
      0.563838,
      1,
      7.814710,
      320,
      3.340340,
      1,
      NULL,
      36,
      1,
      0,
      1.045190,
      146.394912,
      NULL,
      1,
      2.560672,
      685,
      NULL,
      NULL,
      7.343417,
      NULL,
      0,
      0,
      3.400483,
      302,
      1.817440,
      1.092100,
      NULL,
      110,
      11,
      NULL,
      6,
      18.873241,
      15,
      NULL,
      0,
      762,
      1,
      NULL,
      NULL,
      429,
      36,
      1,
      5.366137,
      389,
      127.365281,
      1,
      4.912168,
      873.775351,
      124.532884,
      0.791832,
      2.042631,
      NULL,
      3,
      3.421068,
      NULL,
      55.630503,
      0.569791,
      1.274758,
      NULL,
      NULL,
      11,
      NULL,
      0.541491,
      NULL,
      1.970047,
      2,
      3,
      785,
      6,
      3,
      1.226915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.557061,
      NULL,
      '01023',
      '33423',
      '',
      '',
      '',
      3,
      '03240',
      '',
      '',
      2.425671,
      '4114',
      '',
      '',
      2,
      2.357260,
      NULL,
      0.640167,
      NULL,
      0.111611,
      NULL,
      1.794236,
      NULL,
      NULL,
      NULL,
      1.999302,
      NULL,
      1,
      NULL,
      0.488252,
      NULL,
      3,
      338,
      0,
      NULL,
      NULL,
      2.054435,
      NULL,
      2,
      16.539057,
      NULL,
      3.452629,
      NULL,
      3.512104,
      4,
      NULL,
      7.031925,
      2,
      21.560057,
      NULL,
      NULL,
      1.487049,
      5,
      NULL,
      5.844894,
      25.848049,
      NULL,
      4,
      4,
      NULL,
      10,
      NULL,
      14.347147,
      15,
      9.789738,
      18.895542,
      4,
      NULL,
      6.606493,
      3,
      1.419336,
      3.798673,
      2,
      1,
      7,
      5,
      4,
      1,
      NULL,
      3.647157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.490845,
      NULL,
      NULL,
      0,
      NULL,
      10,
      1.167805,
      NULL,
      29.594360,
      NULL,
      4.267782,
      3.256487,
      22,
      NULL,
      12,
      27.253424,
      8.158788,
      14.972990,
      31,
      6,
      28.153537,
      4,
      21,
      11.865346,
      15.265315,
      2,
      6.884701,
      10.774711,
      2,
      NULL,
      7,
      16.703564,
      14,
      6,
      43,
      13.915559,
      3.756711,
      7.396838,
      4,
      12,
      NULL,
      NULL,
      2.921637,
      27.612019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.227664,
      143.186415,
      69.212676,
      133,
      NULL,
      NULL,
      NULL,
      126.263607,
      83,
      NULL,
      60.791765,
      NULL,
      141.535202,
      130.480522,
      14,
      102,
      160,
      134.787666,
      180,
      NULL,
      17,
      106,
      NULL,
      19.746390,
      16.099689,
      9,
      NULL,
      133.198944,
      10,
      114.995312,
      148,
      133.100699,
      13.096489,
      104,
      54.882173,
      NULL,
      NULL,
      72.778496,
      5,
      31.596768,
      NULL,
      187.054754,
      20,
      81.098536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773422,
      1,
      1.503232,
      NULL,
      0.688876,
      NULL,
      6,
      NULL,
      0.992229,
      NULL,
      NULL,
      1,
      1.250140,
      1,
      0,
      1,
      1.820757,
      NULL,
      1,
      0,
      NULL,
      0,
      0.058415,
      0.972382,
      NULL,
      2,
      8,
      5,
      1.875282,
      3,
      NULL,
      0,
      2.408978,
      1,
      0.311443,
      1,
      0.426209,
      0,
      NULL,
      1.126713,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831040,
      1.831373,
      1.842074,
      0.941860,
      0.592239,
      1.965232,
      2.949654,
      1.838963,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1.179274,
      0,
      0,
      0,
      NULL,
      0.587799,
      5.239285,
      NULL,
      NULL,
      0.734209,
      0.216618,
      3,
      2,
      1,
      1,
      1.683040,
      0.542492,
      0.034284,
      0.084617,
      0.720956,
      1,
      0,
      0.650093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      2.071137,
      1.839859,
      4,
      1,
      0,
      0,
      1.834975,
      1.327504,
      1,
      0,
      1.029901,
      NULL,
      NULL,
      NULL,
      1.602803,
      0,
      NULL,
      1.797638,
      1,
      0.367578,
      0.078376,
      0,
      2,
      NULL,
      1.461137,
      NULL,
      1.120287,
      NULL,
      0,
      NULL,
      0.457977,
      1.421108,
      NULL,
      NULL,
      0.889679,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.424794,
      1,
      0.749095,
      0.291506,
      6.211492,
      NULL,
      NULL,
      1.060431,
      1.775254,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.391946,
      0.784386,
      NULL,
      NULL,
      0.307065,
      NULL,
      3.136969,
      NULL,
      4,
      0,
      3.727021,
      NULL,
      3,
      0,
      1.375324,
      1,
      1,
      0.084310,
      1.633286,
      0,
      3.185303,
      0.990022,
      1.545140,
      NULL,
      0.157899,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219695,
      1,
      3.510792,
      3.768402,
      0.247847,
      5,
      6,
      1,
      0,
      1.204198,
      0,
      0,
      0.065190,
      0,
      0.668251,
      NULL,
      2.544508,
      1.723276,
      0,
      0,
      NULL,
      1.200639,
      0,
      NULL,
      0,
      NULL,
      3.251095,
      NULL,
      2,
      1,
      2,
      NULL,
      1,
      1,
      0.909492,
      1,
      0,
      NULL,
      0.741241,
      1,
      0.019873,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.876422,
      1.465295,
      4.376449,
      1,
      5,
      1.207997,
      NULL,
      0.327166,
      7.933194,
      1.723194,
      NULL,
      4.349669,
      7,
      NULL,
      0.628060,
      0.102819,
      5,
      NULL,
      6.878115,
      1.561899,
      4.295566,
      3.959386,
      NULL,
      6,
      6,
      9.988771,
      5,
      0.819990,
      6,
      5,
      6.532922,
      1.873626,
      2,
      4.441927,
      7.710148,
      3.100337,
      4,
      NULL,
      7,
      2,
      NULL,
      5,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.505758,
      NULL,
      2.243365,
      2,
      1,
      2.989279,
      NULL,
      NULL,
      1,
      2,
      4.538309,
      5,
      1.954603,
      NULL,
      4.495173,
      0.821575,
      NULL,
      4,
      NULL,
      4.841917,
      4.088501,
      9.810223,
      6.251543,
      NULL,
      6.167756,
      7.577403,
      2.038046,
      3,
      NULL,
      NULL,
      7.136169,
      NULL,
      2,
      6.071920,
      2,
      0.104401,
      0.743285,
      1,
      7,
      2.791273,
      6.218807,
      5.296086,
      7,
      7.954134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.579025,
      2.693099,
      1.112556,
      NULL,
      2.288847,
      2.914570,
      2,
      0,
      1,
      0,
      0,
      1.639446,
      1.153081,
      2,
      1,
      0.695002,
      0.772923,
      2.340958,
      0.908035,
      0,
      1.724052,
      1.382349,
      0,
      1,
      3,
      5,
      NULL,
      0,
      3.931246,
      1,
      NULL,
      1,
      0.850699,
      NULL,
      1.754211,
      1,
      NULL,
      NULL,
      3.926888,
      NULL,
      2,
      3.756783,
      1,
      0.686943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.547798,
      0,
      4.077473,
      2,
      1.736701,
      2.399539,
      NULL,
      NULL,
      3,
      3.806810,
      1.467933,
      NULL,
      0.934406,
      3.302391,
      3.218801,
      1,
      2.294283,
      0,
      3,
      NULL,
      4,
      NULL,
      3.216618,
      0,
      3.343240,
      NULL,
      0.964709,
      0.456223,
      2.520887,
      NULL,
      3.440566,
      5,
      NULL,
      NULL,
      1.231896,
      0,
      NULL,
      0,
      1.076960,
      1,
      5,
      1.253573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.972434,
      0,
      1.410462,
      0,
      1.555915,
      1.614032,
      NULL,
      0,
      NULL,
      1,
      0,
      0.611708,
      1,
      0,
      NULL,
      NULL,
      1.398156,
      NULL,
      1.886898,
      1.110911,
      1,
      NULL,
      0,
      NULL,
      1.922652,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.976879,
      0,
      1.224782,
      1.050303,
      0,
      NULL,
      0,
      1,
      1.728626,
      1.321376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839588,
      1,
      0,
      0.245911,
      0.734899,
      0,
      0.512368,
      NULL,
      1,
      NULL,
      1,
      0.843665,
      0.996745,
      NULL,
      1.923584,
      NULL,
      1,
      1.609228,
      0.561255,
      0.217028,
      1,
      NULL,
      0.013325,
      0.557090,
      1.110478,
      0,
      1.082572,
      1,
      NULL,
      NULL,
      1.543944,
      0,
      0,
      1.126313,
      0,
      0.819469,
      NULL,
      0,
      NULL,
      1.113812,
      0,
      0.576184,
      3.073033,
      0.392837,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016720,
      0,
      NULL,
      1.089372,
      3.544333,
      0.137274,
      3,
      1,
      0.442191,
      0.348358,
      1.194997,
      0,
      NULL,
      2.894913,
      1,
      NULL,
      3.905971,
      1.033497,
      0.069525,
      1.768924,
      1,
      0.621348,
      1,
      2.656299,
      2,
      3.081592,
      7.732040,
      0,
      NULL,
      0.827562,
      0,
      5,
      3,
      NULL,
      NULL,
      2.330271,
      NULL,
      0.578672,
      NULL,
      0.292744,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.205032,
      0,
      NULL,
      1.114642,
      0,
      6,
      NULL,
      1.557455,
      0,
      3.305724,
      0.672844,
      0.493458,
      1.104083,
      4,
      4,
      2,
      1.664574,
      1.625927,
      1.937925,
      1.485887,
      0.789403,
      1,
      NULL,
      4,
      NULL,
      7,
      NULL,
      3,
      6,
      NULL,
      6,
      4,
      3,
      NULL,
      1.892584,
      3,
      1,
      1,
      1.666756,
      1.727031,
      1,
      3.414278,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843156,
      1.991916,
      0.949094,
      1.600567,
      NULL,
      2.027344,
      1.372704,
      0,
      NULL,
      1.070462,
      NULL,
      0,
      NULL,
      1.953854,
      1.372309,
      1.369678,
      0,
      1.125709,
      0,
      NULL,
      1,
      1.136699,
      0.262084,
      NULL,
      2,
      2.223029,
      3,
      2.828178,
      1,
      1.859881,
      5.886150,
      0.976663,
      0,
      NULL,
      0.637112,
      1.608884,
      0.587637,
      1,
      0.650612,
      1.155946,
      1.088319,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.933605,
      0.500224,
      0,
      3.810454,
      NULL,
      2,
      9,
      2.799813,
      2,
      1,
      4,
      1.435059,
      2.832614,
      7.822323,
      1.571573,
      5,
      5,
      2,
      NULL,
      2,
      4.082455,
      7.902872,
      4,
      NULL,
      3.616979,
      8.717248,
      1,
      5,
      2,
      2.576376,
      2.491792,
      0,
      2.445104,
      NULL,
      4.457594,
      6.859429,
      NULL,
      7,
      NULL,
      5.045182,
      5.629781,
      2.363348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668694,
      0.081090,
      0.143149,
      0.443981,
      0.757746,
      0,
      1,
      1.440688,
      NULL,
      1,
      1.378466,
      0.653862,
      0,
      1.242289,
      1,
      NULL,
      NULL,
      1.701574,
      1,
      1.384103,
      0,
      0,
      0.028006,
      1,
      1.470531,
      0.520733,
      NULL,
      NULL,
      1,
      0,
      1.270231,
      1,
      1,
      0,
      0.668949,
      0.364081,
      NULL,
      1.354237,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.235275,
      3.577594,
      NULL,
      0,
      NULL,
      0.586864,
      0,
      0.780796,
      0.607938,
      0.777635,
      0.212878,
      1.353274,
      1,
      NULL,
      0,
      0.886807,
      0.469538,
      1,
      1.659909,
      1,
      1,
      3,
      2.247930,
      3,
      NULL,
      1.318138,
      2,
      4.216684,
      2,
      1,
      1,
      3,
      2,
      0.221687,
      NULL,
      1,
      NULL,
      1.074291,
      0.631937,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      2,
      NULL,
      0,
      2,
      1,
      2,
      1,
      1,
      3,
      3,
      3,
      1,
      NULL,
      1,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      3,
      5,
      NULL,
      3,
      2,
      7,
      0,
      2,
      5,
      0,
      2,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      3,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      3,
      2,
      0,
      3,
      2,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      0,
      2,
      0,
      3,
      NULL,
      NULL,
      3,
      3,
      0,
      2,
      3,
      5,
      1,
      NULL,
      3,
      NULL,
      2,
      4,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      5,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1987',
      NULL,
      ' 4- 6-2002',
      ' 5- 1-1986',
      ' 7- 0-1974',
      ' 1-28-1980',
      ' 1- 2-1989',
      NULL,
      ' 9-21-1992',
      NULL,
      NULL,
      ' 0-19-1997',
      ' 9-21-1982',
      '11- 4-1991',
      ' 4- 8-1999',
      ' 2- 8-1998',
      NULL,
      ' 4- 1-1992',
      '11-27-1976',
      ' 0-20-1995',
      '11- 3-1975',
      ' 1-20-1989',
      ' 8- 4-1997',
      ' 9-12-2001',
      ' 7-24-1980',
      ' 7-26-1984',
      ' 4-18-1974',
      ' 8-20-1992',
      ' 1-12-1983',
      NULL,
      ' 0- 8-1980',
      '11- 7-1992',
      NULL,
      ' 6-23-1983',
      ' 0- 1-1979',
      ' 1-26-1988',
      NULL,
      ' 0-17-2002',
      NULL,
      ' 4-10-1976',
      ' 4-24-1989',
      NULL,
      NULL,
      ' 5-26-1996',
      ' 9-25-1994',
      '11-18-1981',
      ' 9-10-1985',
      NULL,
      NULL,
      ' 9- 9-1985',
      ' 0- 0-1977',
      '11- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1984',
      NULL,
      ' 0-20-1990',
      ' 5-18-1997',
      ' 2-12-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-23-1990',
      ' 9-13-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0.449942);
commit;
end;
/


