set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '21310431',
      4.743767,
      50.555036,
      '3214001',
      0,
      4.845414,
      3,
      '03334',
      4.659263,
      ' 4-29-1998',
      126,
      NULL,
      NULL,
      2,
      NULL,
      1.190757,
      0,
      1,
      0,
      3.944365,
      1,
      1.212115,
      1,
      7,
      NULL,
      NULL,
      0,
      NULL,
      1,
      7,
      9.293415,
      7.509329,
      3,
      NULL,
      4.609419,
      4.181707,
      NULL,
      4,
      NULL,
      NULL,
      2,
      0,
      NULL,
      4,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      4,
      7,
      NULL,
      1,
      0.647627,
      0.456301,
      0.164681,
      NULL,
      1,
      5.329190,
      1.648836,
      NULL,
      7,
      4.789062,
      4,
      5.499057,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.870756,
      1,
      3,
      NULL,
      2,
      NULL,
      6,
      NULL,
      249,
      119,
      3.876304,
      NULL,
      105.006179,
      5,
      3.935634,
      2.039945,
      208,
      3.026993,
      1.454077,
      0,
      390,
      40,
      3,
      2.922923,
      NULL,
      3.118692,
      0.726269,
      1.938582,
      703.060347,
      71.172980,
      2,
      3,
      218.649829,
      31,
      0,
      0.678202,
      164.120545,
      5.694183,
      3,
      0.724220,
      1015.920632,
      NULL,
      0,
      0,
      53.896021,
      115,
      NULL,
      2.301025,
      119,
      5,
      0,
      3.344362,
      249,
      NULL,
      3.011951,
      1,
      307,
      3.035540,
      NULL,
      NULL,
      15,
      1,
      0,
      2.779980,
      211.601683,
      0.692238,
      0,
      3,
      26,
      44.389081,
      NULL,
      3,
      65,
      NULL,
      NULL,
      0.102818,
      164.138026,
      NULL,
      1,
      5.616633,
      179,
      10.909655,
      NULL,
      5,
      NULL,
      NULL,
      2.996815,
      2.528128,
      104,
      39,
      NULL,
      3,
      NULL,
      2.851758,
      0.397749,
      5.405387,
      NULL,
      3.949170,
      3.850629,
      0.560153,
      1383,
      4,
      2,
      NULL,
      1335.004763,
      13,
      0.118640,
      6,
      111.024818,
      7,
      1.021471,
      NULL,
      148,
      8,
      3.641746,
      1.525783,
      234.255198,
      NULL,
      1.214529,
      NULL,
      111.199881,
      NULL,
      3,
      NULL,
      247,
      1,
      1,
      1.071664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '34044',
      '34313',
      '',
      '',
      NULL,
      '',
      0.860547,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      0.066089,
      NULL,
      2.504362,
      501.721081,
      0,
      NULL,
      NULL,
      NULL,
      0.232099,
      8.867346,
      0.517611,
      NULL,
      NULL,
      NULL,
      1.340980,
      351,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.010168,
      11.014892,
      13,
      NULL,
      1,
      6.526677,
      4.194566,
      3,
      5.493750,
      2,
      2,
      1.283637,
      0,
      0,
      10,
      NULL,
      NULL,
      3.809957,
      3,
      7,
      NULL,
      13,
      0.629794,
      2.185321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      4.644468,
      26,
      9.626768,
      NULL,
      1.235674,
      7.902541,
      7,
      13,
      20,
      12.019393,
      23,
      22.801103,
      36,
      NULL,
      9,
      1.325102,
      1,
      2,
      9,
      36.437145,
      2,
      16,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      147.652088,
      13.217368,
      64.924906,
      29.132943,
      0,
      1.236520,
      NULL,
      2,
      0,
      1.443231,
      2,
      NULL,
      3.623647,
      2,
      4,
      NULL,
      5.837050,
      2,
      1.176903,
      NULL,
      2.226856,
      6,
      4,
      3,
      7.342635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.788891,
      6.843297,
      6.299227,
      NULL,
      7.799953,
      5,
      NULL,
      6,
      4.232958,
      8.328311,
      10,
      NULL,
      0.000394,
      2.029920,
      2,
      4,
      3.724466,
      6,
      2.579463,
      5.782708,
      7,
      7,
      6,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      7,
      4,
      6,
      NULL,
      5.954779,
      11,
      NULL,
      NULL,
      4.797582,
      3.422754,
      NULL,
      NULL,
      9.265536,
      3,
      0,
      4.538878,
      3.142272,
      NULL,
      2.316973,
      NULL,
      2,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437715,
      1,
      0.662167,
      4,
      0.639661,
      0,
      0.820912,
      2.917957,
      1.392106,
      4,
      0.591926,
      0.994931,
      0,
      4,
      3,
      2.135510,
      0.762008,
      NULL,
      0.562754,
      5,
      1,
      2.557217,
      6.311850,
      6,
      7,
      1.542389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.888780,
      1,
      1,
      NULL,
      0.165151,
      0.115978,
      NULL,
      2,
      3,
      1,
      3,
      3.064581,
      1,
      0,
      1.562414,
      1,
      0.225262,
      0,
      1.300497,
      1.058987,
      1.478416,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.900698,
      5,
      0.164032,
      3.228148,
      0,
      2.451762,
      4,
      4,
      5.843216,
      4.327904,
      4.835985,
      2.369551,
      NULL,
      5,
      2.005394,
      0,
      2,
      5.315380,
      0,
      5.230533,
      5,
      3.468923,
      4.567189,
      2.284873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.391852,
      1,
      0.147691,
      2.027087,
      7.220968,
      0,
      NULL,
      NULL,
      9.087094,
      2,
      5,
      NULL,
      NULL,
      6.610507,
      0,
      4.412118,
      5,
      4,
      NULL,
      4.600666,
      8.864955,
      NULL,
      3.490948,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.390393,
      8,
      5,
      NULL,
      5.355791,
      NULL,
      3.488379,
      4,
      NULL,
      3.467436,
      NULL,
      10,
      3,
      10,
      NULL,
      4.344004,
      4.696846,
      9.214791,
      5.498396,
      1.924324,
      NULL,
      6.635844,
      3.954993,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      5,
      3,
      3,
      NULL,
      3.859535,
      NULL,
      2.880759,
      2,
      5.320278,
      6.596357,
      NULL,
      0.211756,
      NULL,
      3.516838,
      6,
      3.780764,
      3.308164,
      6.331056,
      NULL,
      NULL,
      1.976314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.221529,
      1,
      0.724833,
      1,
      1,
      1.118513,
      0,
      0,
      0.274704,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.773515,
      NULL,
      0.135126,
      1.203328,
      1.833140,
      NULL,
      1.313807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.659914,
      1.448787,
      NULL,
      NULL,
      0,
      1,
      1,
      0.763310,
      0,
      1,
      1.466015,
      1.517030,
      0.626566,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392190,
      1,
      1,
      1.948096,
      0.952497,
      1.790586,
      0.915021,
      1,
      NULL,
      1.153745,
      NULL,
      1.571179,
      0,
      NULL,
      1.895480,
      1,
      1.481233,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1.311101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.548477,
      5,
      0.267393,
      1,
      1,
      1.022695,
      NULL,
      0.955856,
      1,
      0,
      1,
      NULL,
      0.666248,
      0,
      1,
      1,
      0.918379,
      1.999723,
      1,
      0,
      1.937540,
      1.276060,
      NULL,
      NULL,
      1,
      1.648636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.913236,
      1,
      0,
      1.996279,
      5.587942,
      0.719158,
      NULL,
      1.936209,
      1.253377,
      1.986846,
      1,
      NULL,
      1.047815,
      0,
      5,
      1,
      3.437627,
      NULL,
      NULL,
      1.478322,
      1.626475,
      6.174752,
      3.581502,
      2.940257,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.519497,
      0.371688,
      5.538723,
      6.462501,
      6,
      5.390785,
      2,
      NULL,
      9,
      9.202131,
      NULL,
      NULL,
      0.390839,
      10.874877,
      6.324508,
      4.986462,
      2,
      5,
      7,
      7,
      5.994615,
      NULL,
      10,
      0.466109,
      NULL,
      2.310602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.725699,
      1.158036,
      4.341068,
      3.389563,
      4.625586,
      6.204196,
      1,
      8,
      5,
      8.593272,
      NULL,
      9,
      9.454756,
      3.571667,
      0,
      7,
      2,
      7,
      4,
      NULL,
      NULL,
      7.151880,
      9,
      8.231298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533582,
      NULL,
      0,
      1,
      0,
      NULL,
      1.911393,
      NULL,
      1,
      1,
      1.860593,
      NULL,
      1.693445,
      0,
      1.401532,
      NULL,
      1,
      NULL,
      1,
      1,
      0.174804,
      0.206517,
      0,
      0.284564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986010,
      NULL,
      5.942745,
      1.030608,
      1,
      NULL,
      1,
      1.880448,
      0,
      1.448205,
      1,
      0,
      1.091937,
      0.937079,
      1.901167,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0.053351,
      NULL,
      0,
      1.137309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      6,
      5,
      6,
      NULL,
      7,
      1,
      5,
      1,
      7,
      1,
      5,
      1,
      2,
      2,
      1,
      NULL,
      0,
      4,
      5,
      NULL,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      5,
      3,
      5,
      3,
      4,
      1,
      3,
      NULL,
      5,
      NULL,
      4,
      2,
      1,
      3,
      NULL,
      NULL,
      3,
      3,
      5,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-13-2001',
      '11-17-1991',
      ' 5- 6-2003',
      NULL,
      '10- 3-1984',
      ' 0- 0-1985',
      ' 3-11-1998',
      ' 0- 1-1999',
      ' 1-10-1977',
      ' 7-23-1993',
      '10- 6-1977',
      NULL,
      ' 3-20-1977',
      ' 1- 8-1987',
      '11-21-2002',
      ' 5-28-1978',
      ' 0-15-1999',
      ' 1- 4-1975',
      ' 7- 5-1989',
      ' 9- 8-1979',
      ' 2-10-1998',
      ' 6-29-1982',
      NULL,
      ' 0- 8-1998',
      '11-29-1977',
      '10-14-1985',
      NULL,
      ' 4- 8-1999',
      NULL,
      ' 8-12-1975',
      NULL,
      '11-10-1994',
      '11- 8-1996',
      '10-17-1983',
      NULL,
      ' 7-16-1981',
      '11-10-1982',
      '11-21-1984',
      ' 5-22-1974',
      ' 6-29-1995',
      NULL,
      ' 7- 0-1994',
      ' 2-20-1974',
      ' 7-22-1998',
      ' 8- 6-1978',
      ' 9- 8-1990',
      NULL,
      ' 9-29-1999',
      ' 9-29-1974',
      NULL,
      ' 3-28-1990',
      ' 0-23-1990',
      ' 1- 5-1990',
      ' 4-10-1985',
      ' 8-24-1989',
      ' 8- 3-1975',
      ' 7-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967976);
commit;
end;
/


